/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

class BetweenPredicate
extends AbstractPredicate {
    private final boolean negative;
    private Expression<?> expression;
    private Expression<?> min;
    private Expression<?> max;

    public BetweenPredicate(boolean negative, Expression<?> expression, Expression<?> min, Expression<?> max) {
        this.negative = negative;
        this.expression = expression;
        this.min = min;
        this.max = max;
        Literals.bind(min, expression);
        Literals.bind(min, expression);
    }

    @Override
    public int precedence() {
        return 7;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
        ((Ast)((Object)this.min)).accept(visitor);
        ((Ast)((Object)this.max)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        this.renderChild((Ast)((Object)this.expression), builder);
        builder.sql(this.negative ? " not between " : " between ");
        this.renderChild((Ast)((Object)this.min), builder);
        builder.sql(" and ");
        this.renderChild((Ast)((Object)this.max), builder);
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return BetweenPredicate.hasVirtualPredicate(this.expression) || BetweenPredicate.hasVirtualPredicate(this.min) || BetweenPredicate.hasVirtualPredicate(this.max);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.expression = ctx.resolveVirtualPredicate(this.expression);
        this.min = ctx.resolveVirtualPredicate(this.min);
        this.max = ctx.resolveVirtualPredicate(this.max);
        return this;
    }

    @Override
    public Predicate not() {
        return new BetweenPredicate(!this.negative, this.expression, this.min, this.max);
    }

    public int hashCode() {
        return Objects.hash(this.negative, this.expression, this.min, this.max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BetweenPredicate)) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return this.negative == that.negative && this.expression.equals(that.expression) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }
}

