/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.PredicateImplementor;
import org.babyfish.jimmer.sql.ast.impl.PredicateWrapper;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicate;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicateMergedResult;
import org.babyfish.jimmer.sql.ast.impl.base.BaseQueryScope;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionAliasRender;
import org.babyfish.jimmer.sql.ast.impl.base.BaseSelectionMapper;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableImplementor;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableOwner;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbol;
import org.babyfish.jimmer.sql.ast.impl.base.BaseTableSymbols;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedBaseQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableStatementImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.BaseTableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTypeMergeScope;
import org.babyfish.jimmer.sql.ast.impl.table.RealTable;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableLikeImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractIdentityDataManager;
import org.babyfish.jimmer.sql.ast.query.ConfigurableBaseQuery;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.AbstractTypedTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableLike;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.Nullable;

public class AstContext
extends AbstractIdentityDataManager<RealTable, TableUsedState>
implements RootTableResolver {
    private final JSqlClientImplementor sqlClient;
    private StatementFrame statementFrame;
    private JoinTypeMergeFrame joinTypeMergeFrame;
    private BaseTableRenderFrame baseTableRenderFrame;
    private int modCount;
    private Set<MergedBaseQueryImpl<?>> visitingRecursiveMergedQueries;

    public AstContext(JSqlClientImplementor sqlClient) {
        this.sqlClient = sqlClient;
    }

    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    @Override
    protected TableUsedState createValue(RealTable key) {
        return TableUsedState.ID_ONLY;
    }

    public void useTableId(RealTable table) {
        this.getOrCreateValue(table);
    }

    public void useTable(RealTable table) {
        this.putValue(table, TableUsedState.USED);
    }

    public TableUsedState getTableUsedState(RealTable table) {
        TableUsedState state = (TableUsedState)((Object)this.getValue(table));
        return state != null ? state : TableUsedState.NONE;
    }

    public void pushStatement(AbstractMutableStatementImpl statement) {
        this.statementFrame = new StatementFrame(statement, this.statementFrame);
    }

    public void popStatement() {
        this.statementFrame = this.statementFrame.parent;
    }

    public void pushRenderedBaseTable(RealTable realBaseTable) {
        this.baseTableRenderFrame = new BaseTableRenderFrame(this.baseTableRenderFrame, realBaseTable);
    }

    public void popRenderedBaseTable() {
        this.baseTableRenderFrame = this.baseTableRenderFrame.parent;
    }

    @Override
    public <E> TableImplementor<E> resolveRootTable(Table<E> table) {
        if (table instanceof TableImplementor) {
            return (TableImplementor)table;
        }
        TableImplementor tableImplementor = ((TableProxy)table).__unwrap();
        if (tableImplementor != null) {
            return tableImplementor;
        }
        StatementFrame frame = this.statementFrame;
        while (frame != null) {
            TableImplementor<?> resolved;
            AbstractMutableStatementImpl statement = frame.statement;
            Object stmtTable = statement.getTable();
            BaseTableOwner baseTableOwner = BaseTableOwner.of(table);
            if (stmtTable instanceof BaseTableSymbol) {
                resolved = this.resolve(statement, (BaseTableSymbol)stmtTable, table);
                if (resolved != null) {
                    return resolved.baseTableOwner(baseTableOwner);
                }
            } else if (baseTableOwner != null && baseTableOwner.getBaseTable().getParent() != null) {
                resolved = this.resolve(statement, baseTableOwner.getBaseTable(), table);
                if (resolved != null) {
                    return resolved.baseTableOwner(baseTableOwner);
                }
            } else if (AbstractTypedTable.__refEquals(stmtTable, table)) {
                tableImplementor = (TableImplementor)statement.getTableLikeImplementor();
                return tableImplementor.baseTableOwner(baseTableOwner);
            }
            frame = frame.parent;
        }
        TableProxy tableProxy = (TableProxy)table;
        if (tableProxy.__parent() != null) {
            throw new IllegalArgumentException("\"" + AstContext.class.getName() + ".resolveRootTable\" only does not accept non-root table, you can use \"" + TableProxies.class.getName() + ".resolve\"");
        }
        throw new IllegalArgumentException("Cannot resolve the root table " + table);
    }

    private TableImplementor<?> resolve(AbstractMutableStatementImpl statement, BaseTableSymbol rootBaseTableSymbol, Table<?> table) {
        TableImplementor<?> resolved = rootBaseTableSymbol.getQuery().resolveRootTable(table);
        if (resolved != null) {
            return resolved;
        }
        if (!(table instanceof TableProxy)) {
            return null;
        }
        BaseTableOwner baseTableOwner = ((TableProxy)table).__baseTableOwner();
        if (baseTableOwner == null) {
            return null;
        }
        BaseTableImplementor baseTableImplementor = this.resolveBaseTable(statement, baseTableOwner.getBaseTable());
        return baseTableImplementor.getQuery().resolveRootTable(table);
    }

    public BaseTableImplementor resolveBaseTable(BaseTableSymbol baseTable) {
        StatementFrame frame = this.statementFrame;
        while (frame != null) {
            BaseTableImplementor baseTableImplementor = this.resolveBaseTable(frame.statement, baseTable);
            if (baseTableImplementor != null) {
                return baseTableImplementor;
            }
            frame = frame.parent;
        }
        return null;
    }

    private BaseTableImplementor resolveBaseTable(AbstractMutableStatementImpl statement, BaseTableSymbol baseTable) {
        TableLikeImplementor parentImplementor;
        TableLike<?> parent = baseTable.getParent();
        if (parent == null) {
            TableLikeImplementor<?> implementor = statement.getTableLikeImplementor();
            if (implementor instanceof BaseTableImplementor) {
                return (BaseTableImplementor)implementor;
            }
            return null;
        }
        TableLikeImplementor tableLikeImplementor = parentImplementor = parent instanceof BaseTableSymbol ? this.resolveBaseTable(statement, (BaseTableSymbol)parent) : TableProxies.resolve((Table)parent, this);
        if (parentImplementor == null) {
            return null;
        }
        BaseTableSymbol recursive = baseTable.getRecursive();
        BaseTableImplementor recursiveImplementor = recursive != null ? this.resolveBaseTable(recursive) : null;
        return BaseTableImpl.of(baseTable, parentImplementor, recursiveImplementor);
    }

    public AbstractMutableStatementImpl getStatement() {
        return this.statementFrame.statement;
    }

    public JoinTypeMergeScope getJoinTypeMergeScope() {
        JoinTypeMergeFrame frame = this.joinTypeMergeFrame;
        return frame != null ? frame.scope : null;
    }

    public void pushJoinTypeMergeScope(JoinTypeMergeScope scope) {
        this.joinTypeMergeFrame = new JoinTypeMergeFrame(scope, this.joinTypeMergeFrame);
    }

    public void popJoinTypeMergeScope() {
        this.joinTypeMergeFrame = this.joinTypeMergeFrame.parent;
    }

    public void pushVirtualPredicateContext(VirtualPredicate.Op op) {
        this.statementFrame.pushVpf(op);
    }

    public void popVirtualPredicateContext() {
        this.statementFrame.popVpf();
    }

    public <T> T resolveVirtualPredicate(T expression) {
        if (expression == null) {
            return null;
        }
        Unwrapped<Predicate> unwrapped = Unwrapped.of(expression);
        if (unwrapped.value instanceof VirtualPredicate) {
            Predicate resolved = this.statementFrame.peekVpf().add((VirtualPredicate)unwrapped.value);
            return (T)unwrapped.wrapAgain(resolved);
        }
        if (expression instanceof Ast && ((Ast)expression).hasVirtualPredicate()) {
            return (T)((Ast)expression).resolveVirtualPredicate(this);
        }
        if (expression instanceof MutableStatementImplementor && ((MutableStatementImplementor)expression).hasVirtualPredicate()) {
            ((MutableStatementImplementor)expression).resolveVirtualPredicate(this);
            return expression;
        }
        return expression;
    }

    public <T> List<T> resolveVirtualPredicates(List<T> expressions) {
        boolean changed = false;
        for (T expression : expressions) {
            if (!(expression instanceof Ast) || !((Ast)expression).hasVirtualPredicate()) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return expressions;
        }
        ArrayList<T> newExpressions = new ArrayList<T>(expressions.size());
        for (T expression : expressions) {
            T newExpression = this.resolveVirtualPredicate(expression);
            if (newExpression == null) continue;
            newExpressions.add(newExpression);
        }
        VirtualPredicateMergedResult.removeEmptyResult(newExpressions);
        return newExpressions;
    }

    public Predicate[] resolveVirtualPredicates(Predicate[] predicates) {
        boolean changed = false;
        for (Predicate predicate : predicates) {
            if (!((Ast)((Object)predicate)).hasVirtualPredicate()) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return predicates;
        }
        ArrayList<Predicate> newPredicates = new ArrayList<Predicate>(predicates.length);
        for (Predicate predicate : predicates) {
            Predicate newPredicate = this.resolveVirtualPredicate(predicate);
            if (newPredicate == null) continue;
            newPredicates.add(newPredicate);
        }
        VirtualPredicateMergedResult.removeEmptyResult(newPredicates);
        return newPredicates.toArray(PredicateImplementor.EMPTY_PREDICATES);
    }

    public int modCount() {
        return this.modCount;
    }

    @Nullable
    public BaseSelectionMapper getBaseSelectionMapper(BaseTableOwner baseTableOwner) {
        if (baseTableOwner == null) {
            return null;
        }
        BaseTableSymbol recursive = baseTableOwner.getBaseTable().getRecursive();
        if (recursive != null) {
            baseTableOwner = new BaseTableOwner(recursive, baseTableOwner.getIndex());
        }
        BaseTableSymbol baseTable = baseTableOwner.getBaseTable();
        boolean cte = baseTable.isCte();
        StatementFrame frame = this.statementFrame;
        while (frame != null && frame.usingBaseQuery) {
            if (BaseTableSymbols.contains(frame.statement.getTable(), baseTable)) {
                BaseQueryScope scope = frame.baseQueryScope();
                MergedBaseQueryImpl<?> mergedBy = MergedBaseQueryImpl.from(baseTable.getQuery());
                if (mergedBy != null) {
                    for (ConfigurableBaseQueryImpl<?> itemQuery : mergedBy.getExpandedQueries()) {
                        scope.mapper(new BaseTableOwner((BaseTable)itemQuery.asBaseTable(null, cte), baseTableOwner.getIndex()));
                    }
                }
                return scope.mapper(baseTableOwner);
            }
            frame = frame.parent;
        }
        return null;
    }

    @Nullable
    public BaseSelectionAliasRender getBaseSelectionRender(ConfigurableBaseQuery<?> query) {
        StatementFrame frame = this.statementFrame;
        while (frame != null && frame.usingBaseQuery) {
            if (TableUtils.hasBaseTable(frame.statement.getTableLikeImplementor())) {
                return frame.baseQueryScope().toBaseSelectionRender(query);
            }
            frame = frame.parent;
        }
        return null;
    }

    public RealTable getRenderedRealBaseTable() {
        BaseTableRenderFrame frame = this.baseTableRenderFrame;
        if (frame != null && frame.realTable != null) {
            return frame.realTable;
        }
        throw new IllegalStateException("No rendered real base table");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitRecursiveQuery(MergedBaseQueryImpl<?> query, Runnable runnable) {
        if (!query.isRecursive()) {
            runnable.run();
            return;
        }
        Set<MergedBaseQueryImpl<?>> set = this.visitingRecursiveMergedQueries;
        if (set == null) {
            set = new HashSet();
            this.visitingRecursiveMergedQueries = set;
        }
        if (set.add(query)) {
            try {
                runnable.run();
            }
            finally {
                set.remove(query);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean addSp = false;
        StatementFrame frame = this.statementFrame;
        while (frame != null) {
            if (addSp) {
                builder.append("->");
            } else {
                addSp = true;
            }
            builder.append(frame.statement);
            frame = frame.parent;
        }
        return builder.toString();
    }

    private class StatementFrame {
        final AbstractMutableStatementImpl statement;
        final StatementFrame parent;
        final boolean usingBaseQuery;
        private VirtualPredicateFrame vpFrame;
        private BaseQueryScope baseQueryScope;
        private boolean baseQueryResolved;

        private StatementFrame(AbstractMutableStatementImpl statement, StatementFrame parent) {
            boolean usingBaseQuery;
            this.statement = statement;
            this.parent = parent;
            if (parent != null && parent.usingBaseQuery) {
                usingBaseQuery = true;
            } else {
                TableLikeImplementor<?> tableLikeImplementor = statement.getTableLikeImplementor();
                usingBaseQuery = TableUtils.hasBaseTable(tableLikeImplementor);
            }
            this.usingBaseQuery = usingBaseQuery;
        }

        public VirtualPredicateFrame peekVpf() {
            VirtualPredicateFrame vpFrame = this.vpFrame;
            if (vpFrame == null) {
                this.vpFrame = vpFrame = new VirtualPredicateFrame(VirtualPredicate.Op.AND, null);
            }
            return vpFrame;
        }

        public void pushVpf(VirtualPredicate.Op op) {
            this.vpFrame = new VirtualPredicateFrame(op, this.peekVpf());
        }

        public void popVpf() {
            this.vpFrame = this.vpFrame.parent;
        }

        public BaseQueryScope baseQueryScope() {
            if (!this.baseQueryResolved) {
                this.baseQueryScope = this.createBaseQueryScope();
                this.baseQueryResolved = true;
            }
            return this.baseQueryScope;
        }

        private BaseQueryScope createBaseQueryScope() {
            if (!this.usingBaseQuery) {
                return null;
            }
            return new BaseQueryScope(AstContext.this);
        }
    }

    private static class BaseTableRenderFrame {
        final BaseTableRenderFrame parent;
        final RealTable realTable;

        BaseTableRenderFrame(BaseTableRenderFrame parent, RealTable realTable) {
            this.parent = parent;
            this.realTable = realTable;
        }

        public String toString() {
            return "BaseTableRenderFrame{parent=" + this.parent + ", realTable=" + this.realTable + '}';
        }
    }

    private static class JoinTypeMergeFrame {
        final JoinTypeMergeScope scope;
        final JoinTypeMergeFrame parent;

        JoinTypeMergeFrame(JoinTypeMergeScope scope, JoinTypeMergeFrame parent) {
            this.scope = scope;
            this.parent = parent;
        }
    }

    private static class Unwrapped<T> {
        final T value;
        private final PredicateWrapper wrapper;

        private Unwrapped(T value, PredicateWrapper wrapper) {
            this.value = value;
            this.wrapper = wrapper;
        }

        static <T> Unwrapped<T> of(T value) {
            if (!(value instanceof PredicateWrapper)) {
                return new Unwrapped<T>(value, null);
            }
            PredicateWrapper wrapper = (PredicateWrapper)value;
            return new Unwrapped<Object>(wrapper.unwrap(), wrapper);
        }

        T wrapAgain(T value) {
            PredicateWrapper wrapper = this.wrapper;
            if (wrapper != null && value != null) {
                return (T)wrapper.wrap(value);
            }
            return value;
        }
    }

    private class VirtualPredicateFrame
    extends AbstractDataManager<VirtualPredicate, VirtualPredicateMergedResult> {
        private final VirtualPredicate.Op op;
        private final VirtualPredicateFrame parent;

        private VirtualPredicateFrame(VirtualPredicate.Op op, VirtualPredicateFrame parent) {
            this.op = op;
            this.parent = parent;
        }

        @Override
        protected int hashCode(VirtualPredicate key) {
            return System.identityHashCode(key.getTableImplementor(AstContext.this)) ^ key.getSubKey().hashCode();
        }

        @Override
        protected boolean equals(VirtualPredicate key1, VirtualPredicate key2) {
            return key1.getSubKey().equals(key2.getSubKey()) && key1.getTableImplementor(AstContext.this) == key2.getTableImplementor(AstContext.this);
        }

        public Predicate add(VirtualPredicate virtualPredicate) {
            VirtualPredicateMergedResult result = (VirtualPredicateMergedResult)this.getValue(virtualPredicate);
            if (result != null) {
                result.merge(virtualPredicate);
                return null;
            }
            result = new VirtualPredicateMergedResult(AstContext.this.getStatement(), this.op);
            this.putValue(virtualPredicate, result);
            result.merge(virtualPredicate);
            AstContext.this.modCount++;
            return result;
        }
    }
}

