/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

public enum SqlTimeUnit {
    NANOSECONDS,
    MICROSECONDS,
    MILLISECONDS,
    SECONDS,
    MINUTES,
    HOURS,
    DAYS,
    WEEKS,
    MONTHS,
    QUARTERS,
    YEARS,
    DECADES,
    CENTURIES;


    public Optional<TimeUnit> toJdkTimeUnit() {
        switch (this.ordinal()) {
            case 0: {
                return Optional.of(TimeUnit.NANOSECONDS);
            }
            case 1: {
                return Optional.of(TimeUnit.MICROSECONDS);
            }
            case 2: {
                return Optional.of(TimeUnit.MILLISECONDS);
            }
            case 3: {
                return Optional.of(TimeUnit.SECONDS);
            }
            case 4: {
                return Optional.of(TimeUnit.MINUTES);
            }
            case 5: {
                return Optional.of(TimeUnit.HOURS);
            }
            case 6: {
                return Optional.of(TimeUnit.DAYS);
            }
        }
        return Optional.empty();
    }

    public static SqlTimeUnit fromJdkTimeUnit(TimeUnit jdkTimeUnit) {
        switch (jdkTimeUnit) {
            case NANOSECONDS: {
                return NANOSECONDS;
            }
            case MICROSECONDS: {
                return MICROSECONDS;
            }
            case MILLISECONDS: {
                return MILLISECONDS;
            }
            case SECONDS: {
                return SECONDS;
            }
            case MINUTES: {
                return MINUTES;
            }
            case HOURS: {
                return HOURS;
            }
            case DAYS: {
                return DAYS;
            }
        }
        throw new IllegalArgumentException("Unsupported jdk timeunit");
    }
}

