/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.time.temporal.Temporal;
import java.util.Date;
import org.babyfish.jimmer.EmbeddableDto;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.DateExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TemporalExpressionImplementor;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.NotNull;

public interface PropExpression<T>
extends Expression<T> {

    public static interface Embedded<T>
    extends PropExpression<T> {
        public <XE extends Expression<?>> XE get(String var1);

        public <XE extends Expression<?>> XE get(ImmutableProp var1);

        public Selection<T> fetch(Fetcher<T> var1);

        public <D extends EmbeddableDto<T>> Selection<D> fetch(Class<D> var1);

        @Override
        @NotNull
        default public Expression<T> coalesce(T defaultValue) {
            throw new UnsupportedOperationException("Embedded property does not support coalesce");
        }

        @Override
        @NotNull
        default public Expression<T> coalesce(Expression<T> defaultExpr) {
            throw new UnsupportedOperationException("Embedded property does not support coalesce");
        }

        @Override
        @NotNull
        default public CoalesceBuilder<T> coalesceBuilder() {
            throw new UnsupportedOperationException("Embedded property does not support coalesce");
        }
    }

    public static interface Cmp<T extends Comparable<?>>
    extends PropExpression<T>,
    ComparableExpressionImplementor<T> {
    }

    public static interface Tp<T extends Temporal & Comparable<?>>
    extends PropExpression<T>,
    TemporalExpressionImplementor<T> {
    }

    public static interface Dt<T extends Date>
    extends PropExpression<T>,
    DateExpressionImplementor<T> {
    }

    public static interface Num<N extends Number>
    extends PropExpression<N>,
    NumericExpressionImplementor<N> {
    }

    public static interface Str
    extends PropExpression<String>,
    StringExpressionImplementor {
    }
}

