/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.util.function.Consumer;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NativeBuilder;
import org.babyfish.jimmer.sql.ast.NativeContext;
import org.babyfish.jimmer.sql.ast.impl.CompositePredicate;
import org.babyfish.jimmer.sql.ast.impl.NativeBuilderImpl;
import org.babyfish.jimmer.sql.ast.impl.PredicateImplementor;
import org.jetbrains.annotations.Nullable;

public interface Predicate
extends Expression<Boolean> {
    @Nullable
    public static Predicate and(Predicate ... predicates) {
        return CompositePredicate.and(predicates);
    }

    @Nullable
    public static Predicate or(Predicate ... predicates) {
        return CompositePredicate.or(predicates);
    }

    @Nullable
    public static Predicate not(@Nullable Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        return ((PredicateImplementor)predicate).not();
    }

    public static NativeBuilder.Prd sqlBuilder(String sql) {
        return NativeBuilderImpl.predicate(sql);
    }

    public static Predicate sql(String sql) {
        return Predicate.sqlBuilder(sql).build();
    }

    public static Predicate sql(String sql, Expression<?> ... expressions) {
        NativeBuilder.Prd builder = Predicate.sqlBuilder(sql);
        for (Expression<?> expression : expressions) {
            builder.expression((Expression)expression);
        }
        return builder.build();
    }

    public static Predicate sql(String sql, Consumer<NativeContext> block) {
        NativeBuilder.Prd builder = Predicate.sqlBuilder(sql);
        block.accept(builder);
        return builder.build();
    }
}

