/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.JSqlClientImpl;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.mutation.DeprecatedMoreSaveOperations;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.query.MutableBaseQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRecursiveBaseQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.SubQueryProvider;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.BaseTable;
import org.babyfish.jimmer.sql.ast.table.RecursiveRef;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.di.AopProxyProvider;
import org.babyfish.jimmer.sql.di.LogicalDeletedValueGeneratorProvider;
import org.babyfish.jimmer.sql.di.TransientResolverProvider;
import org.babyfish.jimmer.sql.di.UserIdGeneratorProvider;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.BinLogPropReader;
import org.babyfish.jimmer.sql.exception.DatabaseValidationException;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.ReferenceFetchType;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.DatabaseSchemaStrategy;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetaStringResolver;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Customizer;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationMode;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.IdOnlyTargetCheckingLevel;
import org.babyfish.jimmer.sql.runtime.Initializer;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.babyfish.jimmer.sql.runtime.PropScalarProviderFactory;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;
import org.babyfish.jimmer.sql.transaction.Propagation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSqlClient
extends SubQueryProvider,
DeprecatedMoreSaveOperations {
    public static Builder newBuilder() {
        return new JSqlClientImpl.BuilderImpl();
    }

    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T var1);

    public <T extends BaseTable> MutableRootQuery<T> createQuery(T var1);

    public MutableBaseQuery createBaseQuery(TableProxy<?> var1);

    public <T extends TableProxy<?>, R extends BaseTable> MutableRecursiveBaseQuery<R> createBaseQuery(T var1, RecursiveRef<R> var2, WeakJoin<T, R> var3);

    public <T extends TableProxy<?>, R extends BaseTable> MutableRecursiveBaseQuery<R> createBaseQuery(T var1, RecursiveRef<R> var2, Class<? extends WeakJoin<T, R>> var3);

    public MutableUpdate createUpdate(TableProxy<?> var1);

    public MutableDelete createDelete(TableProxy<?> var1);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> var1);

    public Entities getEntities();

    public Triggers getTriggers();

    public Triggers getTriggers(boolean var1);

    public Associations getAssociations(TypedProp.Association<?, ?> var1);

    public Associations getAssociations(ImmutableProp var1);

    public Associations getAssociations(AssociationType var1);

    public Caches getCaches();

    public Filters getFilters();

    public BinLog getBinLog();

    public JSqlClient caches(Consumer<CacheDisableConfig> var1);

    public JSqlClient filters(Consumer<FilterConfig> var1);

    public JSqlClient disableSlaveConnectionManager();

    public JSqlClient executor(Executor var1);

    @Nullable
    default public <T> T findById(Class<T> type, Object id) {
        return this.getEntities().findById(type, id);
    }

    @Nullable
    default public <E> E findById(Fetcher<E> fetcher, Object id) {
        return this.getEntities().findById(fetcher, id);
    }

    @NotNull
    default public <T> T findOneById(Class<T> type, Object id) {
        return this.getEntities().findOneById(type, id);
    }

    @NotNull
    default public <E> E findOneById(Fetcher<E> fetcher, Object id) {
        return this.getEntities().findOneById(fetcher, id);
    }

    @NotNull
    default public <T> List<T> findByIds(Class<T> type, Iterable<?> ids) {
        return this.getEntities().findByIds(type, ids);
    }

    @NotNull
    default public <E> List<E> findByIds(Fetcher<E> fetcher, Iterable<?> ids) {
        return this.getEntities().findByIds(fetcher, ids);
    }

    @NotNull
    default public <K, T> Map<K, T> findMapByIds(Class<T> type, Iterable<K> ids) {
        return this.getEntities().findMapByIds(type, ids);
    }

    @NotNull
    default public <K, V> Map<K, V> findMapByIds(Fetcher<V> fetcher, Iterable<K> ids) {
        return this.getEntities().findMapByIds(fetcher, ids);
    }

    @Override
    default public <E> SimpleEntitySaveCommand<E> saveCommand(E entity) {
        return this.getEntities().saveCommand(entity);
    }

    @Override
    default public <E> BatchEntitySaveCommand<E> saveEntitiesCommand(Iterable<E> entities) {
        return this.getEntities().saveEntitiesCommand(entities);
    }

    default public DeleteResult deleteById(@NotNull Class<?> type, @NotNull Object id, @NotNull DeleteMode mode) {
        return this.getEntities().delete(type, id, mode);
    }

    default public DeleteResult deleteById(Class<?> type, Object id) {
        return this.getEntities().delete(type, id, DeleteMode.AUTO);
    }

    default public DeleteResult deleteByIds(Class<?> type, Iterable<?> ids, DeleteMode mode) {
        return this.getEntities().deleteAll(type, ids, mode);
    }

    default public DeleteResult deleteByIds(Class<?> type, Iterable<?> ids) {
        return this.getEntities().deleteAll(type, ids, DeleteMode.AUTO);
    }

    default public <R> R transaction(Supplier<R> block) {
        return this.transaction(Propagation.REQUIRED, block);
    }

    public <R> R transaction(Propagation var1, Supplier<R> var2);

    @Nullable
    public DatabaseValidationException validateDatabase();

    public static interface Builder {
        public static final int DEFAULT_BATCH_SIZE = 128;
        public static final int DEFAULT_LIST_BATCH_SIZE = 16;

        public Builder setConnectionManager(ConnectionManager var1);

        public Builder setSlaveConnectionManager(ConnectionManager var1);

        public Builder setDialect(Dialect var1);

        public Builder setExecutor(Executor var1);

        public Builder setExecutorContextPrefixes(Collection<String> var1);

        public Builder setSqlFormatter(SqlFormatter var1);

        public Builder setDefaultReferenceFetchType(ReferenceFetchType var1);

        public Builder setMaxJoinFetchDepth(int var1);

        public Builder setZoneId(@Nullable ZoneId var1);

        public Builder setUserIdGeneratorProvider(UserIdGeneratorProvider var1);

        public Builder setLogicalDeletedValueGeneratorProvider(LogicalDeletedValueGeneratorProvider var1);

        public Builder setTransientResolverProvider(TransientResolverProvider var1);

        public Builder setIdGenerator(IdGenerator var1);

        public Builder setIdGenerator(Class<?> var1, IdGenerator var2);

        public Builder addScalarProvider(ScalarProvider<?, ?> var1);

        public Builder setScalarProvider(TypedProp<?, ?> var1, ScalarProvider<?, ?> var2);

        public Builder setScalarProvider(ImmutableProp var1, ScalarProvider<?, ?> var2);

        public Builder addPropScalarProviderFactory(PropScalarProviderFactory var1);

        public Builder setDefaultSerializedTypeObjectMapper(ObjectMapper var1);

        public Builder setSerializedTypeObjectMapper(Class<?> var1, ObjectMapper var2);

        public Builder setSerializedPropObjectMapper(TypedProp<?, ?> var1, ObjectMapper var2);

        public Builder setSerializedPropObjectMapper(ImmutableProp var1, ObjectMapper var2);

        public Builder setDefaultJsonProviderCreator(Function<ImmutableProp, ScalarProvider<?, ?>> var1);

        public Builder setDefaultEnumStrategy(EnumType.Strategy var1);

        public Builder setDatabaseSchemaStrategy(DatabaseSchemaStrategy var1);

        public Builder setDatabaseNamingStrategy(DatabaseNamingStrategy var1);

        public Builder setMetaStringResolver(MetaStringResolver var1);

        public Builder setDefaultBatchSize(int var1);

        public Builder setDefaultListBatchSize(int var1);

        public Builder setInListPaddingEnabled(boolean var1);

        public Builder setExpandedInListPaddingEnabled(boolean var1);

        public Builder setOffsetOptimizingThreshold(int var1);

        public Builder setReverseSortOptimizationEnabled(boolean var1);

        public Builder setMaxCommandJoinCount(int var1);

        public Builder setMutationTransactionRequired(boolean var1);

        public Builder setEntityManager(EntityManager var1);

        public Builder setCaches(Consumer<CacheConfig> var1);

        public Builder setCacheFactory(CacheFactory var1);

        public Builder setCacheOperator(CacheOperator var1);

        public Builder addCacheAbandonedCallback(CacheAbandonedCallback var1);

        public Builder addCacheAbandonedCallbacks(Collection<? extends CacheAbandonedCallback> var1);

        public Builder setTriggerType(TriggerType var1);

        public Builder setLogicalDeletedBehavior(LogicalDeletedBehavior var1);

        public Builder addFilters(Filter<?> ... var1);

        public Builder addFilters(Collection<? extends Filter<?>> var1);

        public Builder addDisabledFilters(Filter<?> ... var1);

        public Builder addDisabledFilters(Collection<? extends Filter<?>> var1);

        public Builder setDefaultDissociateActionCheckable(boolean var1);

        public Builder setIdOnlyTargetCheckingLevel(IdOnlyTargetCheckingLevel var1);

        public Builder addDraftPreProcessor(DraftPreProcessor<?> var1);

        public Builder addDraftPreProcessors(DraftPreProcessor<?> ... var1);

        public Builder addDraftPreProcessors(Collection<DraftPreProcessor<?>> var1);

        public Builder addDraftInterceptor(DraftInterceptor<?, ?> var1);

        public Builder addDraftInterceptors(DraftInterceptor<?, ?> ... var1);

        public Builder addDraftInterceptors(Collection<? extends DraftInterceptor<?, ?>> var1);

        public Builder setDefaultBinLogObjectMapper(ObjectMapper var1);

        public Builder setBinLogPropReader(ImmutableProp var1, BinLogPropReader var2);

        public Builder setBinLogPropReader(TypedProp.Scalar<?, ?> var1, BinLogPropReader var2);

        public Builder setBinLogPropReader(Class<?> var1, BinLogPropReader var2);

        public Builder setForeignKeyEnabledByDefault(boolean var1);

        public Builder setTargetTransferable(boolean var1);

        public Builder setConstraintViolationTranslatable(boolean var1);

        public Builder addExceptionTranslator(ExceptionTranslator<?> var1);

        public Builder setExplicitBatchEnabled(boolean var1);

        public Builder setDumbBatchAcceptable(boolean var1);

        public Builder addExceptionTranslators(Collection<ExceptionTranslator<?>> var1);

        public Builder addCustomizers(Customizer ... var1);

        public Builder addCustomizers(Collection<? extends Customizer> var1);

        public Builder addInitializers(Initializer ... var1);

        public Builder addInitializers(Collection<? extends Initializer> var1);

        public Builder setDatabaseValidationMode(DatabaseValidationMode var1);

        public Builder setAopProxyProvider(AopProxyProvider var1);

        public Builder setMicroServiceName(String var1);

        public Builder setMicroServiceExchange(MicroServiceExchange var1);

        public JSqlClient build();
    }
}

