/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.KeyMatcher;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DraftInterceptorManager {
    private final Map<ImmutableType, List<DraftInterceptor<?, ?>>> interceptorMap;
    private final TypeCache<DraftInterceptor<?, ?>> cache = new TypeCache(this::create, true);

    DraftInterceptorManager(Collection<DraftInterceptor<?, ?>> interceptors) {
        HashMap interceptorMap = new HashMap();
        for (DraftInterceptor<?, ?> interceptor : interceptors) {
            if (interceptor == null) continue;
            Map argTypeMap = TypeUtils.getTypeArguments(interceptor.getClass(), DraftInterceptor.class);
            if (argTypeMap.isEmpty()) {
                throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", it extends \"" + DraftInterceptor.class.getName() + "\" but the generic type arguments are not specified");
            }
            TypeVariable<Class<T>>[] typeVariables = DraftInterceptor.class.getTypeParameters();
            Type entityType = (Type)argTypeMap.get(typeVariables[0]);
            Type draftType = (Type)argTypeMap.get(typeVariables[1]);
            if (!(entityType instanceof Class) || !((Class)entityType).isInterface() || ((Class)entityType).getAnnotation(Entity.class) == null && ((Class)entityType).getAnnotation(MappedSuperclass.class) == null) {
                throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", it extends \"" + DraftInterceptor.class.getName() + "\" but its entity type \"" + entityType + "\" is not interface type decorated by \"@" + Entity.class.getName() + "\" or \"@" + MappedSuperclass.class.getName() + "\"");
            }
            if (!(draftType instanceof Class && ((Class)draftType).isInterface() && Draft.class.isAssignableFrom((Class)draftType) && ((Class)entityType).isAssignableFrom((Class)draftType))) {
                throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", it extends \"" + DraftInterceptor.class.getName() + "\" but its draft type \"" + ((Class)draftType).getName() + "\" is not interface type which is draft interface of the entity type \"" + ((Class)entityType).getName() + "\"");
            }
            ImmutableType immutableType = ImmutableType.get((Class)((Class)draftType));
            interceptorMap.computeIfAbsent(immutableType, it -> new ArrayList()).add(interceptor);
        }
        this.interceptorMap = interceptorMap;
    }

    public DraftInterceptor<?, ?> get(ImmutableType type) {
        return (DraftInterceptor)this.cache.get(type);
    }

    private DraftInterceptor<?, ?> create(ImmutableType type) {
        final ArrayList interceptors = new ArrayList();
        Set allTypes = type.getAllTypes();
        for (ImmutableType t : allTypes) {
            List<DraftInterceptor<?, ?>> list = this.interceptorMap.get(t);
            if (list == null) continue;
            interceptors.addAll(list);
        }
        if (interceptors.isEmpty()) {
            return null;
        }
        final LinkedHashSet dependencies = new LinkedHashSet();
        boolean ignoreIdOnly = false;
        for (DraftInterceptor interceptor : interceptors) {
            ignoreIdOnly |= interceptor.ignoreIdOnly();
            Collection typeProps = interceptor.dependencies();
            if (typeProps == null) continue;
            for (TypedProp typedProp : typeProps) {
                ImmutableProp prop = typedProp.unwrap();
                if (!prop.isColumnDefinition()) {
                    throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", its \"dependencies\" contains the property \"" + prop + "\" which is not column definition");
                }
                if (!allTypes.contains(prop.getDeclaringType())) {
                    throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", its \"dependencies\" contains the property \"" + prop + "\" which is not belong to the type \"" + type + "\"");
                }
                if (prop.isId()) continue;
                dependencies.add(typedProp);
            }
        }
        final boolean mergedIgnoreIdOnly = ignoreIdOnly;
        return new DraftInterceptor<ImmutableSpi, Draft>(){

            @Override
            public void beforeSave(@NotNull Draft draft, @Nullable ImmutableSpi original) {
                for (DraftInterceptor interceptor : interceptors) {
                    interceptor.beforeSave(draft, original);
                }
            }

            @Override
            public void beforeSaveAll(@NotNull Collection<DraftInterceptor.Item<ImmutableSpi, Draft>> items) {
                for (DraftInterceptor interceptor : interceptors) {
                    interceptor.beforeSaveAll(items);
                }
            }

            @Override
            public Collection<TypedProp<ImmutableSpi, ?>> dependencies() {
                return dependencies;
            }

            @Override
            public boolean ignoreIdOnly() {
                return mergedIgnoreIdOnly;
            }

            @Override
            public boolean ignoreKeyOnly(@NotNull KeyMatcher.Group group) {
                for (DraftInterceptor interceptor : interceptors) {
                    if (!interceptor.ignoreKeyOnly(group)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

