/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.PagingAndSortingRepository;

@NoRepositoryBean
public interface JRepository<E, ID>
extends PagingAndSortingRepository<E, ID> {
    public JSqlClient sql();

    public ImmutableType type();

    public Class<E> entityType();

    public E findNullable(ID var1);

    public E findNullable(ID var1, Fetcher<E> var2);

    @NotNull
    default public Optional<E> findById(@NotNull ID id) {
        return Optional.ofNullable(this.findNullable(id));
    }

    @NotNull
    default public Optional<E> findById(ID id, Fetcher<E> fetcher) {
        return Optional.ofNullable(this.findNullable(id, fetcher));
    }

    @AliasFor(value="findAllById")
    public List<E> findByIds(Iterable<ID> var1);

    @AliasFor(value="findByIds")
    @NotNull
    default public List<E> findAllById(@NotNull Iterable<ID> ids) {
        return this.findByIds(ids);
    }

    public List<E> findByIds(Iterable<ID> var1, Fetcher<E> var2);

    public Map<ID, E> findMapByIds(Iterable<ID> var1);

    public Map<ID, E> findMapByIds(Iterable<ID> var1, Fetcher<E> var2);

    @NotNull
    public List<E> findAll();

    public List<E> findAll(TypedProp.Scalar<?, ?> ... var1);

    public List<E> findAll(Fetcher<E> var1, TypedProp.Scalar<?, ?> ... var2);

    @NotNull
    public List<E> findAll(@NotNull Sort var1);

    public List<E> findAll(Fetcher<E> var1, Sort var2);

    public Page<E> findAll(int var1, int var2);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3);

    public Page<E> findAll(int var1, int var2, TypedProp.Scalar<?, ?> ... var3);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3, TypedProp.Scalar<?, ?> ... var4);

    public Page<E> findAll(int var1, int var2, Sort var3);

    public Page<E> findAll(int var1, int var2, Fetcher<E> var3, Sort var4);

    @NotNull
    public Page<E> findAll(@NotNull Pageable var1);

    public Page<E> findAll(Pageable var1, Fetcher<E> var2);

    default public boolean existsById(@NotNull ID id) {
        return this.findNullable(id) != null;
    }

    public long count();

    @NotNull
    default public SimpleEntitySaveCommand<E> saveCommand(@NotNull E entity) {
        return this.sql().saveCommand(entity);
    }

    @NotNull
    default public SimpleEntitySaveCommand<E> saveCommand(@NotNull Input<E> input) {
        return this.sql().saveCommand(input);
    }

    @NotNull
    default public BatchEntitySaveCommand<E> saveEntitiesCommand(@NotNull Iterable<E> entities) {
        return this.sql().saveEntitiesCommand(entities);
    }

    @NotNull
    default public BatchEntitySaveCommand<E> saveInputsCommand(@NotNull Iterable<? extends Input<E>> inputs) {
        return this.sql().saveInputsCommand(inputs);
    }

    @NotNull
    default public <S extends E> S save(@NotNull S entity) {
        return (S)this.saveCommand(entity).execute().getModifiedEntity();
    }

    @NotNull
    default public <S extends E> List<S> saveAll(@NotNull Iterable<S> entities) {
        return this.saveEntitiesCommand((List)entities).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    default public E save(E entity, SaveMode mode) {
        return (E)this.saveCommand(entity).setMode(mode).execute().getModifiedEntity();
    }

    default public E save(E entity, SaveMode mode, AssociatedSaveMode associatedMode) {
        return (E)this.saveCommand(entity).setMode(mode).setAssociatedModeAll(associatedMode).execute().getModifiedEntity();
    }

    default public List<E> saveEntities(Iterable<E> entities) {
        return this.saveEntitiesCommand(entities).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    default public List<E> saveEntities(Iterable<E> entities, SaveMode mode) {
        return this.saveEntitiesCommand(entities).setMode(mode).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    default public List<E> saveEntities(Iterable<E> entities, SaveMode mode, AssociatedSaveMode associatedMode) {
        return this.saveEntitiesCommand(entities).setMode(mode).setAssociatedModeAll(associatedMode).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    default public E save(Input<E> input) {
        return (E)this.saveCommand(input).execute().getModifiedEntity();
    }

    default public E save(Input<E> input, SaveMode mode, AssociatedSaveMode associatedMode) {
        return (E)this.saveCommand(input).setMode(mode).setAssociatedModeAll(associatedMode).execute().getModifiedEntity();
    }

    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs) {
        return this.saveInputsCommand(inputs).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, AssociatedSaveMode associatedMode) {
        return this.saveInputsCommand(inputs).setMode(mode).setAssociatedModeAll(associatedMode).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public E save(E entity, Fetcher<E> fetcher) {
        return (E)this.saveCommand(entity).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public E save(E entity, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return (E)this.saveCommand(entity).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public List<E> saveEntities(Iterable<E> entities, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public List<E> saveEntities(Iterable<E> entities, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public E save(Input<E> input, Fetcher<E> fetcher) {
        return (E)this.saveCommand(input).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public E save(Input<E> input, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return (E)this.saveCommand(input).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> V save(E entity, Class<V> viewType) {
        return (V)this.saveCommand(entity).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> V save(E entity, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return (V)this.saveCommand(entity).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveEntities(Iterable<E> entities, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveEntities(Iterable<E> entities, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> V save(Input<E> input, Class<V> viewType) {
        return (V)this.saveCommand(input).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> V save(Input<E> input, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return (V)this.saveCommand(input).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveInputs(Iterable<? extends Input<E>> inputs, Class<V> viewType) {
        return this.saveInputsCommand(inputs).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveInputsCommand(inputs).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public E save(E entity, AssociatedSaveMode associatedMode) {
        return (E)this.saveCommand(entity).setAssociatedModeAll(associatedMode).execute().getModifiedEntity();
    }

    @Deprecated
    default public List<E> saveEntities(Iterable<E> entities, AssociatedSaveMode associatedMode) {
        return this.saveEntitiesCommand(entities).setAssociatedModeAll(associatedMode).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public E save(Input<E> input, AssociatedSaveMode associatedMode) {
        return (E)this.saveCommand(input).setAssociatedModeAll(associatedMode).execute().getModifiedEntity();
    }

    default public E save(Input<E> input, SaveMode mode) {
        return (E)this.saveCommand(input).setMode(mode).execute().getModifiedEntity();
    }

    @Deprecated
    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, AssociatedSaveMode associatedMode) {
        return this.saveInputsCommand(inputs).setAssociatedModeAll(associatedMode).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode) {
        return this.saveInputsCommand(inputs).setMode(mode).execute().getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public E save(E entity, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return (E)this.saveCommand(entity).setAssociatedModeAll(associatedMode).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public E save(E entity, SaveMode mode, Fetcher<E> fetcher) {
        return (E)this.saveCommand(entity).setMode(mode).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public List<E> saveEntities(Iterable<E> entities, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).setAssociatedModeAll(associatedMode).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public List<E> saveEntities(Iterable<E> entities, SaveMode mode, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).setMode(mode).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public E save(Input<E> input, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return (E)this.saveCommand(input).setAssociatedModeAll(associatedMode).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public E save(Input<E> input, SaveMode mode, Fetcher<E> fetcher) {
        return (E)this.saveCommand(input).setMode(mode).execute(fetcher).getModifiedEntity();
    }

    @Deprecated
    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).setAssociatedModeAll(associatedMode).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public List<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).setMode(mode).execute(fetcher).getItems().stream().map(BatchSaveResult.Item::getModifiedEntity).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> V save(E entity, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return (V)this.saveCommand(entity).setAssociatedModeAll(associatedMode).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> V save(E entity, SaveMode mode, Class<V> viewType) {
        return (V)this.saveCommand(entity).setMode(mode).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveEntities(Iterable<E> entities, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).setAssociatedModeAll(associatedMode).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveEntities(Iterable<E> entities, SaveMode mode, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).setMode(mode).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> V save(Input<E> input, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return (V)this.saveCommand(input).setAssociatedModeAll(associatedMode).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> V save(Input<E> input, SaveMode mode, Class<V> viewType) {
        return (V)this.saveCommand(input).setMode(mode).execute(viewType).getModifiedView();
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveInputs(Iterable<? extends Input<E>> inputs, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveInputsCommand(inputs).setAssociatedModeAll(associatedMode).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    default public <V extends View<E>> List<V> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, Class<V> viewType) {
        return this.saveInputsCommand(inputs).setMode(mode).execute(viewType).getViewItems().stream().map(BatchSaveResult.View.ViewItem::getModifiedView).collect(Collectors.toList());
    }

    @Deprecated
    @NotNull
    default public E insert(@NotNull E entity) {
        return this.save(entity, SaveMode.INSERT_ONLY, AssociatedSaveMode.APPEND);
    }

    @Deprecated
    @NotNull
    default public E insert(@NotNull E entity, AssociatedSaveMode associatedMode) {
        return this.save(entity, SaveMode.INSERT_ONLY, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E insert(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.INSERT_ONLY, AssociatedSaveMode.APPEND_IF_ABSENT);
    }

    @Deprecated
    @NotNull
    default public E insert(@NotNull Input<E> input, AssociatedSaveMode associatedMode) {
        return (E)this.save(input.toEntity(), SaveMode.INSERT_ONLY, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E insertIfAbsent(@NotNull E entity) {
        return this.save(entity, SaveMode.INSERT_IF_ABSENT, AssociatedSaveMode.APPEND_IF_ABSENT);
    }

    @Deprecated
    @NotNull
    default public E insertIfAbsent(@NotNull E entity, AssociatedSaveMode associatedMode) {
        return this.save(entity, SaveMode.INSERT_IF_ABSENT, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E insertIfAbsent(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.INSERT_IF_ABSENT, AssociatedSaveMode.APPEND_IF_ABSENT);
    }

    @Deprecated
    @NotNull
    default public E insertIfAbsent(@NotNull Input<E> input, AssociatedSaveMode associatedMode) {
        return (E)this.save(input.toEntity(), SaveMode.INSERT_IF_ABSENT, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E update(@NotNull E entity) {
        return this.save(entity, SaveMode.UPDATE_ONLY, AssociatedSaveMode.UPDATE);
    }

    @Deprecated
    @NotNull
    default public E update(@NotNull E entity, AssociatedSaveMode associatedMode) {
        return this.save(entity, SaveMode.UPDATE_ONLY, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E update(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.UPDATE_ONLY, AssociatedSaveMode.UPDATE);
    }

    @Deprecated
    @NotNull
    default public E update(@NotNull Input<E> input, AssociatedSaveMode associatedMode) {
        return (E)this.save(input.toEntity(), SaveMode.UPDATE_ONLY, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E merge(@NotNull E entity) {
        return this.save(entity, SaveMode.UPSERT, AssociatedSaveMode.MERGE);
    }

    @Deprecated
    @NotNull
    default public E merge(@NotNull E entity, AssociatedSaveMode associatedMode) {
        return this.save(entity, SaveMode.UPSERT, associatedMode);
    }

    @Deprecated
    @NotNull
    default public E merge(@NotNull Input<E> input) {
        return (E)this.save(input.toEntity(), SaveMode.UPSERT, AssociatedSaveMode.MERGE);
    }

    @Deprecated
    @NotNull
    default public E merge(@NotNull Input<E> input, AssociatedSaveMode associatedMode) {
        return (E)this.save(input.toEntity(), SaveMode.UPSERT, associatedMode);
    }

    default public void delete(@NotNull E entity) {
        this.delete(entity, DeleteMode.AUTO);
    }

    public int delete(@NotNull E var1, DeleteMode var2);

    default public void deleteAll(@NotNull Iterable<? extends E> entities) {
        this.deleteAll(entities, DeleteMode.AUTO);
    }

    public int deleteAll(@NotNull Iterable<? extends E> var1, DeleteMode var2);

    default public void deleteById(@NotNull ID id) {
        this.deleteById(id, DeleteMode.AUTO);
    }

    public int deleteById(@NotNull ID var1, DeleteMode var2);

    @AliasFor(value="deleteAllById")
    default public void deleteByIds(Iterable<? extends ID> ids) {
        this.deleteByIds(ids, DeleteMode.AUTO);
    }

    @AliasFor(value="deleteByIds")
    default public void deleteAllById(@NotNull Iterable<? extends ID> ids) {
        this.deleteByIds(ids, DeleteMode.AUTO);
    }

    @AliasFor(value="deleteAllById")
    public int deleteByIds(Iterable<? extends ID> var1, DeleteMode var2);

    public void deleteAll();

    public <V extends View<E>> Viewer<E, ID, V> viewer(Class<V> var1);

    public static interface Viewer<E, ID, V extends View<E>> {
        public V findNullable(ID var1);

        public List<V> findByIds(Iterable<ID> var1);

        public Map<ID, V> findMapByIds(Iterable<ID> var1);

        public List<V> findAll();

        public List<V> findAll(TypedProp.Scalar<?, ?> ... var1);

        public List<V> findAll(Sort var1);

        public Page<V> findAll(Pageable var1);

        public Page<V> findAll(int var1, int var2);

        public Page<V> findAll(int var1, int var2, TypedProp.Scalar<?, ?> ... var3);

        public Page<V> findAll(int var1, int var2, Sort var3);
    }
}

