/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repo.support;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.Page;
import org.babyfish.jimmer.Slice;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.spring.repo.JavaRepository;
import org.babyfish.jimmer.spring.repo.PageParam;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.DtoMetadata;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.GenericTypeResolver;

public class AbstractJavaRepository<E, ID>
implements JavaRepository<E, ID> {
    protected final JSqlClient sql;
    protected final Class<E> entityType;
    protected final ImmutableType type;

    public AbstractJavaRepository(JSqlClient sql) {
        this.sql = Objects.requireNonNull(sql, "sql is required");
        Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(this.getClass(), JavaRepository.class);
        if (typeArguments == null) {
            throw new IllegalArgumentException("The class \"" + this.getClass() + "\" does not explicitly specify the type arguments of \"" + JavaRepository.class.getName() + "\" so that the entityType must be specified");
        }
        this.entityType = typeArguments[0];
        this.type = ImmutableType.get(this.entityType);
        if (!this.type.isEntity()) {
            throw new IllegalArgumentException("\"" + this.entityType + "\" is not entity type decorated by @" + Entity.class.getName());
        }
    }

    @Override
    @Nullable
    public E findById(ID id, @Nullable Fetcher<E> fetcher) {
        if (fetcher == null) {
            return (E)this.sql.findById(this.entityType, id);
        }
        return (E)this.sql.findById(fetcher, id);
    }

    @Override
    @Nullable
    public <V extends View<E>> V findById(ID id, Class<V> viewType) {
        return (V)((View)this.sql.findById(viewType, id));
    }

    @Override
    @NotNull
    public List<E> findByIds(Iterable<ID> ids, @Nullable Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.sql.findByIds(this.entityType, ids);
        }
        return this.sql.findByIds(fetcher, ids);
    }

    @Override
    @NotNull
    public <V extends View<E>> List<V> findByIds(Iterable<ID> ids, Class<V> viewType) {
        return this.sql.findByIds(viewType, ids);
    }

    @Override
    @NotNull
    public Map<ID, E> findMapByIds(Iterable<ID> ids, Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this.sql.findMapByIds(this.entityType, ids);
        }
        return this.sql.findMapByIds(fetcher, ids);
    }

    @Override
    @NotNull
    public <V extends View<E>> Map<ID, V> findMapByIds(Iterable<ID> ids, Class<V> viewType) {
        DtoMetadata metadata = DtoMetadata.of(viewType);
        List entities = this.sql.findByIds(metadata.getFetcher(), ids);
        LinkedHashMap<Object, View> map = new LinkedHashMap<Object, View>((entities.size() * 4 + 2) / 3);
        PropId idPropId = this.type.getIdProp().getId();
        for (Object entity : entities) {
            map.put(((ImmutableSpi)entity).__get(idPropId), (View)metadata.getConverter().apply(entity));
        }
        return map;
    }

    @Override
    @NotNull
    public List<E> findAll(@Nullable Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        ConfigurableRootQuery query = this.createQuery(fetcher, null, sortedProps);
        return (List)query.execute();
    }

    @Override
    @NotNull
    public <V extends View<E>> List<V> findAll(Class<V> viewType, TypedProp.Scalar<?, ?> ... sortedProps) {
        DtoMetadata metadata = DtoMetadata.of(viewType);
        ConfigurableRootQuery query = this.createQuery(metadata.getFetcher(), metadata.getConverter(), sortedProps);
        return (List)query.execute();
    }

    @Override
    @NotNull
    public Page<E> findPage(PageParam pageParam, @Nullable Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        ConfigurableRootQuery query = this.createQuery(fetcher, null, sortedProps);
        return query.fetchPage(pageParam.getIndex(), pageParam.getSize());
    }

    @Override
    @NotNull
    public <V extends View<E>> Page<V> findPage(PageParam pageParam, Class<V> viewType, TypedProp.Scalar<?, ?> ... sortedProps) {
        DtoMetadata metadata = DtoMetadata.of(viewType);
        ConfigurableRootQuery query = this.createQuery(metadata.getFetcher(), metadata.getConverter(), sortedProps);
        return query.fetchPage(pageParam.getIndex(), pageParam.getSize());
    }

    @Override
    @NotNull
    public Slice<E> findSlice(int limit, int offset, @Nullable Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        ConfigurableRootQuery query = this.createQuery(fetcher, null, sortedProps);
        return query.fetchSlice(limit, offset);
    }

    @Override
    @NotNull
    public <V extends View<E>> Slice<V> findSlice(int limit, int offset, Class<V> viewType, TypedProp.Scalar<?, ?> ... sortedProps) {
        DtoMetadata metadata = DtoMetadata.of(viewType);
        ConfigurableRootQuery query = this.createQuery(metadata.getFetcher(), metadata.getConverter(), sortedProps);
        return query.fetchSlice(limit, offset);
    }

    @Override
    @NotNull
    public SimpleEntitySaveCommand<E> saveCommand(@NotNull E entity) {
        return this.sql.saveCommand(entity);
    }

    @Override
    @NotNull
    public BatchEntitySaveCommand<E> saveEntitiesCommand(@NotNull Iterable<E> entities) {
        return this.sql.saveEntitiesCommand(entities);
    }

    @Override
    @NotNull
    public BatchEntitySaveCommand<E> saveInputsCommand(@NotNull Iterable<? extends Input<E>> inputs) {
        return this.sql.saveInputsCommand(inputs);
    }

    @Override
    public long deleteById(ID id, DeleteMode deleteMode) {
        return this.sql.deleteById(this.entityType, id, deleteMode).getAffectedRowCount(this.entityType);
    }

    @Override
    public long deleteByIds(Iterable<ID> ids, DeleteMode deleteMode) {
        return this.sql.deleteByIds(this.entityType, ids, deleteMode).getAffectedRowCount(this.entityType);
    }

    private <X> ConfigurableRootQuery<?, X> createQuery(Fetcher<?> fetcher, @Nullable Function<?, X> converter, @Nullable TypedProp.Scalar<?, ?>[] sortedProps) {
        MutableRootQueryImpl query = new MutableRootQueryImpl((JSqlClientImplementor)this.sql, this.type, ExecutionPurpose.QUERY, FilterLevel.DEFAULT);
        TableImplementor table = (TableImplementor)query.getTableLikeImplementor();
        if (sortedProps != null) {
            for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
                if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(this.type)) {
                    throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + this.type + "\" or its super types");
                }
                PropExpression expr = table.get(sortedProp.unwrap());
                Order astOrder = sortedProp.isDesc() ? expr.desc() : expr.asc();
                if (sortedProp.isNullsFirst()) {
                    astOrder = astOrder.nullsFirst();
                }
                if (sortedProp.isNullsLast()) {
                    astOrder = astOrder.nullsLast();
                }
                query.orderBy(new Order[]{astOrder});
            }
        }
        return query.select((Selection)(fetcher != null ? new FetcherSelectionImpl((Table)table, fetcher, converter) : table));
    }
}

