/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repo;

public class PageParam {
    private final int index;
    private final int size;

    private PageParam(int index, int size) {
        this.index = index;
        this.size = size;
    }

    public static PageParam byIndex(int index, int size) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size must be positive");
        }
        return new PageParam(index, size);
    }

    public static PageParam byNo(int no, int size) {
        if (no < 0) {
            throw new IllegalArgumentException("no must be negative");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size must be positive");
        }
        return new PageParam(no - 1, size);
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageParam pageParam = (PageParam)o;
        if (this.index != pageParam.index) {
            return false;
        }
        return this.size == pageParam.size;
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        return "PageParam{index=" + this.index + ", size=" + this.size + '}';
    }
}

