/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.repo;

import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.Page;
import org.babyfish.jimmer.Slice;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.spring.repo.PageParam;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaRepository<E, ID> {
    @Nullable
    default public E findById(ID id) {
        return this.findById(id, (Fetcher)null);
    }

    @Nullable
    public E findById(ID var1, @Nullable Fetcher<E> var2);

    @Nullable
    public <V extends View<E>> V findById(ID var1, Class<V> var2);

    @NotNull
    default public List<E> findByIds(Iterable<ID> ids) {
        return this.findByIds(ids, (Fetcher)null);
    }

    @NotNull
    public List<E> findByIds(Iterable<ID> var1, @Nullable Fetcher<E> var2);

    @NotNull
    public <V extends View<E>> List<V> findByIds(Iterable<ID> var1, Class<V> var2);

    @NotNull
    default public Map<ID, E> findMapByIds(Iterable<ID> ids) {
        return this.findMapByIds(ids, (Fetcher)null);
    }

    @NotNull
    public Map<ID, E> findMapByIds(Iterable<ID> var1, Fetcher<E> var2);

    @NotNull
    public <V extends View<E>> Map<ID, V> findMapByIds(Iterable<ID> var1, Class<V> var2);

    @NotNull
    default public List<E> findAll(TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.findAll((Fetcher)null, sortedProps);
    }

    @NotNull
    public List<E> findAll(@Nullable Fetcher<E> var1, TypedProp.Scalar<?, ?> ... var2);

    @NotNull
    public <V extends View<E>> List<V> findAll(Class<V> var1, TypedProp.Scalar<?, ?> ... var2);

    @NotNull
    default public Page<E> findPage(PageParam pageParam, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.findPage(pageParam, (Fetcher)null, sortedProps);
    }

    @NotNull
    public Page<E> findPage(PageParam var1, @Nullable Fetcher<E> var2, TypedProp.Scalar<?, ?> ... var3);

    @NotNull
    public <V extends View<E>> Page<V> findPage(PageParam var1, Class<V> var2, TypedProp.Scalar<?, ?> ... var3);

    @NotNull
    default public Slice<E> findSlice(int limit, int offset, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.findSlice(limit, offset, (Fetcher)null, sortedProps);
    }

    @NotNull
    public Slice<E> findSlice(int var1, int var2, @Nullable Fetcher<E> var3, TypedProp.Scalar<?, ?> ... var4);

    @NotNull
    public <V extends View<E>> Slice<V> findSlice(int var1, int var2, Class<V> var3, TypedProp.Scalar<?, ?> ... var4);

    @NotNull
    public SimpleEntitySaveCommand<E> saveCommand(@NotNull E var1);

    @NotNull
    default public SimpleEntitySaveCommand<E> saveCommand(@NotNull Input<E> input) {
        return this.saveCommand(input.toEntity());
    }

    @NotNull
    public BatchEntitySaveCommand<E> saveEntitiesCommand(@NotNull Iterable<E> var1);

    @NotNull
    public BatchEntitySaveCommand<E> saveInputsCommand(@NotNull Iterable<? extends Input<E>> var1);

    default public SimpleSaveResult<E> save(E entity) {
        return this.saveCommand(entity).execute();
    }

    default public SimpleSaveResult<E> save(E entity, SaveMode mode) {
        return this.saveCommand(entity).setMode(mode).execute();
    }

    default public SimpleSaveResult<E> save(E entity, SaveMode mode, AssociatedSaveMode associatedMode) {
        return this.saveCommand(entity).setMode(mode).setAssociatedModeAll(associatedMode).execute();
    }

    default public BatchSaveResult<E> saveEntities(Iterable<E> entities) {
        return this.saveEntitiesCommand(entities).execute();
    }

    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, SaveMode mode) {
        return this.saveEntitiesCommand(entities).setMode(mode).execute();
    }

    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, SaveMode mode, AssociatedSaveMode associatedMode) {
        return this.saveEntitiesCommand(entities).setMode(mode).setAssociatedModeAll(associatedMode).execute();
    }

    default public SimpleSaveResult<E> save(Input<E> input) {
        return this.saveCommand(input).execute();
    }

    default public SimpleSaveResult<E> save(Input<E> input, SaveMode mode) {
        return this.saveCommand(input).setMode(mode).execute();
    }

    default public SimpleSaveResult<E> save(Input<E> input, SaveMode mode, AssociatedSaveMode associatedMode) {
        return this.saveCommand(input).setMode(mode).setAssociatedModeAll(associatedMode).execute();
    }

    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs) {
        return this.saveInputsCommand(inputs).execute();
    }

    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode) {
        return this.saveInputsCommand(inputs).setMode(mode).execute();
    }

    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, AssociatedSaveMode associatedMode) {
        return this.saveInputsCommand(inputs).setMode(mode).setAssociatedModeAll(associatedMode).execute();
    }

    @Deprecated
    default public SimpleSaveResult<E> save(E entity, Fetcher<E> fetcher) {
        return this.saveCommand(entity).execute(fetcher);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(E entity, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveCommand(entity).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(Input<E> input, Fetcher<E> fetcher) {
        return this.saveCommand(input).execute(fetcher);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(Input<E> input, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveCommand(input).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).setMode(mode).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(E entity, Class<V> viewType) {
        return this.saveCommand(entity).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(E entity, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveCommand(entity).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveEntities(Iterable<E> entities, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveEntities(Iterable<E> entities, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(Input<E> input, Class<V> viewType) {
        return this.saveCommand(input).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(Input<E> input, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveCommand(input).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveInputs(Iterable<? extends Input<E>> inputs, Class<V> viewType) {
        return this.saveInputsCommand(inputs).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveInputsCommand(inputs).setMode(mode).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(E entity, AssociatedSaveMode associatedMode) {
        return this.saveCommand(entity).setAssociatedModeAll(associatedMode).execute();
    }

    @Deprecated
    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, AssociatedSaveMode associatedMode) {
        return this.saveEntitiesCommand(entities).setAssociatedModeAll(associatedMode).execute();
    }

    @Deprecated
    default public SimpleSaveResult<E> save(Input<E> input, AssociatedSaveMode associatedMode) {
        return this.saveCommand(input).setAssociatedModeAll(associatedMode).execute();
    }

    @Deprecated
    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, AssociatedSaveMode associatedMode) {
        return this.saveInputsCommand(inputs).setAssociatedModeAll(associatedMode).execute();
    }

    @Deprecated
    default public SimpleSaveResult<E> save(E entity, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveCommand(entity).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(E entity, SaveMode mode, Fetcher<E> fetcher) {
        return this.saveCommand(entity).setMode(mode).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveEntities(Iterable<E> entities, SaveMode mode, Fetcher<E> fetcher) {
        return this.saveEntitiesCommand(entities).setMode(mode).execute(fetcher);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(Input<E> input, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveCommand(input).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public SimpleSaveResult<E> save(Input<E> input, SaveMode mode, Fetcher<E> fetcher) {
        return this.saveCommand(input).setMode(mode).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, AssociatedSaveMode associatedMode, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).setAssociatedModeAll(associatedMode).execute(fetcher);
    }

    @Deprecated
    default public BatchSaveResult<E> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, Fetcher<E> fetcher) {
        return this.saveInputsCommand(inputs).setMode(mode).execute(fetcher);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(E entity, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveCommand(entity).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(E entity, SaveMode mode, Class<V> viewType) {
        return this.saveCommand(entity).setMode(mode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveEntities(Iterable<E> entities, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveEntities(Iterable<E> entities, SaveMode mode, Class<V> viewType) {
        return this.saveEntitiesCommand(entities).setMode(mode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(Input<E> input, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveCommand(input).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> SimpleSaveResult.View<E, V> save(Input<E> input, SaveMode mode, Class<V> viewType) {
        return this.saveCommand(input).setMode(mode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveInputs(Iterable<? extends Input<E>> inputs, AssociatedSaveMode associatedMode, Class<V> viewType) {
        return this.saveInputsCommand(inputs).setAssociatedModeAll(associatedMode).execute(viewType);
    }

    @Deprecated
    default public <V extends View<E>> BatchSaveResult.View<E, V> saveInputs(Iterable<? extends Input<E>> inputs, SaveMode mode, Class<V> viewType) {
        return this.saveInputsCommand(inputs).setMode(mode).execute(viewType);
    }

    @Deprecated
    default public SimpleSaveResult<E> insert(E entity) {
        return this.save(entity, SaveMode.INSERT_ONLY, AssociatedSaveMode.APPEND);
    }

    @Deprecated
    default public SimpleSaveResult<E> insert(E entity, AssociatedSaveMode associatedSaveMode) {
        return this.save(entity, SaveMode.INSERT_ONLY, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> insert(Input<E> input) {
        return this.save(input, SaveMode.INSERT_ONLY, AssociatedSaveMode.APPEND);
    }

    @Deprecated
    default public SimpleSaveResult<E> insert(Input<E> input, AssociatedSaveMode associatedSaveMode) {
        return this.save(input, SaveMode.INSERT_ONLY, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> insertIfAbsent(E entity) {
        return this.save(entity, SaveMode.INSERT_IF_ABSENT, AssociatedSaveMode.APPEND_IF_ABSENT);
    }

    @Deprecated
    default public SimpleSaveResult<E> insertIfAbsent(E entity, AssociatedSaveMode associatedSaveMode) {
        return this.save(entity, SaveMode.INSERT_IF_ABSENT, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> insertIfAbsent(Input<E> input) {
        return this.save(input, SaveMode.INSERT_IF_ABSENT, AssociatedSaveMode.APPEND_IF_ABSENT);
    }

    @Deprecated
    default public SimpleSaveResult<E> insertIfAbsent(Input<E> input, AssociatedSaveMode associatedSaveMode) {
        return this.save(input, SaveMode.INSERT_IF_ABSENT, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> update(E entity) {
        return this.save(entity, SaveMode.UPDATE_ONLY, AssociatedSaveMode.UPDATE);
    }

    @Deprecated
    default public SimpleSaveResult<E> update(E entity, AssociatedSaveMode associatedSaveMode) {
        return this.save(entity, SaveMode.UPDATE_ONLY, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> update(Input<E> input) {
        return this.save(input, SaveMode.UPDATE_ONLY, AssociatedSaveMode.UPDATE);
    }

    @Deprecated
    default public SimpleSaveResult<E> update(Input<E> input, AssociatedSaveMode associatedSaveMode) {
        return this.save(input, SaveMode.UPDATE_ONLY, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> merge(E entity) {
        return this.save(entity, SaveMode.UPSERT, AssociatedSaveMode.MERGE);
    }

    @Deprecated
    default public SimpleSaveResult<E> merge(E entity, AssociatedSaveMode associatedSaveMode) {
        return this.save(entity, SaveMode.UPSERT, associatedSaveMode);
    }

    @Deprecated
    default public SimpleSaveResult<E> merge(Input<E> input) {
        return this.save(input, SaveMode.UPSERT, AssociatedSaveMode.MERGE);
    }

    @Deprecated
    default public SimpleSaveResult<E> merge(Input<E> input, AssociatedSaveMode associatedSaveMode) {
        return this.save(input, SaveMode.UPSERT, associatedSaveMode);
    }

    default public long deleteById(ID id) {
        return this.deleteById(id, DeleteMode.AUTO);
    }

    public long deleteById(ID var1, DeleteMode var2);

    default public long deleteByIds(Iterable<ID> ids) {
        return this.deleteByIds(ids, DeleteMode.AUTO);
    }

    public long deleteByIds(Iterable<ID> var1, DeleteMode var2);
}

