/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.graphql;

import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.SelectedField;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Page;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;

public class DataFetchingEnvironments {
    private DataFetchingEnvironments() {
    }

    public static <T> Fetcher<T> createFetcher(Class<T> rootType, DataFetchingEnvironment env) {
        ImmutableType type = ImmutableType.tryGet(rootType);
        if (type == null || !type.isEntity()) {
            throw new IllegalArgumentException("The root type \"" + rootType + "\" is not entity type so that it cannot be used to create fetcher from DataFetchingEnvironment");
        }
        Context ctx = new Context(env, type);
        ctx.add(env.getMergedField().getSingleField().getSelectionSet());
        return ctx.fetcher;
    }

    private static class Context {
        private final DataFetchingEnvironment env;
        private final ImmutableType immutableType;
        private FetcherImplementor<?> fetcher;

        Context(DataFetchingEnvironment env, ImmutableType immutableType) {
            this.env = env;
            this.immutableType = immutableType;
        }

        public void add(SelectionSet selectionSet) {
            if (selectionSet == null) {
                return;
            }
            for (Selection selection : selectionSet.getSelections()) {
                if (selection instanceof Field) {
                    this.add((Field)selection);
                    continue;
                }
                if (selection instanceof FragmentSpread) {
                    this.add((FragmentSpread)selection);
                    continue;
                }
                if (!(selection instanceof InlineFragment)) continue;
                this.add((InlineFragment)selection);
            }
        }

        private void add(Field field) {
            if (!field.getArguments().isEmpty()) {
                return;
            }
            ImmutableProp prop = (ImmutableProp)this.immutableType.getProps().get(field.getName());
            if (prop == null) {
                if (Arrays.stream(Page.class.getDeclaredFields()).map(java.lang.reflect.Field::getName).allMatch(this.env.getSelectionSet().getFields().stream().map(SelectedField::getQualifiedName).collect(Collectors.toList())::contains)) {
                    if (field.getName().equals("rows")) {
                        this.add(field.getSelectionSet());
                    }
                    return;
                }
                throw new IllegalArgumentException("The property \"" + field.getName() + "\" is not found in the entity type \"" + this.immutableType.getJavaClass() + "\"");
            }
            if (this.fetcher == null) {
                this.fetcher = new FetcherImpl(this.immutableType.getJavaClass());
            }
            FetcherImplementor<?> childFetcher = null;
            if (field.getSelectionSet() != null && prop.isAssociation(TargetLevel.ENTITY)) {
                Context subContext = new Context(this.env, prop.getTargetType());
                subContext.add(field.getSelectionSet());
                childFetcher = subContext.fetcher;
            }
            this.fetcher = this.fetcher.add(field.getName(), childFetcher);
        }

        private void add(FragmentSpread fragmentSpread) {
            FragmentDefinition definition = (FragmentDefinition)this.env.getFragmentsByName().get(fragmentSpread.getName());
            if (definition == null) {
                return;
            }
            if (this.isValidFragmentOwner(definition.getTypeCondition())) {
                this.add(definition.getSelectionSet());
            }
        }

        private void add(InlineFragment inlineFragment) {
            if (this.isValidFragmentOwner(inlineFragment.getTypeCondition())) {
                this.add(inlineFragment.getSelectionSet());
            }
        }

        private boolean isValidFragmentOwner(TypeName fragmentOwner) {
            GraphQLType graphQLType = this.env.getGraphQLSchema().getType(fragmentOwner.getName());
            if (!(graphQLType instanceof GraphQLObjectType)) {
                return false;
            }
            return Context.isValidSimpleName(((GraphQLObjectType)graphQLType).getName(), this.immutableType.getJavaClass());
        }

        private static boolean isValidSimpleName(String simpleName, Class<?> type) {
            if (type.getSimpleName().equals(simpleName)) {
                return true;
            }
            for (Class<?> itf : type.getInterfaces()) {
                if (!Context.isValidSimpleName(simpleName, itf)) continue;
                return true;
            }
            return false;
        }
    }
}

