/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.H2Dialect;
import org.babyfish.jimmer.sql.dialect.MySqlDialect;
import org.babyfish.jimmer.sql.dialect.OracleDialect;
import org.babyfish.jimmer.sql.dialect.PostgresDialect;
import org.babyfish.jimmer.sql.dialect.SQLiteDialect;
import org.babyfish.jimmer.sql.dialect.SqlServerDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public interface DialectDetector {
    public static final DialectDetector INSTANCE = new Impl();

    @Nullable
    public Dialect detectDialect(@NotNull Connection var1);

    public static class Impl
    implements DialectDetector {
        private static final Logger LOGGER = LoggerFactory.getLogger(DialectDetector.class);

        @Override
        @Nullable
        public Dialect detectDialect(@NotNull Connection con) {
            try {
                String productName = JdbcUtils.commonDatabaseName((String)((String)Impl.extractDatabaseMetaData(con, DatabaseMetaData::getDatabaseProductName)));
                DatabaseDriver driver = DatabaseDriver.fromProductName((String)productName);
                return Impl.getDialectOrNullForDriver(driver);
            }
            catch (MetaDataAccessException e) {
                LOGGER.warn("Failed to autodetect jimmer dialect", (Throwable)e);
                return null;
            }
        }

        private static <T> T extractDatabaseMetaData(@NotNull Connection con, @NotNull DatabaseMetaDataCallback<T> action) throws MetaDataAccessException {
            try {
                DatabaseMetaData metaData = con.getMetaData();
                if (metaData == null) {
                    throw new MetaDataAccessException("DatabaseMetaData returned by Connection [" + con + "] was null");
                }
                return (T)action.processMetaData(metaData);
            }
            catch (CannotGetJdbcConnectionException ex) {
                throw new MetaDataAccessException("Could not get Connection for extracting meta-data", (Throwable)ex);
            }
            catch (SQLException ex) {
                throw new MetaDataAccessException("Error while extracting DatabaseMetaData", (Throwable)ex);
            }
            catch (AbstractMethodError err) {
                throw new MetaDataAccessException("JDBC DatabaseMetaData method not implemented by JDBC driver - upgrade your driver", (Throwable)err);
            }
        }

        @Nullable
        private static Dialect getDialectOrNullForDriver(@NotNull DatabaseDriver driver) {
            switch (driver) {
                case POSTGRESQL: {
                    return new PostgresDialect();
                }
                case ORACLE: {
                    return new OracleDialect();
                }
                case MYSQL: {
                    return new MySqlDialect();
                }
                case SQLSERVER: {
                    return new SqlServerDialect();
                }
                case H2: {
                    return new H2Dialect();
                }
                case SQLITE: {
                    return new SQLiteDialect();
                }
            }
            return null;
        }
    }
}

