/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.client;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.babyfish.jimmer.client.generator.openapi.OpenApiGenerator;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.client.Metadatas;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Controller
public class OpenApiController {
    private final JimmerProperties properties;

    public OpenApiController(JimmerProperties properties) {
        this.properties = properties;
    }

    @GetMapping(value={"${jimmer.client.openapi.path}"})
    public ResponseEntity<StreamingResponseBody> download(@RequestParam(name="groups", required=false) String groups) {
        Metadata metadata = Metadatas.create(false, groups, this.properties.getClient().getUriPrefix());
        OpenApiGenerator generator = new OpenApiGenerator(metadata, this.properties.getClient().getOpenapi().getProperties()){

            protected int errorHttpStatus() {
                return OpenApiController.this.properties.getErrorTranslator().getHttpStatus();
            }
        };
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/yml");
        StreamingResponseBody body = out -> {
            OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            generator.generate((Writer)writer);
            ((Writer)writer).flush();
        };
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)body);
    }
}

