/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg.support;

import java.sql.Connection;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.babyfish.jimmer.spring.cfg.support.DataSourceAwareConnectionManager;
import org.babyfish.jimmer.sql.transaction.Propagation;
import org.babyfish.jimmer.sql.transaction.TxConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringConnectionManager
implements DataSourceAwareConnectionManager,
TxConnectionManager {
    private final DataSource dataSource;
    private final Supplier<DataSourceTransactionManager> transactionManagerResolver;
    private volatile Object transactionManagerOrException;

    public SpringConnectionManager(DataSource dataSource) {
        this.dataSource = dataSource;
        this.transactionManagerResolver = null;
    }

    public SpringConnectionManager(DataSource dataSource, Supplier<DataSourceTransactionManager> transactionManagerResolver) {
        this.dataSource = dataSource;
        this.transactionManagerResolver = transactionManagerResolver;
    }

    @Override
    @NotNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public final <R> R execute(Function<Connection, R> block) {
        return this.execute(null, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
        if (con != null) {
            return block.apply(con);
        }
        Connection newConnection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            R r = block.apply(newConnection);
            return r;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)newConnection, (DataSource)this.dataSource);
        }
    }

    public final <R> R executeTransaction(Propagation propagation, Function<Connection, R> block) {
        R result;
        DataSourceTransactionManager tm = this.transactionManager();
        TransactionStatus ts = tm.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(this.behavior(propagation)));
        try {
            result = this.execute(block);
        }
        catch (Error | RuntimeException ex) {
            tm.rollback(ts);
            throw ex;
        }
        tm.commit(ts);
        return result;
    }

    private DataSourceTransactionManager transactionManager() {
        Object obj = this.transactionManagerObject();
        if (obj instanceof RuntimeException) {
            throw (RuntimeException)obj;
        }
        if (obj instanceof Error) {
            throw (Error)obj;
        }
        return (DataSourceTransactionManager)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transactionManagerObject() {
        if (this.transactionManagerOrException == null) {
            SpringConnectionManager springConnectionManager = this;
            synchronized (springConnectionManager) {
                if (this.transactionManagerOrException == null) {
                    if (this.transactionManagerResolver == null) {
                        this.transactionManagerOrException = new IllegalStateException("The current SpringConnectionManager does not support transaction management because its transactionManagerResolver is not set");
                    } else {
                        try {
                            this.transactionManagerOrException = this.transactionManagerResolver.get();
                        }
                        catch (Error | RuntimeException ex) {
                            this.transactionManagerOrException = ex;
                        }
                        if (this.transactionManagerOrException == null) {
                            this.transactionManagerOrException = new IllegalStateException("The current SpringConnectionManager does not support transaction management its transactionManagerResolver returns null");
                        }
                    }
                }
            }
        }
        return this.transactionManagerOrException;
    }

    private int behavior(Propagation propagation) {
        switch (propagation) {
            case REQUIRES_NEW: {
                return 3;
            }
            case SUPPORTS: {
                return 1;
            }
            case NOT_SUPPORTED: {
                return 4;
            }
            case MANDATORY: {
                return 2;
            }
            case NEVER: {
                return 5;
            }
        }
        return 0;
    }
}

