/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cfg;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.babyfish.jimmer.client.generator.openapi.OpenApiProperties;
import org.babyfish.jimmer.client.generator.ts.NullRenderMode;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.fetcher.ReferenceFetchType;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationMode;
import org.babyfish.jimmer.sql.runtime.IdOnlyTargetCheckingLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;

@ConstructorBinding
@ConfigurationProperties(value="jimmer")
public class JimmerProperties {
    @NotNull
    private final String language;
    @Nullable
    private final Dialect dialect;
    private final boolean showSql;
    private final boolean prettySql;
    private final boolean inlineSqlVariables;
    private final ReferenceFetchType defaultReferenceFetchType;
    private final int maxJoinFetchDepth;
    @NotNull
    private final DatabaseValidationMode databaseValidationMode;
    @NotNull
    private final TriggerType triggerType;
    private final boolean defaultDissociationActionCheckable;
    @NotNull
    private final IdOnlyTargetCheckingLevel idOnlyTargetCheckingLevel;
    private final int transactionCacheOperatorFixedDelay;
    @NotNull
    private final EnumType.Strategy defaultEnumStrategy;
    @NotNull
    private final String defaultSchema;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final boolean inListPaddingEnabled;
    private final boolean expandedInListPaddingEnabled;
    private final int offsetOptimizingThreshold;
    private final boolean reverseSortOptimizationEnabled;
    private final boolean isForeignKeyEnabledByDefault;
    private final int maxCommandJoinCount;
    private final boolean mutationTransactionRequired;
    private final boolean targetTransferable;
    private final boolean explicitBatchEnabled;
    private final boolean dumbBatchAcceptable;
    private final boolean constraintViolationTranslatable;
    private final Collection<String> executorContextPrefixes;
    @NotNull
    private final String microServiceName;
    @NotNull
    private final ErrorTranslator errorTranslator;
    @NotNull
    private final Client client;

    public JimmerProperties(@Nullable String language, @Nullable String dialect, boolean showSql, boolean prettySql, boolean inlineSqlVariables, @Nullable ReferenceFetchType defaultReferenceFetchType, @Nullable Integer maxJoinFetchDepth, @Nullable DatabaseValidationMode databaseValidationMode, @Deprecated @Nullable DatabaseValidation databaseValidation, @Nullable TriggerType triggerType, @Nullable Boolean defaultDissociationActionCheckable, @Nullable IdOnlyTargetCheckingLevel idOnlyTargetCheckingLevel, @Nullable Integer transactionCacheOperatorFixedDelay, @Nullable EnumType.Strategy defaultEnumStrategy, @Nullable String defaultSchema, @Nullable Integer defaultBatchSize, @Nullable Integer defaultListBatchSize, boolean inListPaddingEnabled, boolean expandedInListPaddingEnabled, @Nullable Integer offsetOptimizingThreshold, boolean reverseSortOptimizationEnabled, @Nullable Boolean isForeignKeyEnabledByDefault, @Nullable Integer maxCommandJoinCount, boolean mutationTransactionRequired, boolean targetTransferable, boolean explicitBatchEnabled, boolean dumbBatchAcceptable, Boolean constraintViolationTranslatable, @Nullable Collection<String> executorContextPrefixes, @Nullable String microServiceName, @Nullable ErrorTranslator errorTranslator, @Nullable Client client) {
        if (language == null) {
            this.language = "java";
        } else {
            if (!language.equalsIgnoreCase("java") && !language.equalsIgnoreCase("kotlin")) {
                throw new IllegalArgumentException("`jimmer.language` must be \"java\" or \"kotlin\"");
            }
            this.language = language;
        }
        if (dialect == null) {
            this.dialect = null;
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(dialect, true, Dialect.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("The class \"" + dialect + "\" specified by `jimmer.dialect` cannot be found");
            }
            if (!Dialect.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                throw new IllegalArgumentException("The class \"" + dialect + "\" specified by `jimmer.dialect` must be a valid dialect implementation");
            }
            try {
                this.dialect = (Dialect)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalArgumentException("Create create instance for the class \"" + dialect + "\" specified by `jimmer.dialect`", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Create create instance for the class \"" + dialect + "\" specified by `jimmer.dialect`", ex);
            }
        }
        if (prettySql && !showSql) {
            throw new IllegalArgumentException("When `pretty-sql` is true, `show-sql` must be true");
        }
        if (inlineSqlVariables && !prettySql) {
            throw new IllegalArgumentException("When `inline-sql-variables` is true, `pretty-sql` must be true");
        }
        this.showSql = showSql;
        this.prettySql = prettySql;
        this.inlineSqlVariables = inlineSqlVariables;
        this.defaultReferenceFetchType = defaultReferenceFetchType != null ? defaultReferenceFetchType : ReferenceFetchType.SELECT;
        int n = this.maxJoinFetchDepth = maxJoinFetchDepth != null ? maxJoinFetchDepth : 3;
        if (databaseValidationMode != null && databaseValidation != null) {
            throw new IllegalArgumentException("Conflict configuration properties: \"jimmer.database-validation-mode\" and \"jimmer.database-validation.mode(deprecated)\"");
        }
        this.databaseValidationMode = databaseValidationMode != null ? databaseValidationMode : (databaseValidation != null ? databaseValidation.getMode() : DatabaseValidationMode.NONE);
        this.triggerType = triggerType != null ? triggerType : TriggerType.BINLOG_ONLY;
        this.defaultDissociationActionCheckable = defaultDissociationActionCheckable != null ? defaultDissociationActionCheckable : true;
        this.idOnlyTargetCheckingLevel = idOnlyTargetCheckingLevel != null ? idOnlyTargetCheckingLevel : IdOnlyTargetCheckingLevel.NONE;
        this.transactionCacheOperatorFixedDelay = transactionCacheOperatorFixedDelay != null ? transactionCacheOperatorFixedDelay : 5000;
        this.defaultEnumStrategy = defaultEnumStrategy != null ? defaultEnumStrategy : EnumType.Strategy.NAME;
        this.defaultSchema = defaultSchema != null ? defaultSchema : "";
        this.defaultBatchSize = defaultBatchSize != null ? defaultBatchSize : 128;
        this.defaultListBatchSize = defaultListBatchSize != null ? defaultListBatchSize : 16;
        this.inListPaddingEnabled = inListPaddingEnabled;
        this.expandedInListPaddingEnabled = expandedInListPaddingEnabled;
        this.offsetOptimizingThreshold = offsetOptimizingThreshold != null ? offsetOptimizingThreshold : Integer.MAX_VALUE;
        this.reverseSortOptimizationEnabled = reverseSortOptimizationEnabled;
        this.isForeignKeyEnabledByDefault = isForeignKeyEnabledByDefault != null ? isForeignKeyEnabledByDefault : true;
        this.maxCommandJoinCount = maxCommandJoinCount != null ? maxCommandJoinCount : 2;
        this.mutationTransactionRequired = mutationTransactionRequired;
        this.targetTransferable = targetTransferable;
        this.explicitBatchEnabled = explicitBatchEnabled;
        this.dumbBatchAcceptable = dumbBatchAcceptable;
        this.constraintViolationTranslatable = constraintViolationTranslatable != null ? constraintViolationTranslatable : true;
        this.executorContextPrefixes = executorContextPrefixes;
        this.microServiceName = microServiceName != null ? microServiceName : "";
        this.errorTranslator = errorTranslator == null ? new ErrorTranslator(null, null, null, null) : errorTranslator;
        this.client = client == null ? new Client(null, null, null) : client;
    }

    @NotNull
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public boolean isPrettySql() {
        return this.prettySql;
    }

    public boolean isInlineSqlVariables() {
        return this.inlineSqlVariables;
    }

    public ReferenceFetchType getDefaultReferenceFetchType() {
        return this.defaultReferenceFetchType;
    }

    public int getMaxJoinFetchDepth() {
        return this.maxJoinFetchDepth;
    }

    @NotNull
    public DatabaseValidation getDatabaseValidation() {
        return new DatabaseValidation(this.databaseValidationMode, null, null);
    }

    @NotNull
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public boolean isDefaultDissociationActionCheckable() {
        return this.defaultDissociationActionCheckable;
    }

    @NotNull
    public IdOnlyTargetCheckingLevel getIdOnlyTargetCheckingLevel() {
        return this.idOnlyTargetCheckingLevel;
    }

    @NotNull
    public EnumType.Strategy getDefaultEnumStrategy() {
        return this.defaultEnumStrategy;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    public boolean isInListPaddingEnabled() {
        return this.inListPaddingEnabled;
    }

    public boolean isExpandedInListPaddingEnabled() {
        return this.expandedInListPaddingEnabled;
    }

    public int getOffsetOptimizingThreshold() {
        return this.offsetOptimizingThreshold;
    }

    public boolean isReverseSortOptimizationEnabled() {
        return this.reverseSortOptimizationEnabled;
    }

    public boolean isForeignKeyEnabledByDefault() {
        return this.isForeignKeyEnabledByDefault;
    }

    public int getMaxCommandJoinCount() {
        return this.maxCommandJoinCount;
    }

    public boolean isMutationTransactionRequired() {
        return this.mutationTransactionRequired;
    }

    public boolean isTargetTransferable() {
        return this.targetTransferable;
    }

    public boolean isExplicitBatchEnabled() {
        return this.explicitBatchEnabled;
    }

    public boolean isDumbBatchAcceptable() {
        return this.dumbBatchAcceptable;
    }

    public boolean isConstraintViolationTranslatable() {
        return this.constraintViolationTranslatable;
    }

    @Nullable
    public Collection<String> getExecutorContextPrefixes() {
        return this.executorContextPrefixes;
    }

    @NotNull
    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @NotNull
    public ErrorTranslator getErrorTranslator() {
        return this.errorTranslator;
    }

    @NotNull
    public Client getClient() {
        return this.client;
    }

    public String toString() {
        return "JimmerProperties{language='" + this.language + '\'' + ", dialect=" + this.dialect + ", showSql=" + this.showSql + ", prettySql=" + this.prettySql + ", inlineSqlVariables=" + this.inlineSqlVariables + ", databaseValidationMode=" + this.databaseValidationMode + ", triggerType=" + this.triggerType + ", defaultDissociationActionCheckable=" + this.defaultDissociationActionCheckable + ", idOnlyTargetCheckingLevel=" + this.idOnlyTargetCheckingLevel + ", transactionCacheOperatorFixedDelay=" + this.transactionCacheOperatorFixedDelay + ", defaultEnumStrategy=" + this.defaultEnumStrategy + ", defaultBatchSize=" + this.defaultBatchSize + ", defaultListBatchSize=" + this.defaultListBatchSize + ", inListPaddingEnabled=" + this.inListPaddingEnabled + ", expandedInListPaddingEnabled=" + this.expandedInListPaddingEnabled + ", offsetOptimizingThreshold=" + this.offsetOptimizingThreshold + ", isForeignKeyEnabledByDefault=" + this.isForeignKeyEnabledByDefault + ", maxCommandJoinCount=" + this.maxCommandJoinCount + ", targetTransferable=" + this.targetTransferable + ", executorContextPrefixes=" + this.executorContextPrefixes + ", microServiceName='" + this.microServiceName + '\'' + ", errorTranslator=" + this.errorTranslator + ", client=" + this.client + '}';
    }

    @Deprecated
    @ConstructorBinding
    public static class DatabaseValidation {
        @NotNull
        private final DatabaseValidationMode mode;

        @Deprecated
        public DatabaseValidation(@Nullable DatabaseValidationMode mode, @Nullable String catalog, @Nullable String schema) {
            this.mode = mode != null ? mode : DatabaseValidationMode.NONE;
        }

        @NotNull
        public DatabaseValidationMode getMode() {
            return this.mode;
        }

        public String toString() {
            return "Validation{mode=" + this.mode + '}';
        }
    }

    @ConstructorBinding
    public static class ErrorTranslator {
        private final boolean disabled;
        private final int httpStatus;
        private final boolean debugInfoSupported;
        private final int debugInfoMaxStackTraceCount;

        public ErrorTranslator(Boolean disabled, Integer httpStatus, Boolean debugInfoSupported, Integer debugInfoMaxStackTraceCount) {
            this.disabled = disabled != null ? disabled : false;
            this.httpStatus = httpStatus != null ? httpStatus : 500;
            this.debugInfoSupported = debugInfoSupported != null ? debugInfoSupported : false;
            this.debugInfoMaxStackTraceCount = debugInfoMaxStackTraceCount != null ? debugInfoMaxStackTraceCount : Integer.MAX_VALUE;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        @NotNull
        public int getHttpStatus() {
            return this.httpStatus;
        }

        public boolean isDebugInfoSupported() {
            return this.debugInfoSupported;
        }

        public int getDebugInfoMaxStackTraceCount() {
            return this.debugInfoMaxStackTraceCount;
        }

        public String toString() {
            return "ErrorTranslator{httpStatus=" + this.httpStatus + ", debugInfoSupported=" + this.debugInfoSupported + '}';
        }
    }

    @ConstructorBinding
    public static class Client {
        @Nullable
        private final String uriPrefix;
        @NotNull
        private final TypeScript ts;
        @NotNull
        private final Openapi openapi;

        public Client(@Nullable String uriPrefix, @Nullable TypeScript ts, @Nullable Openapi openapi) {
            this.uriPrefix = uriPrefix;
            this.ts = ts == null ? new TypeScript(null, "Api", 4, false, null, false) : ts;
            this.openapi = openapi == null ? new Openapi("/openapi.yml", "/openapi.html", null, null) : openapi;
        }

        @Nullable
        public String getUriPrefix() {
            return this.uriPrefix;
        }

        @NotNull
        public TypeScript getTs() {
            return this.ts;
        }

        @NotNull
        public Openapi getOpenapi() {
            return this.openapi;
        }

        public String toString() {
            return "Client{ts=" + this.ts + ", openapi=" + this.openapi + '}';
        }

        @ConstructorBinding
        public static class TypeScript {
            @Nullable
            private final String path;
            @NotNull
            private final String apiName;
            private final int indent;
            private final boolean mutable;
            private final NullRenderMode nullRenderMode;
            private final boolean isEnumTsStyle;

            public TypeScript(@Nullable String path, @Nullable String apiName, int indent, boolean mutable, @Nullable NullRenderMode nullRenderMode, boolean isEnumTsStyle) {
                if (path == null || path.isEmpty()) {
                    this.path = null;
                } else {
                    if (!path.startsWith("/")) {
                        throw new IllegalArgumentException("`jimmer.client.ts.path` must start with \"/\"");
                    }
                    this.path = path;
                }
                this.apiName = apiName == null || apiName.isEmpty() ? "Api" : apiName;
                this.indent = indent != 0 ? Math.max(indent, 2) : 4;
                this.mutable = mutable;
                this.nullRenderMode = nullRenderMode != null ? nullRenderMode : NullRenderMode.UNDEFINED;
                this.isEnumTsStyle = isEnumTsStyle;
            }

            @Nullable
            public String getPath() {
                return this.path;
            }

            @NotNull
            public String getApiName() {
                return this.apiName;
            }

            public int getIndent() {
                return this.indent;
            }

            public boolean isMutable() {
                return this.mutable;
            }

            public NullRenderMode getNullRenderMode() {
                return this.nullRenderMode;
            }

            public boolean isEnumTsStyle() {
                return this.isEnumTsStyle;
            }

            public String toString() {
                return "TypeScript{path='" + this.path + '\'' + '}';
            }
        }

        @ConstructorBinding
        public static class Openapi {
            private final String path;
            private final String uiPath;
            private final String refPath;
            private final OpenApiProperties properties;

            public Openapi(String path, String uiPath, String refPath, OpenApiProperties properties) {
                this.path = path == null || path.isEmpty() ? null : (!path.startsWith("/") ? '/' + path : path);
                if (uiPath == null || uiPath.isEmpty()) {
                    this.uiPath = null;
                } else {
                    if (!uiPath.startsWith("/")) {
                        throw new IllegalArgumentException("`jimmer.client.openapi.ui-path` must start with \"/\"");
                    }
                    this.uiPath = uiPath;
                }
                this.refPath = refPath == null || refPath.isEmpty() ? (path == null || path.isEmpty() ? null : path) : refPath;
                OpenApiProperties.Info info = properties != null ? properties.getInfo() : null;
                this.properties = OpenApiProperties.newBuilder((OpenApiProperties)properties).setInfo(OpenApiProperties.newInfoBuilder((OpenApiProperties.Info)(properties != null ? properties.getInfo() : null)).setTitle(info != null && info.getTitle() != null ? info.getTitle() : "<`jimmer.client.openapi.properties.info.title` is unspecified>").setDescription(info != null && info.getDescription() != null ? info.getDescription() : "<`jimmer.client.openapi.properties.info.description` is unspecified>").setVersion(info != null && info.getVersion() != null ? info.getVersion() : "<`jimmer.client.openapi.properties.info.version` is unspecified>").build()).build();
            }

            public String getPath() {
                return this.path;
            }

            public String getUiPath() {
                return this.uiPath;
            }

            public String getRefPath() {
                return this.refPath;
            }

            public OpenApiProperties getProperties() {
                return this.properties;
            }

            public String toString() {
                return "Openapi{apiPath='" + this.path + '\'' + ", uiPath='" + this.uiPath + '\'' + ", properties=" + this.properties + '}';
            }
        }

        @ConstructorBinding
        public static class JavaFeign {
            @Nullable
            private final String path;
            @NotNull
            private final String apiName;
            private final int indent;
            private final String basePackage;

            public JavaFeign(@Nullable String path, @Nullable String apiName, int indent, @Nullable String basePackage) {
                if (path == null || path.isEmpty()) {
                    this.path = null;
                } else {
                    if (!path.startsWith("/")) {
                        throw new IllegalArgumentException("`jimmer.client.ts.path` must start with \"/\"");
                    }
                    this.path = path;
                }
                this.apiName = apiName == null || apiName.isEmpty() ? "Api" : apiName;
                this.indent = indent != 0 ? Math.max(indent, 2) : 4;
                this.basePackage = basePackage == null || basePackage.isEmpty() ? "" : basePackage;
            }

            @Nullable
            public String getPath() {
                return this.path;
            }

            @NotNull
            public String getApiName() {
                return this.apiName;
            }

            public int getIndent() {
                return this.indent;
            }

            public String getBasePackage() {
                return this.basePackage;
            }

            public String toString() {
                return "JavaFeign{path='" + this.path + '\'' + ", clientName='" + this.apiName + '\'' + ", indent=" + this.indent + ", basePackage=" + this.basePackage + '}';
            }
        }
    }
}

