/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cache.impl;

import java.util.List;
import org.babyfish.jimmer.sql.cache.TransactionCacheOperator;
import org.babyfish.jimmer.sql.event.DatabaseEvent;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

public class TransactionCacheOperatorFlusher {
    private final List<TransactionCacheOperator> operators;
    private final ThreadLocal<Boolean> dirtyLocal = new ThreadLocal();

    public TransactionCacheOperatorFlusher(List<TransactionCacheOperator> operators) {
        if (operators.isEmpty()) {
            throw new IllegalArgumentException("`operators` cannot be empty");
        }
        this.operators = operators;
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT)
    public void beforeCommit(DatabaseEvent e) {
        this.dirtyLocal.set(Boolean.TRUE);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT)
    public void afterCommit(DatabaseEvent e) {
        if (this.dirtyLocal.get() != null) {
            this.dirtyLocal.remove();
            this.flush();
        }
    }

    @Scheduled(fixedDelayString="${jimmer.transaction-cache-operator-fixed-delay:5000}", initialDelay=0L)
    public void retry() {
        this.flush();
    }

    private void flush() {
        if (this.operators.size() == 1) {
            TransactionCacheOperator operator = this.operators.get(0);
            operator.flush();
        } else {
            Throwable throwable = null;
            for (TransactionCacheOperator operator : this.operators) {
                try {
                    operator.flush();
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }
}

