/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.spring.cache.RedisCaches;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.RemoteKeyPrefixProvider;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteHashBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;

public class RedisHashBinder<K, V>
extends AbstractRemoteHashBinder<K, V> {
    private final RedisOperations<String, byte[]> operations;

    protected RedisHashBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker, @Nullable ObjectMapper objectMapper, @Nullable RemoteKeyPrefixProvider keyPrefixProvider, @NotNull Duration duration, int randomPercent, @NotNull RedisOperations<String, byte[]> operations) {
        super(type, prop, tracker, objectMapper, keyPrefixProvider, duration, randomPercent);
        this.operations = operations;
    }

    protected List<byte[]> read(final Collection<String> keys, final String hashKey) {
        return this.operations.executePipelined((SessionCallback)new SessionCallback<Void>(){

            public <XK, XV> Void execute(RedisOperations<XK, XV> pops) throws DataAccessException {
                RedisOperations<XK, XV> pipelinedOps = pops;
                for (String key : keys) {
                    pipelinedOps.opsForHash().get((Object)key, (Object)hashKey);
                }
                return null;
            }
        });
    }

    protected void write(final Map<String, byte[]> map, final String hashKey) {
        this.operations.executePipelined((SessionCallback)new SessionCallback<Void>(){

            public <XK, XV> Void execute(RedisOperations<XK, XV> pops) throws DataAccessException {
                RedisOperations<XK, XV> pipelinedOps = pops;
                for (Map.Entry e : map.entrySet()) {
                    pipelinedOps.opsForHash().put((Object)((String)e.getKey()), (Object)hashKey, e.getValue());
                    pipelinedOps.expire((Object)((String)e.getKey()), RedisHashBinder.this.nextExpireMillis(), TimeUnit.MILLISECONDS);
                }
                return null;
            }
        });
    }

    protected void deleteAllSerializedKeys(List<String> serializedKeys) {
        this.operations.delete(serializedKeys);
    }

    protected boolean matched(@Nullable Object reason) {
        return "redis".equals(reason);
    }

    @NotNull
    public static <K, V> Builder<K, V> forProp(ImmutableProp prop) {
        return new Builder(null, prop);
    }

    public static class Builder<K, V>
    extends AbstractRemoteBinder.AbstractBuilder<K, V, Builder<K, V>> {
        private RedisOperations<String, byte[]> operations;

        protected Builder(ImmutableType type, ImmutableProp prop) {
            super(type, prop);
        }

        public Builder<K, V> redis(RedisOperations<String, byte[]> operations) {
            this.operations = operations;
            return this;
        }

        public Builder<K, V> redis(RedisConnectionFactory connectionFactory) {
            this.operations = RedisCaches.cacheRedisTemplate(connectionFactory);
            return this;
        }

        public RedisHashBinder<K, V> build() {
            if (this.operations == null) {
                throw new IllegalStateException("Redis operations or redis connection factory has not been specified");
            }
            return new RedisHashBinder(this.type, this.prop, this.tracker, this.objectMapper, this.keyPrefixProvider, this.duration, this.randomPercent, this.operations);
        }
    }
}

