/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.babyfish.jimmer.impl.util.ObjectUtil;
import org.babyfish.jimmer.spring.cfg.JimmerProperties;
import org.babyfish.jimmer.spring.cfg.support.SpringConnectionManager;
import org.babyfish.jimmer.spring.cfg.support.SpringLogicalDeletedValueGeneratorProvider;
import org.babyfish.jimmer.spring.cfg.support.SpringTransientResolverProvider;
import org.babyfish.jimmer.spring.cfg.support.SpringUserIdGeneratorProvider;
import org.babyfish.jimmer.spring.dialect.DialectDetector;
import org.babyfish.jimmer.spring.meta.SpringMetaStringResolver;
import org.babyfish.jimmer.spring.util.ApplicationContextUtils;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.di.AopProxyProvider;
import org.babyfish.jimmer.sql.di.JLazyInitializationSqlClient;
import org.babyfish.jimmer.sql.di.LogicalDeletedValueGeneratorProvider;
import org.babyfish.jimmer.sql.di.TransientResolverProvider;
import org.babyfish.jimmer.sql.di.UserIdGeneratorProvider;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.kt.cfg.KCustomizer;
import org.babyfish.jimmer.sql.kt.cfg.KCustomizerKt;
import org.babyfish.jimmer.sql.kt.cfg.KInitializer;
import org.babyfish.jimmer.sql.kt.cfg.KInitializerKt;
import org.babyfish.jimmer.sql.kt.filter.KFilter;
import org.babyfish.jimmer.sql.kt.filter.impl.JavaFiltersKt;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.DatabaseSchemaStrategy;
import org.babyfish.jimmer.sql.meta.DefaultDatabaseSchemaStrategy;
import org.babyfish.jimmer.sql.meta.MetaStringResolver;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Customizer;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.Initializer;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.babyfish.jimmer.sql.runtime.PropScalarProviderFactory;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.util.StringValueResolver;

class JSpringSqlClient
extends JLazyInitializationSqlClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSpringSqlClient.class);
    private final ApplicationContext ctx;
    private final DataSource dataSource;
    private final Consumer<JSqlClient.Builder> block;
    private final boolean isKotlin;

    public JSpringSqlClient(ApplicationContext ctx, DataSource dataSource, Consumer<JSqlClient.Builder> block, boolean isKotlin) {
        this.ctx = Objects.requireNonNull(ctx, "ctx cannot be null");
        this.dataSource = dataSource;
        this.block = block;
        this.isKotlin = isKotlin;
    }

    protected JSqlClient.Builder createBuilder() {
        boolean isCfgKotlin = "kotlin".equalsIgnoreCase(this.getRequiredBean(JimmerProperties.class).getLanguage());
        if (isCfgKotlin != this.isKotlin) {
            throw new IllegalStateException("Cannot create sql client for \"" + (this.isKotlin ? "kotlin" : "java") + "\" because \"jimmer.language\" in \"application.properties/application.yml\" is \"" + (isCfgKotlin ? "kotlin" : "java") + "\"");
        }
        JimmerProperties properties = this.getRequiredBean(JimmerProperties.class);
        UserIdGeneratorProvider userIdGeneratorProvider = this.getOptionalBean(UserIdGeneratorProvider.class);
        LogicalDeletedValueGeneratorProvider logicalDeletedValueGeneratorProvider = this.getOptionalBean(LogicalDeletedValueGeneratorProvider.class);
        TransientResolverProvider transientResolverProvider = this.getOptionalBean(TransientResolverProvider.class);
        AopProxyProvider aopProxyProvider = this.getOptionalBean(AopProxyProvider.class);
        EntityManager entityManager = this.getOptionalBean(EntityManager.class);
        DatabaseSchemaStrategy databaseSchemaStrategy = this.getOptionalBean(DatabaseSchemaStrategy.class);
        DatabaseNamingStrategy databaseNamingStrategy = this.getOptionalBean(DatabaseNamingStrategy.class);
        MetaStringResolver metaStringResolver = this.getOptionalBean(MetaStringResolver.class);
        Dialect dialect = this.getOptionalBean(Dialect.class);
        DialectDetector dialectDetector = this.getOptionalBean(DialectDetector.class);
        Executor executor = this.getOptionalBean(Executor.class);
        SqlFormatter sqlFormatter = this.getOptionalBean(SqlFormatter.class);
        ObjectMapper objectMapper = this.getOptionalBean(ObjectMapper.class);
        CacheFactory cacheFactory = this.getOptionalBean(CacheFactory.class);
        CacheOperator cacheOperator = this.getOptionalBean(CacheOperator.class);
        MicroServiceExchange exchange = this.getOptionalBean(MicroServiceExchange.class);
        Collection callbacks = this.getObjects(CacheAbandonedCallback.class);
        Collection providers = this.getObjects(ScalarProvider.class);
        Collection factories = this.getObjects(PropScalarProviderFactory.class);
        Collection processors = this.getObjects(DraftPreProcessor.class);
        Collection interceptors = this.getObjects(DraftInterceptor.class);
        Collection exceptionTranslators = this.getObjects(ExceptionTranslator.class);
        JSqlClient.Builder builder = JSqlClient.newBuilder();
        if (userIdGeneratorProvider != null) {
            builder.setUserIdGeneratorProvider(userIdGeneratorProvider);
        } else {
            builder.setUserIdGeneratorProvider((UserIdGeneratorProvider)new SpringUserIdGeneratorProvider(this.ctx));
        }
        if (logicalDeletedValueGeneratorProvider != null) {
            builder.setLogicalDeletedValueGeneratorProvider(logicalDeletedValueGeneratorProvider);
        } else {
            builder.setLogicalDeletedValueGeneratorProvider((LogicalDeletedValueGeneratorProvider)new SpringLogicalDeletedValueGeneratorProvider(this.ctx));
        }
        if (transientResolverProvider != null) {
            builder.setTransientResolverProvider(transientResolverProvider);
        } else {
            builder.setTransientResolverProvider((TransientResolverProvider)new SpringTransientResolverProvider(this.ctx));
        }
        if (aopProxyProvider != null) {
            builder.setAopProxyProvider(aopProxyProvider);
        } else {
            builder.setAopProxyProvider(AopUtils::getTargetClass);
        }
        if (entityManager != null) {
            builder.setEntityManager(entityManager);
        }
        if (databaseSchemaStrategy != null) {
            builder.setDatabaseSchemaStrategy(databaseSchemaStrategy);
        } else if (!properties.getDefaultSchema().isEmpty()) {
            builder.setDatabaseSchemaStrategy((DatabaseSchemaStrategy)new DefaultDatabaseSchemaStrategy(properties.getDefaultSchema()));
        }
        builder.setDatabaseSchemaStrategy((DatabaseSchemaStrategy)(databaseSchemaStrategy != null ? databaseSchemaStrategy : new DefaultDatabaseSchemaStrategy(properties.getDefaultSchema())));
        if (databaseNamingStrategy != null) {
            builder.setDatabaseNamingStrategy(databaseNamingStrategy);
        }
        if (metaStringResolver != null) {
            builder.setMetaStringResolver(metaStringResolver);
        } else if (this.ctx instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.ctx).getBeanFactory();
            builder.setMetaStringResolver((MetaStringResolver)new SpringMetaStringResolver((StringValueResolver)new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory)));
        }
        builder.setTriggerType(properties.getTriggerType());
        builder.setDefaultReferenceFetchType(properties.getDefaultReferenceFetchType());
        builder.setMaxJoinFetchDepth(properties.getMaxJoinFetchDepth());
        builder.setDefaultDissociateActionCheckable(properties.isDefaultDissociationActionCheckable());
        builder.setIdOnlyTargetCheckingLevel(properties.getIdOnlyTargetCheckingLevel());
        builder.setDefaultEnumStrategy(properties.getDefaultEnumStrategy());
        builder.setDefaultBatchSize(properties.getDefaultBatchSize());
        builder.setDefaultListBatchSize(properties.getDefaultListBatchSize());
        builder.setInListPaddingEnabled(properties.isInListPaddingEnabled());
        builder.setExpandedInListPaddingEnabled(properties.isExpandedInListPaddingEnabled());
        builder.setOffsetOptimizingThreshold(properties.getOffsetOptimizingThreshold());
        builder.setReverseSortOptimizationEnabled(properties.isReverseSortOptimizationEnabled());
        builder.setForeignKeyEnabledByDefault(properties.isForeignKeyEnabledByDefault());
        builder.setMaxCommandJoinCount(properties.getMaxCommandJoinCount());
        builder.setMutationTransactionRequired(properties.isMutationTransactionRequired());
        builder.setTargetTransferable(properties.isTargetTransferable());
        builder.setExplicitBatchEnabled(properties.isExplicitBatchEnabled());
        builder.setDumbBatchAcceptable(properties.isDumbBatchAcceptable());
        builder.setConstraintViolationTranslatable(properties.isConstraintViolationTranslatable());
        builder.setExecutorContextPrefixes(properties.getExecutorContextPrefixes());
        if (properties.isShowSql()) {
            builder.setExecutor(Executor.log((Executor)executor));
        } else {
            builder.setExecutor(executor);
        }
        if (sqlFormatter != null) {
            builder.setSqlFormatter(sqlFormatter);
        } else if (properties.isPrettySql()) {
            if (properties.isInlineSqlVariables()) {
                builder.setSqlFormatter(SqlFormatter.INLINE_PRETTY);
            } else {
                builder.setSqlFormatter(SqlFormatter.PRETTY);
            }
        }
        builder.setDatabaseValidationMode(properties.getDatabaseValidation().getMode()).setDefaultSerializedTypeObjectMapper(objectMapper).setCacheFactory(cacheFactory).setCacheOperator(cacheOperator).addCacheAbandonedCallbacks(callbacks);
        for (ScalarProvider provider : providers) {
            builder.addScalarProvider(provider);
        }
        for (PropScalarProviderFactory factory : factories) {
            builder.addPropScalarProviderFactory(factory);
        }
        builder.addDraftPreProcessors(processors);
        builder.addDraftInterceptors(interceptors);
        builder.addExceptionTranslators(exceptionTranslators);
        this.initializeByLanguage(builder);
        builder.addInitializers(new Initializer[]{new SpringEventInitializer((ApplicationEventPublisher)this.ctx)});
        builder.setMicroServiceName(properties.getMicroServiceName());
        if (!properties.getMicroServiceName().isEmpty()) {
            builder.setMicroServiceExchange(exchange);
        }
        if (this.block != null) {
            this.block.accept(builder);
        }
        ConnectionManager connectionManager = (ConnectionManager)ObjectUtil.firstNonNullOf((Supplier[])new Supplier[]{() -> ((JSqlClientImplementor.Builder)builder).getConnectionManager(), () -> this.getOptionalBean(ConnectionManager.class), () -> this.dataSource == null ? null : new SpringConnectionManager(this.dataSource, () -> this.getOptionalBean(DataSourceTransactionManager.class)), () -> new SpringConnectionManager(this.getRequiredBean(DataSource.class), () -> this.getOptionalBean(DataSourceTransactionManager.class))});
        builder.setConnectionManager(connectionManager);
        if (((JSqlClientImplementor.Builder)builder).getDialect().getClass() == DefaultDialect.class) {
            DialectDetector finalDetector = dialectDetector != null ? dialectDetector : DialectDetector.INSTANCE;
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> dialect;
            supplierArray[1] = properties::getDialect;
            supplierArray[2] = () -> (Dialect)connectionManager.execute(finalDetector::detectDialect);
            builder.setDialect((Dialect)ObjectUtil.optionalFirstNonNullOf((Supplier[])supplierArray));
        }
        return builder;
    }

    private void initializeByLanguage(JSqlClient.Builder builder) {
        Collection javaFilters = this.getObjects(Filter.class);
        Collection javaCustomizers = this.getObjects(Customizer.class);
        Collection javaInitializers = this.getObjects(Initializer.class);
        Collection kotlinFilters = this.getObjects(KFilter.class);
        Collection kotlinCustomizers = this.getObjects(KCustomizer.class);
        Collection kotlinInitializers = this.getObjects(KInitializer.class);
        if (this.isKotlin) {
            if (!javaFilters.isEmpty()) {
                LOGGER.warn("Jimmer is working in kotlin mode, but some java filters has been found in spring context, they will be ignored");
            }
            if (!javaCustomizers.isEmpty()) {
                LOGGER.warn("Jimmer is working in kotlin mode, but some java customizers has been found in spring context, they will be ignored");
            }
            if (!javaInitializers.isEmpty()) {
                LOGGER.warn("Jimmer is working in kotlin mode, but some java initializers has been found in spring context, they will be ignored");
            }
            builder.addFilters((Collection)kotlinFilters.stream().map(JavaFiltersKt::toJavaFilter).collect(Collectors.toList()));
            builder.addCustomizers((Collection)kotlinCustomizers.stream().map(KCustomizerKt::toJavaCustomizer).collect(Collectors.toList()));
            builder.addInitializers((Collection)kotlinInitializers.stream().map(KInitializerKt::toJavaInitializer).collect(Collectors.toList()));
        } else {
            if (!kotlinFilters.isEmpty()) {
                LOGGER.warn("Jimmer is working in java mode, but some kotlin filters has been found in spring context, they will be ignored");
            }
            if (!kotlinCustomizers.isEmpty()) {
                LOGGER.warn("Jimmer is working in java mode, but some kotlin customizers has been found in spring context, they will be ignored");
            }
            if (!kotlinInitializers.isEmpty()) {
                LOGGER.warn("Jimmer is working in kotlin mode, but some kotlin initializers has been found in spring context, they will be ignored");
            }
            builder.addFilters(javaFilters);
            builder.addCustomizers(javaCustomizers);
            builder.addInitializers(javaInitializers);
        }
    }

    private <T> T getRequiredBean(Class<T> type) {
        return (T)this.ctx.getBean(type);
    }

    private <T> T getOptionalBean(Class<T> type) {
        try {
            return (T)this.ctx.getBean(type);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private <T> Collection<T> getObjects(Class<?> beanType) {
        return ApplicationContextUtils.getBeansOfType(this.ctx, beanType);
    }

    private static class SpringEventInitializer
    implements Initializer {
        private final ApplicationEventPublisher publisher;

        private SpringEventInitializer(ApplicationEventPublisher publisher) {
            this.publisher = publisher;
        }

        public void initialize(JSqlClient sqlClient) throws Exception {
            Triggers[] triggersArr;
            Triggers[] triggersArray;
            if (((JSqlClientImplementor)sqlClient).getTriggerType() == TriggerType.BOTH) {
                Triggers[] triggersArray2 = new Triggers[2];
                triggersArray2[0] = sqlClient.getTriggers();
                triggersArray = triggersArray2;
                triggersArray2[1] = sqlClient.getTriggers(true);
            } else {
                Triggers[] triggersArray3 = new Triggers[1];
                triggersArray = triggersArray3;
                triggersArray3[0] = sqlClient.getTriggers();
            }
            for (Triggers triggers : triggersArr = triggersArray) {
                triggers.addEntityListener(arg_0 -> ((ApplicationEventPublisher)this.publisher).publishEvent(arg_0));
                triggers.addAssociationListener(arg_0 -> ((ApplicationEventPublisher)this.publisher).publishEvent(arg_0));
            }
        }
    }
}

