/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.runtime.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.meta.ApiOperation;
import org.babyfish.jimmer.client.meta.ApiParameter;
import org.babyfish.jimmer.client.meta.ApiService;
import org.babyfish.jimmer.client.meta.Schema;
import org.babyfish.jimmer.client.meta.TypeName;
import org.babyfish.jimmer.client.meta.TypeRef;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Parameter;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.SimpleType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.VirtualType;
import org.babyfish.jimmer.client.runtime.impl.DynamicTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.EmbeddableTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.EnumTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.FetchedTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;
import org.babyfish.jimmer.client.runtime.impl.MetadataImpl;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.OperationImpl;
import org.babyfish.jimmer.client.runtime.impl.ParameterImpl;
import org.babyfish.jimmer.client.runtime.impl.ServiceImpl;
import org.babyfish.jimmer.client.runtime.impl.SimpleTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.StaticObjectTypeImpl;
import org.babyfish.jimmer.client.runtime.impl.TypeContext;

public class MetadataBuilder
implements Metadata.Builder {
    private Metadata.OperationParser operationParser;
    private Metadata.ParameterParser parameterParser;
    private Set<String> groups;
    private boolean genericSupported;
    private String uriPrefix;
    private Map<TypeName, VirtualType> virtualTypeMap = Collections.emptyMap();
    private Set<Class<?>> ignoredParameterTypes = new HashSet();
    private Set<Class<?>> illegalReturnTypes = new HashSet();
    private Set<String> ignoredParameterTypeNames = new HashSet<String>();
    private Set<String> illegalReturnTypeNames = new HashSet<String>();

    public MetadataBuilder() {
        this.ignoredParameterTypeNames.add("javax.servlet.ServletRequest");
        this.ignoredParameterTypeNames.add("javax.servlet.http.HttpServletRequest");
        this.ignoredParameterTypeNames.add("jakarta.servlet.ServletRequest");
        this.ignoredParameterTypeNames.add("jakarta.servlet.http.HttpServletRequest");
        this.ignoredParameterTypeNames.add("javax.servlet.ServletResponse");
        this.ignoredParameterTypeNames.add("javax.servlet.http.HttpServletResponse");
        this.ignoredParameterTypeNames.add("jakarta.servlet.ServletResponse");
        this.ignoredParameterTypeNames.add("jakarta.servlet.http.HttpServletResponse");
    }

    @Override
    public Metadata.Builder setOperationParser(Metadata.OperationParser operationParser) {
        this.operationParser = operationParser;
        return this;
    }

    @Override
    public Metadata.Builder setParameterParser(Metadata.ParameterParser parameterParser) {
        this.parameterParser = parameterParser;
        return this;
    }

    @Override
    public Metadata.Builder setGroups(Collection<String> groups) {
        if (groups != null && !groups.isEmpty()) {
            HashSet<String> set = new HashSet<String>((groups.size() * 4 + 2) / 3);
            for (String group : groups) {
                String trim = group.trim();
                if (!trim.isEmpty()) {
                    set.add(trim);
                }
                this.groups = set.isEmpty() ? null : set;
            }
        } else {
            this.groups = null;
        }
        return this;
    }

    @Override
    public Metadata.Builder setGenericSupported(boolean genericSupported) {
        this.genericSupported = genericSupported;
        return this;
    }

    @Override
    public Metadata.Builder setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
        return this;
    }

    @Override
    public MetadataBuilder setVirtualTypeMap(Map<TypeName, VirtualType> virtualTypeMap) {
        this.virtualTypeMap = virtualTypeMap != null && !virtualTypeMap.isEmpty() ? virtualTypeMap : Collections.emptyMap();
        return this;
    }

    @Override
    public Metadata.Builder addIgnoredParameterTypes(Class<?> ... types) {
        this.ignoredParameterTypes.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public Metadata.Builder addIllegalReturnTypes(Class<?> ... types) {
        this.illegalReturnTypes.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public Metadata.Builder addIgnoredParameterTypeNames(String ... typeNames) {
        this.ignoredParameterTypeNames.addAll(Arrays.asList(typeNames));
        return this;
    }

    @Override
    public Metadata.Builder addIllegalReturnTypeNames(String ... typeNames) {
        this.illegalReturnTypeNames.addAll(Arrays.asList(typeNames));
        return this;
    }

    @Override
    public Metadata build() {
        if (this.operationParser == null) {
            throw new IllegalStateException("Operation parse has not been set");
        }
        if (this.parameterParser == null) {
            throw new IllegalStateException("ParameterParser parse has not been set");
        }
        Schema schema = MetadataBuilder.loadSchema(this.groups);
        TypeContext ctx = new TypeContext(schema.getTypeDefinitionMap(), this.virtualTypeMap, this.genericSupported);
        ArrayList<ServiceImpl> services = new ArrayList<ServiceImpl>();
        for (ApiService apiService : schema.getApiServiceMap().values()) {
            services.add(this.service(apiService, ctx));
        }
        ArrayList<FetchedTypeImpl> fetchedTypes = new ArrayList<FetchedTypeImpl>(ctx.fetchedTypes());
        ArrayList<DynamicTypeImpl> dynamicTypes = new ArrayList<DynamicTypeImpl>(ctx.dynamicTypes());
        ArrayList<EmbeddableTypeImpl> embeddableTypes = new ArrayList<EmbeddableTypeImpl>(ctx.embeddableTypes());
        ArrayList<StaticObjectTypeImpl> staticTypes = new ArrayList<StaticObjectTypeImpl>();
        for (StaticObjectTypeImpl staticObjectType : ctx.staticTypes()) {
            if (staticObjectType.unwrap() != null) continue;
            staticTypes.add(staticObjectType);
        }
        ArrayList<EnumTypeImpl> enumTypes = new ArrayList<EnumTypeImpl>(ctx.enumTypes());
        return new MetadataImpl(this.genericSupported, Collections.unmodifiableList(services), Collections.unmodifiableList(fetchedTypes), Collections.unmodifiableList(dynamicTypes), Collections.unmodifiableList(embeddableTypes), Collections.unmodifiableList(staticTypes), Collections.unmodifiableList(enumTypes));
    }

    /*
     * Exception decompiling
     */
    public static Schema loadSchema(Set<String> groups) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ServiceImpl service(ApiService apiService, TypeContext ctx) {
        ServiceImpl service = new ServiceImpl(ctx.javaType(apiService.getTypeName()));
        service.setDoc(apiService.getDoc());
        String baseUri = this.operationParser.uri(service.getJavaType());
        if (this.uriPrefix != null && !this.uriPrefix.isEmpty()) {
            baseUri = MetadataBuilder.concatUri(this.uriPrefix, baseUri);
        }
        LinkedHashMap<String, OperationImpl> endpointMap = new LinkedHashMap<String, OperationImpl>();
        IdentityHashMap<ApiOperation, OperationImpl> operationMap = new IdentityHashMap<ApiOperation, OperationImpl>((apiService.getOperations().size() * 4 + 2) / 3);
        for (Method method : service.getJavaType().getMethods()) {
            Class<?> lastParamType;
            boolean isSuspendFun = false;
            java.lang.reflect.Parameter[] parameters = method.getParameters();
            if (parameters.length > 0 && "kotlin.coroutines.Continuation".equals((lastParamType = parameters[parameters.length - 1].getType()).getName())) {
                isSuspendFun = true;
            }
            ApiOperation apiOperation = null;
            if (isSuspendFun) {
                java.lang.reflect.Parameter[] realParams = Arrays.copyOf(parameters, parameters.length - 1);
                apiOperation = apiService.findOperation(method.getName(), realParams);
            } else {
                apiOperation = apiService.findOperation(method.getName(), parameters);
            }
            if (apiOperation == null) continue;
            OperationImpl operation = this.operation(service, apiOperation, method, baseUri, ctx, isSuspendFun);
            operationMap.put(apiOperation, operation);
            for (Operation.HttpMethod httpMethod : operation.getHttpMethods()) {
                String endpoint = httpMethod.name() + ':' + operation.getUri();
                Operation conflictOperation = endpointMap.put(endpoint, operation);
                if (conflictOperation == null) continue;
                throw new IllegalApiException("Conflict endpoint \"" + endpoint + "\" which is shared by \"" + conflictOperation.getJavaMethod() + "\" and \"" + operation.getJavaMethod() + "\"");
            }
        }
        ArrayList<Operation> operations = new ArrayList<Operation>(apiService.getOperations().size());
        for (ApiOperation apiOperation : apiService.getOperations()) {
            Operation operation = (Operation)operationMap.get(apiOperation);
            if (operation == null) continue;
            operations.add(operation);
        }
        service.setOperations(Collections.unmodifiableList(operations));
        return service;
    }

    private OperationImpl operation(Service service, ApiOperation apiOperation, Method method, String baseUri, TypeContext ctx, boolean isSuspendFun) {
        OperationImpl operation = new OperationImpl(service, method);
        String uri = this.operationParser.uri(method);
        operation.setUri(MetadataBuilder.concatUri(baseUri, uri));
        operation.setDoc(apiOperation.getDoc());
        operation.setHttpMethods(this.operationParser.http(method));
        java.lang.reflect.Parameter[] javaParameters = method.getParameters();
        if (isSuspendFun && javaParameters.length > 0) {
            javaParameters = Arrays.copyOf(javaParameters, javaParameters.length - 1);
        }
        ArrayList<ParameterImpl> parameters = new ArrayList<ParameterImpl>();
        for (ApiParameter apiParameter : apiOperation.getParameters()) {
            if (this.ignoredParameterTypes.contains(javaParameters[apiParameter.getOriginalIndex()].getType()) || this.ignoredParameterTypeNames.contains(javaParameters[apiParameter.getOriginalIndex()].getType().getName())) continue;
            parameters.add(this.parameter(apiParameter, javaParameters[apiParameter.getOriginalIndex()], method, ctx));
        }
        boolean hasRequestBody = false;
        boolean hasRequestPart = false;
        for (Parameter parameter : parameters) {
            if (parameter.isRequestBody()) {
                if (hasRequestBody) {
                    throw new IllegalApiException("Illegal method \"" + method + "\", it can't have more than one request body parameter");
                }
                hasRequestBody = true;
            }
            if (!hasRequestBody || !(hasRequestPart |= parameter.getRequestPart() != null)) continue;
            throw new IllegalApiException("Illegal method \"" + method + "\", It can't have both request body and request part parameters");
        }
        operation.setParameters(Collections.unmodifiableList(parameters));
        if (apiOperation.getReturnType() != null) {
            if (this.illegalReturnTypes.contains(method.getReturnType()) || this.illegalReturnTypeNames.contains(method.getReturnType().getName())) {
                throw new IllegalApiException("Illegal method \"" + method + "\", The client API does not support the operation return type \"" + method.getReturnType().getName() + "\", please change the return type or add `@ApiIgnore` to the current operation");
            }
            if (isSuspendFun) {
                java.lang.reflect.Type[] genericTypes = method.getGenericParameterTypes();
                if (genericTypes.length > 0) {
                    java.lang.reflect.Type type = genericTypes[genericTypes.length - 1];
                    String typeName = type.getTypeName();
                    if (typeName.startsWith("kotlin.coroutines.Continuation<") && typeName.endsWith(">")) {
                        String realType = typeName.substring(typeName.indexOf(60) + 1, typeName.length() - 1);
                        operation.setReturnType(ctx.parseType(apiOperation.getReturnType()));
                    } else {
                        operation.setReturnType(ctx.parseType(apiOperation.getReturnType()));
                    }
                } else {
                    operation.setReturnType(ctx.parseType(apiOperation.getReturnType()));
                }
            } else {
                operation.setReturnType(ctx.parseType(apiOperation.getReturnType()));
            }
        }
        operation.setExceptionTypes(apiOperation.getExceptionTypes().stream().map(it -> (ObjectType)ctx.parseType((TypeRef)it)).collect(Collectors.toList()));
        return operation;
    }

    private ParameterImpl parameter(ApiParameter apiParameter, java.lang.reflect.Parameter javaParameter, Method method, TypeContext ctx) {
        ParameterImpl parameter = new ParameterImpl(apiParameter.getName());
        Type type = ctx.parseType(apiParameter.getType());
        Type nonNullType = NullableTypeImpl.unwrap(type);
        String requestParam = this.parameterParser.requestParam(javaParameter);
        String requestHeader = this.parameterParser.requestHeader(javaParameter);
        String pathVariable = this.parameterParser.pathVariable(javaParameter);
        boolean isRequestBody = this.parameterParser.isRequestBody(javaParameter);
        String requestPart = this.parameterParser.requestPart(javaParameter);
        if (requestPart != null) {
            requestParam = null;
        } else if (this.parameterParser.isRequestPartRequired(javaParameter)) {
            requestPart = requestParam;
            if (requestPart == null) {
                requestPart = "";
            }
            requestParam = null;
        }
        LinkedHashSet<String> parameterKinds = new LinkedHashSet<String>();
        if (requestHeader != null) {
            parameterKinds.add("request header");
        }
        if (requestParam != null) {
            parameterKinds.add("request parameter");
        }
        if (pathVariable != null) {
            parameterKinds.add("path variable");
        }
        if (requestPart != null) {
            parameterKinds.add("request part");
        }
        if (isRequestBody) {
            parameterKinds.add("request body");
        }
        if (parameterKinds.size() > 1) {
            throw new IllegalApiException("Illegal API method \"" + method + "\", its parameter \"" + apiParameter.getName() + "\" cannot be both " + parameterKinds);
        }
        if (requestHeader != null) {
            if (requestHeader.isEmpty()) {
                parameter.setRequestHeader(apiParameter.getName());
            } else {
                parameter.setRequestHeader(requestHeader);
            }
        } else if (requestParam != null) {
            if (requestParam.isEmpty()) {
                parameter.setRequestParam(apiParameter.getName());
            } else {
                parameter.setRequestParam(requestParam);
            }
        } else if (pathVariable != null) {
            if (pathVariable.isEmpty()) {
                parameter.setPathVariable(apiParameter.getName());
            } else {
                parameter.setPathVariable(pathVariable);
            }
        } else if (requestPart != null) {
            if (requestPart.isEmpty()) {
                parameter.setRequestPart(apiParameter.getName());
            } else {
                parameter.setRequestPart(requestPart);
            }
        } else if (isRequestBody) {
            parameter.setRequestBody(true);
        } else if (nonNullType instanceof SimpleType || nonNullType instanceof EnumType) {
            parameter.setRequestParam(parameter.getName());
        } else if (!apiParameter.getType().getTypeName().isGenerationRequired()) {
            throw new IllegalApiException("Illegal API method \"" + method + "\", its parameter \"" + apiParameter.getName() + "\" is not simple type, but its neither request param nor path variable nor request body");
        }
        if (pathVariable != null && apiParameter.getType().isNullable()) {
            throw new IllegalApiException("Illegal API method \"" + method + "\", its parameter \"" + apiParameter.getName() + "\" cannot be nullable type because it is path variable");
        }
        String defaultValue = this.parameterParser.defaultValue(javaParameter);
        parameter.setDefaultValue(defaultValue);
        if (requestHeader != null && !NullableTypeImpl.unwrap(type).equals(SimpleTypeImpl.of(TypeName.STRING))) {
            throw new IllegalApiException("Illegal API method \"" + method + "\", its parameter \"" + apiParameter.getName() + "\" is http header parameter but its type is not string");
        }
        Boolean optional = this.parameterParser.isOptional(javaParameter);
        if (Boolean.TRUE.equals(optional)) {
            type = NullableTypeImpl.of(type);
        } else if (Boolean.FALSE.equals(optional)) {
            type = NullableTypeImpl.unwrap(type);
        } else if (optional == null && apiParameter.getType().isNullable() && defaultValue == null) {
            throw new IllegalApiException("Illegal API method \"" + method + "\", its parameter \"" + apiParameter.getName() + "\" is considered as nullable by jimmer but the web framework thinks it's neither optional nor has a default value, please use web parameter annotation (such as @RequestParam) explicitly");
        }
        parameter.setType(type);
        return parameter;
    }

    private static String concatUri(String baseUri, String uri) {
        if (baseUri == null) {
            baseUri = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (baseUri.isEmpty()) {
            return uri.startsWith("/") ? uri : '/' + uri;
        }
        if (uri.isEmpty()) {
            return baseUri.startsWith("/") ? baseUri : '/' + baseUri;
        }
        if (baseUri.endsWith("/") && uri.startsWith("/")) {
            return baseUri + uri.substring(1);
        }
        if (!baseUri.endsWith("/") && !uri.startsWith("/")) {
            return baseUri + '/' + uri;
        }
        return baseUri + uri;
    }
}

