/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.client.generator.Namespace;
import org.babyfish.jimmer.client.generator.ts.ApiErrorsRender;
import org.babyfish.jimmer.client.generator.ts.ApiRender;
import org.babyfish.jimmer.client.generator.ts.DtoWrapperRender;
import org.babyfish.jimmer.client.generator.ts.DynamicTypeRender;
import org.babyfish.jimmer.client.generator.ts.EmbeddableTypeRender;
import org.babyfish.jimmer.client.generator.ts.EnumTypeRender;
import org.babyfish.jimmer.client.generator.ts.FetchedTypeRender;
import org.babyfish.jimmer.client.generator.ts.OperationRender;
import org.babyfish.jimmer.client.generator.ts.ServiceRender;
import org.babyfish.jimmer.client.generator.ts.StaticTypeRender;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.generator.ts.fixed.ElementOfRender;
import org.babyfish.jimmer.client.generator.ts.fixed.ExecutorRender;
import org.babyfish.jimmer.client.generator.ts.fixed.RequestOfRender;
import org.babyfish.jimmer.client.generator.ts.fixed.ResponseOfRender;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.client.source.SourceManager;

public class TypeScriptSourceManager
extends SourceManager {
    public static final String ENUM_DIR = "model/enums";
    private final Namespace namespace = new Namespace();
    private final Map<Class<?>, Source> dtoWrapperSourceMap = new LinkedHashMap();

    protected TypeScriptSourceManager(TypeScriptContext ctx) {
        super(ctx);
    }

    @Override
    protected Source createServiceSource(Service service) {
        String name = this.namespace.allocate(service.getJavaType().getSimpleName());
        return this.createRootSource("services", name, () -> new ServiceRender(name, service));
    }

    @Override
    protected Source createOperationSource(Operation operation) {
        Source source = this.getSource(operation.getDeclaringService());
        String name = this.namespace.subNamespace(source.getName()).allocate(operation.getName());
        return source.subSource(name, () -> new OperationRender(name, operation));
    }

    @Override
    protected Source createStaticTypeSource(ObjectType objectType) {
        String name = this.namespace.allocate(String.join((CharSequence)"_", objectType.getSimpleNames()));
        return this.createRootSource("model/static", name, () -> new StaticTypeRender(name, objectType));
    }

    @Override
    protected Source createFetchedTypeSource(ObjectType objectType) {
        Source dtoWrapperSource = this.dtoWrapperSourceMap.get(objectType.getJavaType());
        if (dtoWrapperSource == null) {
            String name = this.namespace.allocate(String.join((CharSequence)"_", objectType.getSimpleNames()) + "Dto");
            dtoWrapperSource = this.createRootSource("model/dto", name, () -> new DtoWrapperRender(name));
            this.dtoWrapperSourceMap.put(objectType.getJavaType(), dtoWrapperSource);
        }
        FetchByInfo info = objectType.getFetchByInfo();
        assert (info != null);
        String subName = info.getOwnerType().getSimpleName() + '/' + info.getConstant();
        Map<Type, String> recursiveTypeNames = ((DtoWrapperRender)dtoWrapperSource.getRender()).recursiveTypeNames;
        String dtoName = dtoWrapperSource.getName();
        return dtoWrapperSource.subSource(subName, () -> new FetchedTypeRender(dtoName, subName, objectType, recursiveTypeNames));
    }

    @Override
    protected Source createDynamicTypeSource(ObjectType objectType) {
        String name = this.namespace.allocate("Dynamic_" + String.join((CharSequence)"_", objectType.getSimpleNames()));
        return this.createRootSource("model/dynamic", name, () -> new DynamicTypeRender(name, objectType));
    }

    @Override
    protected Source createEmbeddableTypeSource(ObjectType objectType) {
        String name = this.namespace.allocate(String.join((CharSequence)"_", objectType.getSimpleNames()));
        return this.createRootSource("model/embeddable", name, () -> new EmbeddableTypeRender(name, objectType));
    }

    @Override
    protected Source createEnumTypeSource(EnumType enumType) {
        String name = this.namespace.allocate(String.join((CharSequence)"_", enumType.getJavaType().getSimpleName()));
        TypeScriptContext ctx = (TypeScriptContext)this.getContext();
        return this.createRootSource(ENUM_DIR, name, () -> new EnumTypeRender(name, enumType, ctx.isEnumTsStyle()));
    }

    @Override
    public void createAdditionalSources() {
        TypeScriptContext ctx = (TypeScriptContext)this.getContext();
        this.createRootSource("", "Executor", ExecutorRender::new);
        this.createRootSource("", "ElementOf", ElementOfRender::new);
        this.createRootSource("", "RequestOf", RequestOfRender::new);
        this.createRootSource("", "ResponseOf", ResponseOfRender::new);
        this.createRootSource("", ctx.getApiName(), () -> new ApiRender(ctx.getApiName(), ctx.getMetadata().getServices()));
        this.createRootSource("", ctx.getApiName() + "Errors", () -> new ApiErrorsRender(ctx.getApiName() + "Errors", ctx.getMetadata().getServices()));
    }
}

