/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.lang.reflect.Field;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;
import org.babyfish.jimmer.internal.FixedInputField;

public class StaticTypeRender
implements Render {
    private final String name;
    private final ObjectType type;

    public StaticTypeRender(String name, ObjectType type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export type {")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
    }

    @Override
    public void render(SourceWriter writer) {
        Doc doc = this.type.getDoc();
        ((SourceWriter)writer.doc(doc, new SourceWriter.DocPart[0]).code("export interface ")).code(this.name);
        if (!this.type.getArguments().isEmpty()) {
            writer.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                for (Type argument : this.type.getArguments()) {
                    writer.separator();
                    writer.typeRef(argument);
                }
            });
        }
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        ((SourceWriter)writer.code(' ')).scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Property property : this.type.getProperties().values()) {
                boolean isFixedInput = false;
                try {
                    Field field = this.type.getJavaType().getDeclaredField(property.getName());
                    isFixedInput = field.getAnnotation(FixedInputField.class) != null;
                }
                catch (NoSuchFieldException field) {
                    // empty catch block
                }
                if (property.getDoc() != null) {
                    writer.doc(property.getDoc(), new SourceWriter.DocPart[0]);
                } else if (doc != null) {
                    writer.doc((String)doc.getPropertyValueMap().get(property.getName()));
                }
                ((SourceWriter)writer.codeIf(!ctx.isMutable(), "readonly ")).code(property.getName());
                boolean isNullable = property.getType() instanceof NullableType;
                if (isNullable && isFixedInput) {
                    ((SourceWriter)writer.code(": ")).typeRef(NullableTypeImpl.unwrap(property.getType())).code(" | null;\n");
                    continue;
                }
                ((SourceWriter)((SourceWriter)writer.codeIf(isNullable, '?')).code(": ")).typeRef(property.getType()).code(";\n");
            }
        });
        writer.code('\n');
    }
}

