/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.ts;

import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Render;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.generator.ts.TypeScriptContext;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.impl.util.StringUtil;

public class ApiRender
implements Render {
    private final String name;
    private final List<Service> services;

    public ApiRender(String name, List<Service> services) {
        this.name = name;
        this.services = services;
    }

    @Override
    public void export(SourceWriter writer) {
        ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("export {")).code(this.name)).code("} from './")).code(this.name)).code("';\n");
    }

    @Override
    public void render(SourceWriter writer) {
        TypeScriptContext ctx = (TypeScriptContext)writer.getContext();
        List serviceSources = this.services.stream().map(ctx::getSource).collect(Collectors.toList());
        Source executorSource = ctx.getRootSource("Executor");
        writer.importSource(executorSource);
        for (Source source : serviceSources) {
            writer.importSource(source, true);
        }
        ((SourceWriter)((SourceWriter)writer.code("export class ")).code(this.name)).code(' ');
        writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
            for (Source source : serviceSources) {
                ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("\nreadonly ")).code(StringUtil.identifier((String[])new String[]{source.getName()}))).code(": ")).code(source.getName())).code('\n');
            }
            ((SourceWriter)((SourceWriter)writer.code("\nconstructor(executor: ")).code(executorSource.getName())).code(") ");
            writer.scope(CodeWriter.ScopeType.OBJECT, "", true, () -> {
                for (Source source : serviceSources) {
                    ((SourceWriter)((SourceWriter)((SourceWriter)((SourceWriter)writer.code("this.")).code(StringUtil.identifier((String[])new String[]{source.getName()}))).code(" = new ")).code(source.getName())).code("(executor);\n");
                }
            });
        });
    }
}

