/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.openapi;

import java.io.Writer;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.openapi.Description;

public class YmlWriter
extends CodeWriter<YmlWriter> {
    private static final boolean[] SPECIAL_CHAR_FLAGS;

    public YmlWriter(Writer writer) {
        super("  ");
        this.setWriter(writer);
    }

    public YmlWriter object(String name, Runnable block) {
        ((YmlWriter)this.code(name)).code(':');
        return (YmlWriter)this.scope(CodeWriter.ScopeType.BLANK, "", true, block);
    }

    public YmlWriter list(String name, Runnable block) {
        ((YmlWriter)this.code(name)).code(':');
        this.scope(CodeWriter.ScopeType.BLANK, "", true, block);
        return this;
    }

    public YmlWriter listItem(Runnable block) {
        this.code("- ");
        this.scope(CodeWriter.ScopeType.BLANK, "", false, block);
        return this;
    }

    public YmlWriter prop(String name, String value) {
        if (value != null && !value.isEmpty()) {
            ((YmlWriter)((YmlWriter)((YmlWriter)this.code(name)).code(": ")).code(YmlWriter.text(value))).code('\n');
        }
        return this;
    }

    public YmlWriter description(Description description) {
        if (description.getSummary() != null) {
            this.prop("summary", description.getSummary());
        }
        if (!description.getDescriptionLines().isEmpty()) {
            this.code("description: ");
            if (description.getDescriptionLines().size() == 1) {
                ((YmlWriter)this.code(YmlWriter.text(description.getDescriptionLines().get(0)))).code('\n');
            } else {
                this.code("|+");
                this.scope(CodeWriter.ScopeType.BLANK, "", true, () -> {
                    for (String line : description.getDescriptionLines()) {
                        ((YmlWriter)this.code(line)).code('\n');
                    }
                });
            }
        }
        return this;
    }

    private static String text(String line) {
        boolean complex;
        boolean bl = complex = line.charAt(0) == '\'';
        if (!complex) {
            for (int i = line.length() - 1; i >= 0; --i) {
                char c = line.charAt(i);
                if (c >= SPECIAL_CHAR_FLAGS.length || !SPECIAL_CHAR_FLAGS[c]) continue;
                complex = true;
                break;
            }
        }
        if (!complex) {
            return line;
        }
        return '\'' + line.replace("\\", "\\\\").replace("\n", "\\n").replace("'", "''") + '\'';
    }

    static {
        boolean[] arr = new boolean[128];
        String specialChars = ":{}[],&*#?|-<>=!%@`";
        for (int i = specialChars.length() - 1; i >= 0; --i) {
            arr[specialChars.charAt((int)i)] = true;
        }
        SPECIAL_CHAR_FLAGS = arr;
    }
}

