/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.openapi;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.babyfish.jimmer.client.generator.GeneratorException;
import org.babyfish.jimmer.client.generator.Namespace;
import org.babyfish.jimmer.client.generator.openapi.Description;
import org.babyfish.jimmer.client.generator.openapi.OpenApiProperties;
import org.babyfish.jimmer.client.generator.openapi.YmlWriter;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.FetchByInfo;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.MapType;
import org.babyfish.jimmer.client.runtime.Metadata;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Parameter;
import org.babyfish.jimmer.client.runtime.Property;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.runtime.SimpleType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeVariable;
import org.babyfish.jimmer.client.runtime.VirtualType;
import org.babyfish.jimmer.client.runtime.impl.NullableTypeImpl;

public class OpenApiGenerator {
    private final Metadata metadata;
    private final OpenApiProperties properties;
    private final ServiceNameManager serviceNameManager = new ServiceNameManager();
    private final OperationNameManager operationNameManager = new OperationNameManager();
    private final TypeNameManager typeNameManager;
    private final ObjectTypeRenderSet usedObjectTypes = new ObjectTypeRenderSet();

    public OpenApiGenerator(Metadata metadata, OpenApiProperties properties) {
        if (metadata.isGenericSupported()) {
            throw new IllegalArgumentException("OpenApiGenerator does not support generic");
        }
        this.metadata = metadata;
        this.properties = properties != null ? properties : OpenApiProperties.newBuilder().build();
        this.typeNameManager = new TypeNameManager(metadata);
    }

    public void generate(Writer writer) {
        YmlWriter ymlWriter = new YmlWriter(writer);
        ymlWriter.prop("openapi", "3.0.1");
        this.generateInfo(ymlWriter);
        this.generateSecurity(ymlWriter);
        this.generateServers(ymlWriter);
        this.generateTags(ymlWriter);
        this.generatePaths(ymlWriter);
        this.generateComponents(ymlWriter);
        try {
            writer.flush();
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot flush the writer");
        }
    }

    private void generateInfo(YmlWriter writer) {
        writer.object("info", () -> {
            OpenApiProperties.Info info = this.properties.getInfo();
            if (info == null) {
                info = OpenApiProperties.newInfoBuilder().setTitle("<No title>").setDescription("<No Description>").setVersion("1.0.0").build();
            }
            info.writeTo(writer);
        });
    }

    private void generateSecurity(YmlWriter writer) {
        if (!this.properties.getSecurities().isEmpty()) {
            writer.list("security", () -> {
                for (Map<String, List<String>> map : this.properties.getSecurities()) {
                    writer.listItem(() -> {
                        for (Map.Entry e : map.entrySet()) {
                            if (((List)e.getValue()).isEmpty()) {
                                ((YmlWriter)writer.code((String)e.getKey())).code(": []\n");
                                continue;
                            }
                            writer.list((String)e.getKey(), () -> {
                                for (String value : (List)e.getValue()) {
                                    if (value == null) continue;
                                    writer.listItem(() -> ((YmlWriter)writer.code(value)).code('\n'));
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void generateServers(YmlWriter writer) {
        if (!this.properties.getServers().isEmpty()) {
            writer.list("servers", () -> {
                for (OpenApiProperties.Server server : this.properties.getServers()) {
                    writer.listItem(() -> server.writeTo(writer));
                }
            });
        }
    }

    private void generateTags(YmlWriter writer) {
        List services = this.metadata.getServices().stream().filter(it -> it.getDoc() != null && it.getDoc().getValue() != null).collect(Collectors.toList());
        if (services.isEmpty()) {
            return;
        }
        writer.list("tags", () -> {
            for (Service service : services) {
                writer.listItem(() -> {
                    writer.prop("name", service.getJavaType().getSimpleName());
                    writer.description(Description.of(Doc.valueOf((Doc)service.getDoc()), false));
                });
            }
        });
    }

    private void generatePaths(YmlWriter writer) {
        if (this.metadata.getPathMap().isEmpty()) {
            return;
        }
        writer.object("paths", () -> {
            for (Map.Entry<String, List<Operation>> e : this.metadata.getPathMap().entrySet()) {
                writer.object(e.getKey(), () -> {
                    for (Operation operation : (List)e.getValue()) {
                        for (Operation.HttpMethod method : operation.getHttpMethods()) {
                            writer.object(method.name().toLowerCase(), () -> this.generateOperation(operation, writer));
                        }
                    }
                });
            }
        });
    }

    private void generateOperation(Operation operation, YmlWriter writer) {
        writer.description(Description.of(Doc.valueOf((Doc)operation.getDoc()), true));
        writer.list("tags", () -> writer.listItem(() -> writer.code(this.serviceNameManager.get(operation.getDeclaringService()))));
        writer.prop("operationId", this.operationNameManager.get(operation));
        List httpParameters = operation.getParameters().stream().filter(it -> !it.isRequestBody() && it.getRequestPart() == null).collect(Collectors.toList());
        Parameter requestBodyParameter = operation.getParameters().stream().filter(Parameter::isRequestBody).findFirst().orElse(null);
        List requestPartParameters = operation.getParameters().stream().filter(p -> p.getRequestPart() != null).collect(Collectors.toList());
        if (!httpParameters.isEmpty()) {
            writer.list("parameters", () -> {
                for (Parameter parameter : httpParameters) {
                    String name;
                    String requestHeader = parameter.getRequestHeader();
                    String requestParam = parameter.getRequestParam();
                    String string = requestHeader != null ? requestHeader : (name = requestParam != null ? requestParam : parameter.getPathVariable());
                    if (name != null) {
                        writer.listItem(() -> {
                            writer.prop("name", name);
                            writer.prop("in", requestHeader != null ? "header" : (requestParam != null ? "query" : "path"));
                            if (!(parameter.getType() instanceof NullableType)) {
                                writer.prop("required", "true");
                            }
                            writer.description(Description.of(Doc.paramOf((Doc)operation.getDoc(), (String)parameter.getName())));
                            writer.object("schema", () -> {
                                this.generateType(parameter.getType(), writer);
                                writer.prop("default", parameter.getDefaultValue());
                            });
                        });
                        continue;
                    }
                    boolean isNullObject = parameter.getType() instanceof NullableType;
                    for (Property property : ((ObjectType)NullableTypeImpl.unwrap(parameter.getType())).getProperties().values()) {
                        writer.listItem(() -> {
                            String doc;
                            writer.prop("name", property.getName());
                            writer.prop("in", "query");
                            if (!isNullObject && !(property.getType() instanceof NullableType)) {
                                writer.prop("required", "true");
                            }
                            if ((doc = Doc.valueOf((Doc)property.getDoc())) == null) {
                                doc = Doc.propertyOf((Doc)((ObjectType)NullableTypeImpl.unwrap(parameter.getType())).getDoc(), (String)property.getName());
                            }
                            writer.description(Description.of(doc));
                            writer.object("schema", () -> this.generateType(property.getType(), writer));
                        });
                    }
                }
            });
        }
        if (requestBodyParameter != null) {
            writer.object("requestBody", () -> {
                writer.object("content", () -> writer.object("application/json", () -> writer.object("schema", () -> this.generateType(requestBodyParameter.getType(), writer))));
                if (!(requestBodyParameter.getType() instanceof NullableType)) {
                    writer.prop("required", "true");
                }
                writer.description(Description.of(Doc.paramOf((Doc)operation.getDoc(), (String)requestBodyParameter.getName())));
            });
        }
        if (!requestPartParameters.isEmpty()) {
            List encodingParameters = requestPartParameters.stream().filter(p -> {
                ListType listType;
                Type type = NullableTypeImpl.unwrap(p.getType());
                if (type instanceof VirtualType) {
                    return false;
                }
                return !(type instanceof ListType) || !(NullableTypeImpl.unwrap((listType = (ListType)type).getElementType()) instanceof VirtualType);
            }).collect(Collectors.toList());
            writer.object("requestBody", () -> writer.object("content", () -> writer.object("multipart/form-data", () -> {
                writer.object("schema", () -> {
                    writer.prop("type", "object");
                    writer.object("properties", () -> {
                        for (Parameter parameter : requestPartParameters) {
                            writer.object(parameter.getName(), () -> this.generateType(parameter.getType(), writer));
                        }
                    });
                });
                if (!encodingParameters.isEmpty()) {
                    writer.object("encoding", () -> {
                        for (Parameter parameter : encodingParameters) {
                            writer.object(parameter.getName(), () -> writer.prop("contentType", "application/json"));
                        }
                    });
                }
            })));
        }
        this.generateResponses(operation, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateType(Type type, YmlWriter writer) {
        if (type instanceof ObjectType) {
            this.usedObjectTypes.add((ObjectType)type);
            writer.prop("$ref", "#/components/schemas/" + this.typeNameManager.get((ObjectType)type));
            return;
        } else if (type instanceof ListType) {
            writer.prop("type", "array").object("items", () -> this.generateType(((ListType)type).getElementType(), writer));
            return;
        } else if (type instanceof MapType) {
            writer.prop("type", "object").object("additionalProperties", () -> this.generateType(((MapType)type).getValueType(), writer));
            return;
        } else if (type instanceof NullableType) {
            this.generateType(((NullableType)type).getTargetType(), writer);
            return;
        } else if (type instanceof EnumType) {
            writer.prop("type", "string");
            writer.list("enum", () -> {
                for (EnumType.Constant constant : ((EnumType)type).getConstants()) {
                    writer.listItem(() -> ((YmlWriter)writer.code(constant.getName())).code('\n'));
                }
            });
            return;
        } else if (type instanceof VirtualType) {
            if (!(type instanceof VirtualType.File)) throw new AssertionError((Object)"Internal bug: more virtual type need to be processed");
            writer.prop("type", "string");
            writer.prop("format", "binary");
            return;
        } else {
            SimpleType simpleType = (SimpleType)type;
            Class<?> javaType = simpleType.getJavaType();
            if (Boolean.TYPE == javaType) {
                writer.prop("type", "boolean");
                return;
            } else if (Character.TYPE == javaType) {
                writer.prop("type", "string");
                return;
            } else if (Byte.TYPE == javaType) {
                writer.prop("type", "integer");
                return;
            } else if (Short.TYPE == javaType) {
                writer.prop("type", "integer");
                return;
            } else if (Integer.TYPE == javaType) {
                writer.prop("type", "integer");
                writer.prop("format", "int32");
                return;
            } else if (Long.TYPE == javaType) {
                writer.prop("type", "integer");
                writer.prop("format", "int64");
                return;
            } else if (Float.TYPE == javaType) {
                writer.prop("type", "number");
                writer.prop("format", "float");
                return;
            } else if (Double.TYPE == javaType) {
                writer.prop("type", "number");
                writer.prop("format", "double");
                return;
            } else if (BigDecimal.class == javaType) {
                writer.prop("type", "number");
                return;
            } else if (BigInteger.class == javaType) {
                writer.prop("type", "number");
                return;
            } else if (Object.class == javaType) {
                writer.prop("type", "object");
                return;
            } else {
                writer.prop("type", "string");
            }
        }
    }

    private void generateResponses(Operation operation, YmlWriter writer) {
        TreeMap<Integer, List> exceptionTypeMap = new TreeMap<Integer, List>();
        for (ObjectType exceptionType : operation.getExceptionTypes()) {
            exceptionTypeMap.computeIfAbsent(this.errorHttpStatus(), it -> new ArrayList()).add(exceptionType);
        }
        writer.object("responses", () -> {
            writer.object("200", () -> {
                String returnDoc = operation.getDoc() != null ? operation.getDoc().getReturnValue() : null;
                writer.description(Description.of(returnDoc != null ? returnDoc : "OK"));
                if (operation.getReturnType() != null) {
                    writer.object("content", () -> writer.object("application/json", () -> writer.object("schema", () -> this.generateType(operation.getReturnType(), writer))));
                }
            });
            for (Map.Entry e : exceptionTypeMap.entrySet()) {
                writer.object(((Integer)e.getKey()).toString(), () -> {
                    List exceptionTypes = (List)e.getValue();
                    writer.prop("description", "ERROR");
                    writer.object("content", () -> writer.object("application/json", () -> writer.object("schema", () -> {
                        if (exceptionTypes.size() == 1) {
                            this.generateType((Type)exceptionTypes.get(0), writer);
                        } else {
                            writer.list("oneOf", () -> {
                                for (ObjectType exceptionType : exceptionTypes) {
                                    writer.listItem(() -> this.generateType(exceptionType, writer));
                                }
                            });
                        }
                    })));
                });
            }
        });
    }

    private void generateComponents(YmlWriter writer) {
        if (this.usedObjectTypes.isCommitted()) {
            return;
        }
        writer.object("components", () -> {
            writer.object("schemas", () -> {
                Collection<ObjectType> objectTypes;
                while (!(objectTypes = this.usedObjectTypes.commit()).isEmpty()) {
                    for (ObjectType objectType : objectTypes) {
                        this.generateTypeDefinition(objectType, writer);
                    }
                }
            });
            this.generateSecuritySchemes(writer);
        });
    }

    private void generateTypeDefinition(ObjectType type, YmlWriter writer) {
        writer.object(this.typeNameManager.get(type), () -> {
            writer.prop("type", "object");
            writer.description(Description.of(Doc.valueOf((Doc)type.getDoc())));
            writer.object("properties", () -> {
                if (type.getError() != null) {
                    writer.object("family", () -> {
                        writer.prop("type", "string");
                        ((YmlWriter)((YmlWriter)writer.code("enum: [")).code(type.getError().getFamily())).code("]\n");
                    });
                    writer.object("code", () -> {
                        writer.prop("type", "string");
                        ((YmlWriter)((YmlWriter)writer.code("enum: [")).code(type.getError().getCode())).code("]\n");
                    });
                }
                for (Property property : type.getProperties().values()) {
                    writer.object(property.getName(), () -> {
                        String doc = Doc.valueOf((Doc)property.getDoc());
                        if (doc == null) {
                            doc = Doc.propertyOf((Doc)type.getDoc(), (String)property.getName());
                        }
                        writer.description(Description.of(doc));
                        if (property.getType() instanceof NullableType) {
                            writer.prop("nullable", "true");
                        }
                        this.generateType(property.getType(), writer);
                    });
                }
            });
        });
    }

    private void generateSecuritySchemes(YmlWriter writer) {
        if (this.properties.getComponents() == null) {
            return;
        }
        Map<String, OpenApiProperties.SecurityScheme> securitySchemes = this.properties.getComponents().getSecuritySchemes();
        if (!securitySchemes.isEmpty()) {
            writer.object("securitySchemes", () -> {
                for (Map.Entry e : securitySchemes.entrySet()) {
                    writer.object((String)e.getKey(), () -> ((OpenApiProperties.SecurityScheme)e.getValue()).writeTo(writer));
                }
            });
        }
    }

    protected int errorHttpStatus() {
        return 500;
    }

    private static class TypeNameManager {
        private final Map<Type, String> typeNameMap = new LinkedHashMap<Type, String>();
        private final Namespace namespace = new Namespace();

        public TypeNameManager(Metadata metadata) {
            for (ObjectType fetchedType : metadata.getFetchedTypes()) {
                this.get(fetchedType);
            }
            for (ObjectType dynamicType : metadata.getDynamicTypes()) {
                this.get(dynamicType);
            }
            for (ObjectType staticType : metadata.getStaticTypes()) {
                this.get(staticType);
            }
            for (ObjectType embeddableType : metadata.getEmbeddableTypes()) {
                this.get(embeddableType);
            }
        }

        public String get(ObjectType type) {
            String typeName = this.typeNameMap.get(type);
            if (typeName == null) {
                String rawTypeName;
                try {
                    rawTypeName = this.getImpl(type);
                }
                catch (RuntimeException ex) {
                    throw new IllegalArgumentException("Cannot resolve the type \"" + type + "\"", ex);
                }
                typeName = this.namespace.allocate(rawTypeName);
                this.typeNameMap.put(type, typeName);
            }
            return typeName;
        }

        private String getImpl(Type type) {
            if (type instanceof ObjectType) {
                ObjectType objectType = (ObjectType)type;
                StringBuilder builder = new StringBuilder();
                if (objectType.getKind() == ObjectType.Kind.DYNAMIC) {
                    builder.append("Dynamic_");
                }
                builder.append(String.join((CharSequence)"_", objectType.getSimpleNames()));
                FetchByInfo info = null;
                if (objectType.getKind() == ObjectType.Kind.FETCHED) {
                    info = objectType.getFetchByInfo();
                }
                if (info != null) {
                    builder.append('_').append(info.getOwnerType().getSimpleName()).append('_').append(info.getConstant());
                }
                for (Type argument : objectType.getArguments()) {
                    builder.append('_').append(this.getImpl(argument));
                }
                String name = builder.toString();
                if (info != null) {
                    this.collectMoreFetchedTypeNames(objectType, name);
                }
                return name;
            }
            if (type instanceof NullableType) {
                return this.getImpl(((NullableType)type).getTargetType());
            }
            if (type instanceof ListType) {
                return "List_" + this.getImpl(((ListType)type).getElementType());
            }
            if (type instanceof MapType) {
                return "Map_" + this.getImpl(((MapType)type).getValueType());
            }
            if (type instanceof EnumType) {
                return String.join((CharSequence)"_", ((EnumType)type).getSimpleNames());
            }
            if (type instanceof TypeVariable) {
                throw new IllegalArgumentException("Illegal type variable: " + type);
            }
            return ((SimpleType)type).getJavaType().getSimpleName();
        }

        private void collectMoreFetchedTypeNames(ObjectType objectType, String prefix) {
            for (Property property : objectType.getProperties().values()) {
                ObjectType targetType;
                Type type = property.getType();
                if (type instanceof NullableType) {
                    type = ((NullableType)type).getTargetType();
                }
                if (type instanceof ListType) {
                    type = ((ListType)type).getElementType();
                }
                if (!(type instanceof ObjectType) || (targetType = (ObjectType)type).getKind() != ObjectType.Kind.FETCHED || this.typeNameMap.containsKey(targetType)) continue;
                String name = prefix;
                if (!targetType.isRecursiveFetchedType() || objectType.hasMultipleRecursiveProps()) {
                    name = name + '_' + property.getName();
                }
                this.typeNameMap.put(targetType, name);
                this.collectMoreFetchedTypeNames(targetType, name);
            }
        }

        public Set<ObjectType> cloneObjectTypes() {
            LinkedHashSet<ObjectType> set = new LinkedHashSet<ObjectType>();
            for (Type type : this.typeNameMap.keySet()) {
                if (!(type instanceof ObjectType)) continue;
                set.add((ObjectType)type);
            }
            return set;
        }
    }

    private static class ServiceNameManager {
        private final Map<Service, String> nameMap = new LinkedHashMap<Service, String>();
        private final Namespace namespace = new Namespace();

        private ServiceNameManager() {
        }

        public String get(Service service) {
            return this.nameMap.computeIfAbsent(service, it -> this.namespace.allocate(it.getJavaType().getSimpleName()));
        }
    }

    private static class OperationNameManager {
        private final Map<Operation, String> nameMap = new LinkedHashMap<Operation, String>();
        private final Namespace namespace = new Namespace();

        private OperationNameManager() {
        }

        public String get(Operation operation) {
            return this.nameMap.computeIfAbsent(operation, it -> this.namespace.allocate(it.getName()));
        }
    }

    private class ObjectTypeRenderSet {
        private final Map<String, ObjectType> committed = new HashMap<String, ObjectType>();
        private Map<String, ObjectType> uncommitted = new LinkedHashMap<String, ObjectType>();

        private ObjectTypeRenderSet() {
        }

        public void add(ObjectType type) {
            String name = OpenApiGenerator.this.typeNameManager.get(type);
            if (!this.committed.containsKey(name)) {
                this.uncommitted.put(name, type);
            }
        }

        public boolean isCommitted() {
            return this.uncommitted.isEmpty();
        }

        public Collection<ObjectType> commit() {
            if (this.uncommitted.isEmpty()) {
                return Collections.emptySet();
            }
            Map<String, ObjectType> delta = this.uncommitted;
            this.committed.putAll(delta);
            this.uncommitted = new LinkedHashMap<String, ObjectType>();
            return delta.values();
        }
    }
}

