/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.babyfish.jimmer.client.generator.CodeWriter;
import org.babyfish.jimmer.client.generator.Context;
import org.babyfish.jimmer.client.generator.SourceWriter;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.ListType;
import org.babyfish.jimmer.client.runtime.MapType;
import org.babyfish.jimmer.client.runtime.NamedType;
import org.babyfish.jimmer.client.runtime.NullableType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.SimpleType;
import org.babyfish.jimmer.client.runtime.Type;
import org.babyfish.jimmer.client.runtime.TypeVariable;
import org.babyfish.jimmer.client.runtime.VirtualType;
import org.babyfish.jimmer.client.runtime.impl.IllegalApiException;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.impl.util.Classes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaWriter
extends SourceWriter {
    private static final Set<Class<?>> ADDITIONAL_TYPES = new HashSet<Class>(Arrays.asList(Nullable.class, NotNull.class, List.class, Map.class));
    private final Map<Type, String> typeNameMap = new LinkedHashMap<Type, String>();
    private final Map<Class<?>, String> classNameMap = new LinkedHashMap();
    private final Map<String, String> importMap = new LinkedHashMap<String, String>();

    public JavaWriter(Context ctx, Source source) {
        super(ctx, source);
    }

    public SourceWriter typeRef(Class<?> type) {
        String name = this.classNameMap.get(type);
        if (name != null) {
            this.code(name);
            return this;
        }
        if (!ADDITIONAL_TYPES.contains(type)) {
            throw new IllegalApiException("\"" + type + "\" is not additional type of java writer");
        }
        if (this.importMap.containsKey(type.getSimpleName())) {
            this.classNameMap.put(type, type.getName());
            this.code(type.getName());
        } else {
            this.importMap.put(type.getSimpleName(), type.getName());
            this.classNameMap.put(type, type.getSimpleName());
            this.code(type.getSimpleName());
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SourceWriter typeRef(Type type) {
        if (type instanceof TypeVariable) {
            this.code(((TypeVariable)type).getName());
            return this;
        } else if (type instanceof NullableType) {
            Class<?> targetJavaType;
            Type targetType = ((NullableType)type).getTargetType();
            if (targetType instanceof SimpleType && (targetJavaType = ((SimpleType)targetType).getJavaType()).isPrimitive()) {
                this.code(Classes.boxTypeOf(targetJavaType).getSimpleName());
                return this;
            }
            this.typeRef(targetType);
            return this;
        } else if (type instanceof ListType) {
            ((SourceWriter)this.typeRef(List.class).code('<')).typeRef(((ListType)type).getElementType()).code('>');
            return this;
        } else if (type instanceof MapType) {
            ((SourceWriter)this.typeRef(Map.class).code("<String, ")).typeRef(((MapType)type).getValueType()).code('>');
            return this;
        } else if (type instanceof EnumType) {
            this.code(this.typeName((EnumType)type));
            return this;
        } else if (type instanceof VirtualType) {
            if (!(type instanceof VirtualType.File)) throw new AssertionError((Object)"Internal bug: more virtual type need to be processed");
            this.code("java.io.InputStream");
            return this;
        } else if (type instanceof SimpleType) {
            Class<?> javaType = ((SimpleType)type).getJavaType();
            if (javaType.getPackage() != null && javaType.getPackage().getName().equals("java.lang") && javaType.getDeclaringClass() == null) {
                this.code(javaType.getSimpleName());
                return this;
            } else {
                this.code(javaType.getName());
            }
            return this;
        } else {
            List<Type> arguments;
            if (!(type instanceof ObjectType)) return this;
            ObjectType objectType = (ObjectType)type;
            this.code(this.typeName(objectType));
            if (objectType.getKind() != ObjectType.Kind.STATIC || (arguments = ((ObjectType)type).getArguments()).isEmpty()) return this;
            this.scope(CodeWriter.ScopeType.GENERIC, ", ", false, () -> {
                for (Type argument : arguments) {
                    this.separator();
                    this.typeRef(argument);
                }
            });
        }
        return this;
    }

    @Override
    public void importSource(Source source, String name, boolean treatAsValue) {
    }

    @Override
    protected void onFlushImportedTypes() {
        String sp = "package ";
        for (String dir : this.source.getDirs()) {
            ((SourceWriter)this.code(sp)).code(dir);
            sp = ".";
        }
        this.code(";\n");
        if (!this.importMap.isEmpty()) {
            this.code('\n');
            for (String path : new TreeSet<String>(this.importMap.values())) {
                ((SourceWriter)((SourceWriter)this.code("import ")).code(path)).code(";\n");
            }
        }
    }

    private String typeName(NamedType type) {
        String typeName = this.typeNameMap.get(type);
        if (typeName != null) {
            return typeName;
        }
        Source source = this.getSource(type);
        String shortName = source.getName();
        if (source.getDirs().isEmpty() && type.getSimpleNames().size() == 1) {
            this.typeNameMap.put(type, shortName);
            return shortName;
        }
        StringBuilder builder = new StringBuilder();
        for (String dir : source.getDirs()) {
            if (builder.length() != 0) {
                builder.append('.');
            }
            builder.append(dir);
        }
        for (String simpleName : type.getSimpleNames()) {
            builder.append('.').append(simpleName);
        }
        String qualifiedName = builder.toString();
        if (this.importMap.containsKey(shortName)) {
            this.typeNameMap.put(type, qualifiedName);
            return qualifiedName;
        }
        this.importMap.put(shortName, qualifiedName);
        this.typeNameMap.put(type, shortName);
        return shortName;
    }
}

