/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.client.generator.java;

import java.util.UUID;
import org.babyfish.jimmer.client.generator.java.EnumTypeRender;
import org.babyfish.jimmer.client.generator.java.JavaContext;
import org.babyfish.jimmer.client.generator.java.ObjectTypeRender;
import org.babyfish.jimmer.client.generator.java.OperationRender;
import org.babyfish.jimmer.client.generator.java.ServiceRender;
import org.babyfish.jimmer.client.runtime.EnumType;
import org.babyfish.jimmer.client.runtime.ObjectType;
import org.babyfish.jimmer.client.runtime.Operation;
import org.babyfish.jimmer.client.runtime.Service;
import org.babyfish.jimmer.client.source.Source;
import org.babyfish.jimmer.client.source.SourceManager;

public class JavaSourceManager
extends SourceManager {
    private final String rootDir;

    protected JavaSourceManager(JavaContext ctx) {
        super(ctx);
        this.rootDir = ctx.getPackageName().replace('.', '/');
    }

    @Override
    protected Source createServiceSource(Service service) {
        return this.createRootSource(this.rootDir + "/service", service.getJavaType().getSimpleName(), () -> new ServiceRender(service));
    }

    @Override
    protected Source createServiceImplSource(Service service) {
        return this.createRootSource(this.rootDir + "/service/impl", service.getJavaType().getSimpleName() + "Impl", () -> new ServiceRender(service));
    }

    @Override
    protected Source createOperationSource(Operation operation) {
        return this.getSource(operation.getDeclaringService()).subSource(operation.getName() + '_' + UUID.randomUUID(), () -> new OperationRender(operation));
    }

    @Override
    protected Source createStaticTypeSource(ObjectType objectType) {
        return this.createRootSource(this.rootDir + "/model/static", objectType.getJavaType().getSimpleName(), () -> new ObjectTypeRender(objectType, objectType.getJavaType().getSimpleName(), false));
    }

    @Override
    protected Source createFetchedTypeSource(ObjectType objectType) {
        return this.createRootSource(this.rootDir + "/model/dto", objectType.getJavaType().getSimpleName() + '_' + objectType.getFetchByInfo().getOwnerType().getSimpleName() + '_' + objectType.getFetchByInfo().getConstant(), () -> new ObjectTypeRender(objectType, objectType.getJavaType().getSimpleName(), false));
    }

    @Override
    protected Source createDynamicTypeSource(ObjectType objectType) {
        return this.createRootSource(this.rootDir + "/model/dynamic", "Dynamic" + objectType.getJavaType().getSimpleName(), () -> new ObjectTypeRender(objectType, objectType.getJavaType().getSimpleName(), true));
    }

    @Override
    protected Source createEmbeddableTypeSource(ObjectType objectType) {
        return this.createRootSource(this.rootDir + "/model/embeddable", objectType.getJavaType().getSimpleName(), () -> new ObjectTypeRender(objectType, objectType.getJavaType().getSimpleName(), false));
    }

    @Override
    protected Source createEnumTypeSource(EnumType enumType) {
        return this.createRootSource(this.rootDir + "/model/constant", enumType.getJavaType().getSimpleName(), () -> new EnumTypeRender(enumType));
    }
}

