/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.util;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.util.GenericParser;
import org.babyfish.jimmer.jackson.Converter;

public class ConverterMetadata {
    private final TypeMirror sourceType;
    private final TypeMirror targetType;
    private final TypeName sourceTypeName;
    private final TypeName targetTypeName;

    public static ConverterMetadata of(TypeElement converterElement) {
        if (!converterElement.getTypeParameters().isEmpty()) {
            throw new MetaException(converterElement, "It should not have type parameters");
        }
        GenericParser.Result result = new GenericParser("converter", converterElement, Converter.class.getName()).parse();
        return new ConverterMetadata(result.arguments.get(0), result.arguments.get(1), result.argumentTypeNames.get(0), result.argumentTypeNames.get(1));
    }

    public ConverterMetadata(TypeMirror sourceType, TypeMirror targetType, TypeName sourceTypeName, TypeName targetTypeName) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.sourceTypeName = sourceTypeName;
        this.targetTypeName = targetTypeName;
    }

    public TypeMirror getSourceType() {
        return this.sourceType;
    }

    public TypeMirror getTargetType() {
        return this.targetType;
    }

    public TypeName getSourceTypeName() {
        return this.sourceTypeName;
    }

    public TypeName getTargetTypeName() {
        return this.targetTypeName;
    }

    public ConverterMetadata toListMetadata(Context ctx) {
        TypeElement listElement = ctx.getElements().getTypeElement(List.class.getName());
        return new ListMetadata(ctx.getTypes().getDeclaredType(listElement, this.sourceType), ctx.getTypes().getDeclaredType(listElement, this.targetType), (TypeName)ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{this.sourceTypeName}), (TypeName)ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{this.targetTypeName}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConverterMetadata metadata = (ConverterMetadata)o;
        if (!this.sourceTypeName.equals((Object)metadata.sourceTypeName)) {
            return false;
        }
        return this.targetTypeName.equals((Object)metadata.targetTypeName);
    }

    public int hashCode() {
        int result = this.sourceTypeName.hashCode();
        result = 31 * result + this.targetTypeName.hashCode();
        return result;
    }

    public String toString() {
        return "ConverterMetadata{sourceTypeName=" + this.sourceTypeName + ", targetTypeName=" + this.targetTypeName + '}';
    }

    private static class ListMetadata
    extends ConverterMetadata {
        public ListMetadata(TypeMirror sourceType, TypeMirror targetType, TypeName sourceTypeName, TypeName targetTypeName) {
            super(sourceType, targetType, sourceTypeName, targetTypeName);
        }

        @Override
        public ConverterMetadata toListMetadata(Context context) {
            throw new UnsupportedOperationException("The current object is already list metadata");
        }
    }
}

