/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.tuple;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.impl.util.StringUtil;
import org.babyfish.jimmer.sql.TypedTuple;
import org.jetbrains.annotations.Nullable;

public class TypedTupleGenerator {
    private static final TypeName SELECTION_ARR_TYPE_NAME = ArrayTypeName.of((TypeName)ParameterizedTypeName.get((ClassName)Constants.SELECTION_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)}));
    private final Context context;
    private final TypeElement typeElement;
    private final List<VariableElement> fieldElements;
    private final ClassName className;
    private final int[] ctorPropIndices;
    private TypeSpec.Builder typeBuilder;

    TypedTupleGenerator(Context context, TypeElement typeElement) {
        this.context = context;
        this.typeElement = typeElement;
        ArrayList<VariableElement> fieldElements = new ArrayList<VariableElement>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (!(element instanceof VariableElement) || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            fieldElements.add((VariableElement)element);
        }
        if (fieldElements.isEmpty()) {
            throw new MetaException(typeElement, "There is no non-state field");
        }
        this.fieldElements = Collections.unmodifiableList(fieldElements);
        this.className = ClassName.get((String)((PackageElement)typeElement.getEnclosingElement()).getQualifiedName().toString(), (String)(typeElement.getSimpleName().toString() + "Mapper"), (String[])new String[0]);
        this.ctorPropIndices = this.determineCtorPropIndices();
    }

    private int[] determineCtorPropIndices() {
        int lombokCtorKind = this.findLombokCtorKind();
        if (lombokCtorKind == 2) {
            int[] indices = new int[this.fieldElements.size()];
            for (int i = indices.length - 1; i >= 0; --i) {
                indices[i] = i;
            }
            return indices;
        }
        if (lombokCtorKind == 1) {
            return null;
        }
        if (this.hasDefaultConstructor()) {
            return null;
        }
        int[] indices = this.findUserAllArgsConstructorPropIndices();
        if (indices != null) {
            return indices;
        }
        throw new MetaException(this.typeElement, "it is decorated by @" + TypedTuple.class.getName() + ", but there is neither default constructor nor constructor with full arguments");
    }

    private int findLombokCtorKind() {
        TypeElement annotationElement;
        for (AnnotationMirror annotationMirror : this.typeElement.getAnnotationMirrors()) {
            annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getQualifiedName().toString().equals("lombok.Builder")) continue;
            throw new MetaException(this.typeElement, "it is decorated by @" + TypedTuple.class.getName() + ", so it cannot be decorated by @lombok.Builder");
        }
        for (AnnotationMirror annotationMirror : this.typeElement.getAnnotationMirrors()) {
            annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getQualifiedName().toString().equals("lombok.AllArgsConstructor")) continue;
            return 2;
        }
        for (AnnotationMirror annotationMirror : this.typeElement.getAnnotationMirrors()) {
            annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getQualifiedName().toString().equals("lombok.NoArgsConstructor")) continue;
            return 1;
        }
        for (AnnotationMirror annotationMirror : this.typeElement.getAnnotationMirrors()) {
            annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getQualifiedName().toString().equals("lombok.Data")) continue;
            Boolean isFinal = null;
            for (VariableElement field : this.fieldElements) {
                boolean _final = field.getModifiers().contains((Object)Modifier.FINAL);
                if (isFinal != null && isFinal != _final) {
                    throw new MetaException(this.typeElement, "it is decorated by both @" + TypedTuple.class.getName() + " and @lombok.Data, so it cannot mix final fields and non-final fields");
                }
                isFinal = _final;
            }
            return isFinal != null && isFinal != false ? 2 : 1;
        }
        return 0;
    }

    private boolean hasDefaultConstructor() {
        boolean hasConstructor = false;
        for (Element element : this.typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            hasConstructor = true;
            if (element.getModifiers().contains((Object)Modifier.PRIVATE) || !(executableElement = (ExecutableElement)element).getParameters().isEmpty()) continue;
            return true;
        }
        return !hasConstructor;
    }

    private int[] findUserAllArgsConstructorPropIndices() {
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            int count = executableElement.getParameters().size();
            if (this.fieldElements.size() != count) continue;
            int[] indices = new int[count];
            for (int paramIndex = 0; paramIndex < count; ++paramIndex) {
                VariableElement param = executableElement.getParameters().get(paramIndex);
                int matchedFieldIndex = -1;
                for (int fieldIndex = 0; fieldIndex < this.fieldElements.size(); ++fieldIndex) {
                    VariableElement field = this.fieldElements.get(fieldIndex);
                    if (!field.getSimpleName().toString().equals(param.getSimpleName().toString()) || !field.asType().equals(param.asType())) continue;
                    matchedFieldIndex = fieldIndex;
                    indices[paramIndex] = fieldIndex;
                    break;
                }
                if (matchedFieldIndex != -1) continue;
                indices = null;
                break;
            }
            if (indices == null) continue;
            return indices;
        }
        return null;
    }

    public void generate() {
        this.typeBuilder = TypeSpec.classBuilder((String)this.className.simpleName()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Constants.TUPLE_MAPPER_CLASS_NAME, (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.typeElement)})).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.generateFields();
        this.generateConstructor();
        this.generateGetSelections();
        this.generateCreateTuple();
        this.generateFirstMethod();
        int size = this.fieldElements.size();
        for (int i = 1; i < size; ++i) {
            this.generateBuilderClass(i, this.fieldElements.get(i), i + 1 < size ? this.fieldElements.get(i + 1) : null);
        }
        TypeSpec typeSpec = this.typeBuilder.build();
        try {
            JavaFile.builder((String)this.className.packageName(), (TypeSpec)typeSpec).indent("    ").build().writeTo(this.context.getFiler());
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate draft interface for '%s'", this.typeElement.getQualifiedName()), ex);
        }
    }

    private void generateFields() {
        this.typeBuilder.addField(FieldSpec.builder((TypeName)SELECTION_ARR_TYPE_NAME, (String)"selections", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    private void generateConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameter((TypeName)ArrayTypeName.of((TypeName)ParameterizedTypeName.get((ClassName)Constants.SELECTION_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})), "selections", new Modifier[0]).addStatement("this.selections = selections", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void generateGetSelections() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSelections").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)Constants.LIST_CLASS_NAME, (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)Constants.SELECTION_CLASS_NAME, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})})).addStatement("return $T.unmodifiableList($T.asList(selections))", new Object[]{Constants.COLLECTIONS_CLASS_NAME, Constants.ARRAYS_CLASS_NAME});
        this.typeBuilder.addMethod(builder.build());
    }

    private void generateCreateTuple() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createTuple").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeName.OBJECT), "args", new Modifier[0]).returns(TypeName.get((TypeMirror)this.typeElement.asType()));
        if (this.ctorPropIndices != null) {
            builder.addCode("return new $T($>\n", new Object[]{this.typeElement});
            for (int paramIndex = 0; paramIndex < this.ctorPropIndices.length; ++paramIndex) {
                int fieldIndex = this.ctorPropIndices[paramIndex];
                if (paramIndex != 0) {
                    builder.addCode(",\n", new Object[0]);
                }
                builder.addCode("($T)args[$L]", new Object[]{TypeName.get((TypeMirror)this.fieldElements.get(fieldIndex).asType()).box(), fieldIndex});
            }
            builder.addCode("$<\n);", new Object[0]);
        } else {
            builder.addStatement("$T __tuple = new $T()", new Object[]{this.typeElement, this.typeElement});
            for (int i = 0; i < this.fieldElements.size(); ++i) {
                VariableElement field = this.fieldElements.get(i);
                builder.addStatement("__tuple.$L(($T)args[$L])", new Object[]{StringUtil.identifier((String[])new String[]{"set", field.getSimpleName().toString()}), TypeName.get((TypeMirror)field.asType()).box(), i});
            }
            builder.addStatement("return __tuple", new Object[0]);
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void generateFirstMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.fieldElements.get(0).getSimpleName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.SELECTION_CLASS_NAME, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.fieldElements.get(0).asType()).box()}), "selection", new Modifier[0]);
        VariableElement firstFieldElement = this.fieldElements.get(0);
        ClassName className = this.className.nestedClass(StringUtil.typeName((String[])new String[]{firstFieldElement.getSimpleName().toString()}) + "Builder");
        builder.returns((TypeName)className);
        builder.addStatement("$T<?>[] selections = new $T<?>[$L]", new Object[]{Constants.SELECTION_CLASS_NAME, Constants.SELECTION_CLASS_NAME, this.fieldElements.size()});
        this.addMapCode(builder, 0, this.fieldElements.size() < 2 ? null : this.fieldElements.get(1));
        this.typeBuilder.addMethod(builder.build());
    }

    private void generateBuilderClass(int index, VariableElement fieldElement, @Nullable VariableElement nextFieldElement) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(StringUtil.typeName((String[])new String[]{fieldElement.getSimpleName().toString()}) + "Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addField(FieldSpec.builder((TypeName)SELECTION_ARR_TYPE_NAME, (String)"selections", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addParameter(SELECTION_ARR_TYPE_NAME, "selections", new Modifier[0]).addStatement("this.selections = selections", new Object[0]).build()).addMethod(this.newBuildMethod(index, fieldElement, nextFieldElement));
        this.typeBuilder.addType(builder.build());
    }

    private MethodSpec newBuildMethod(int index, VariableElement fieldElement, @Nullable VariableElement nextFieldElement) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)fieldElement.getSimpleName().toString()).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Constants.SELECTION_CLASS_NAME, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)fieldElement.asType()).box()}), "selection", new Modifier[0]);
        this.addMapCode(builder, index, nextFieldElement);
        return builder.build();
    }

    private void addMapCode(MethodSpec.Builder builder, int index, VariableElement nextFieldElement) {
        builder.addStatement("selections[$L] = selection", new Object[]{index});
        if (nextFieldElement != null) {
            ClassName className = this.className.nestedClass(StringUtil.typeName((String[])new String[]{nextFieldElement.getSimpleName().toString()}) + "Builder");
            builder.returns((TypeName)className);
            builder.addStatement("return new $T(selections)", new Object[]{className});
        } else {
            builder.returns((TypeName)this.className);
            builder.addStatement("return new $T(selections)", new Object[]{this.className});
        }
    }
}

