/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.transactional;

import java.util.LinkedHashMap;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.transactional.TxGenerator;
import org.babyfish.jimmer.apt.transactional.TxUtil;

public class TxProcessor {
    private final Context ctx;

    public TxProcessor(Context ctx) {
        this.ctx = ctx;
    }

    public void process(RoundEnvironment roundEnv) {
        if (this.ctx.isBuddyIgnoreResourceGeneration()) {
            return;
        }
        TypeElement txElement = this.ctx.getElements().getTypeElement("org.babyfish.jimmer.sql.transaction.Tx");
        if (txElement == null) {
            return;
        }
        LinkedHashMap<String, TypeElement> map = new LinkedHashMap<String, TypeElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(txElement)) {
            TypeElement typeElement;
            if (TxUtil.tx(this.ctx, element) == null) continue;
            if (element instanceof TypeElement) {
                typeElement = (TypeElement)element;
                map.computeIfAbsent(typeElement.getQualifiedName().toString(), it -> this.validateType(typeElement));
                continue;
            }
            if (!(element instanceof ExecutableElement)) continue;
            typeElement = (TypeElement)element.getEnclosingElement();
            map.computeIfAbsent(typeElement.getQualifiedName().toString(), it -> this.validateType(typeElement));
        }
        for (TypeElement typeElement : map.values()) {
            new TxGenerator(this.ctx, typeElement).generate();
        }
    }

    private TypeElement validateType(Element element) {
        TypeElement typeElement = (TypeElement)element;
        if (typeElement.getKind() != ElementKind.CLASS) {
            throw new MetaException(typeElement, "The type uses `@Tx` must be class");
        }
        if (!(typeElement.getEnclosingElement() instanceof PackageElement)) {
            throw new MetaException(typeElement, "The class uses `@Tx` must be top-level class");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new MetaException(typeElement, "The class uses by `@Tx` cannot be final");
        }
        if (!typeElement.getTypeParameters().isEmpty()) {
            throw new MetaException(typeElement, "The current version does not yet support the use of generics for types annotated with @Tx");
        }
        if (!this.ctx.isObject(typeElement.getSuperclass())) {
            throw new MetaException(typeElement, "The current version does not yet support the use of inheritance for types annotated with @Tx");
        }
        return typeElement;
    }
}

