/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.transactional;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.generator.Annotations;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.transactional.TxUtil;

public class TxGenerator {
    private final Context ctx;
    private final TypeElement typeElement;
    private final TypeMirror sqlClientType;
    private final TypeMirror runtimeExceptionType;
    private final String sqlClientName;
    private final AnnotationMirror classTx;
    private TypeSpec.Builder typeBuilder;

    public TxGenerator(Context ctx, TypeElement typeElement) {
        this.ctx = ctx;
        this.typeElement = typeElement;
        this.sqlClientType = ctx.getElements().getTypeElement("org.babyfish.jimmer.sql.JSqlClient").asType();
        this.runtimeExceptionType = ctx.getElements().getTypeElement("java.lang.RuntimeException").asType();
        this.sqlClientName = this.sqlClientName();
        this.classTx = TxUtil.tx(ctx, typeElement);
    }

    private String sqlClientName() {
        Element sqlClientElement = null;
        for (Element element : this.typeElement.getEnclosedElements()) {
            VariableElement variableElement;
            if (element.getKind() != ElementKind.FIELD || (variableElement = (VariableElement)element).getModifiers().contains((Object)Modifier.STATIC) || !this.ctx.getTypes().isAssignable(this.sqlClientType, variableElement.asType())) continue;
            if (sqlClientElement != null) {
                throw new MetaException(element, "The class uses @Tx cannot multiple non-static sqlClient fields");
            }
            sqlClientElement = variableElement;
        }
        if (sqlClientElement == null) {
            throw new MetaException(this.typeElement, "The class uses @Tx must have a non-static field whose type is JSqlClient");
        }
        if (sqlClientElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new MetaException(sqlClientElement, "The sqlClient field of the class uses @Tx cannot be private, default or protected is recommended");
        }
        return sqlClientElement.getSimpleName().toString();
    }

    public void generate() {
        this.typeBuilder = TypeSpec.classBuilder((String)(this.typeElement.getSimpleName().toString() + "Tx")).superclass(this.typeElement.asType());
        for (AnnotationMirror annotationMirror : this.typeElement.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)this.ctx.getTypes().asElement(annotationMirror.getAnnotationType());
            String qualifiedName = annotationElement.getQualifiedName().toString();
            if ("org.babyfish.jimmer.sql.transaction.TargetAnnotation".equals(qualifiedName) || "org.babyfish.jimmer.sql.transaction.Tx".equals(qualifiedName)) continue;
            this.typeBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        AnnotationMirror targetAnnotation = TxUtil.targetAnnotation(this.ctx, this.typeElement);
        if (targetAnnotation != null) {
            String string = targetAnnotation.getElementValues().values().iterator().next().getValue().toString();
            this.typeBuilder.addAnnotation(ClassName.bestGuess((String)string));
        }
        if (this.typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        if (this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        this.addConstructors();
        this.addMethods();
        try {
            JavaFile.builder((String)((PackageElement)this.typeElement.getEnclosingElement()).getQualifiedName().toString(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.ctx.getFiler());
        }
        catch (IOException iOException) {
            throw new GeneratorException(String.format("Cannot generate tx class for '%s'", this.typeElement.getQualifiedName().toString()), iOException);
        }
    }

    private void addConstructors() {
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            MethodSpec.Builder builder = MethodSpec.constructorBuilder();
            StringBuilder sb = new StringBuilder();
            for (VariableElement variableElement : executableElement.getParameters()) {
                builder.addParameter(ParameterSpec.get((VariableElement)variableElement));
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(variableElement.getSimpleName().toString());
            }
            builder.addStatement("super(" + sb + ')', new Object[0]);
            this.typeBuilder.addMethod(builder.build());
        }
    }

    private void addMethods() {
        for (Element element : this.typeElement.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            AnnotationMirror tx = TxUtil.tx(this.ctx, element);
            if (tx != null) {
                if (element.getKind() != ElementKind.METHOD) {
                    throw new MetaException(element, "Member that is not method cannot be decorated by @Tx");
                }
                if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new MetaException(element, "Static method cannot be decorated by @Tx");
                }
                if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new MetaException(element, "Private method cannot be decorated by @Tx");
                }
                if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                    throw new MetaException(element, "Final method cannot be decorated by @Tx");
                }
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new MetaException(element, "Abstract method cannot be decorated by @Tx");
                }
                for (TypeMirror typeMirror : ((ExecutableElement)element).getThrownTypes()) {
                    if (this.ctx.getTypes().isAssignable(this.runtimeExceptionType, typeMirror)) continue;
                    TypeElement thrownElement = (TypeElement)this.ctx.getTypes().asElement(typeMirror);
                    throw new MetaException(element, "Method decorated by @Tx can only throw RuntimeException, but it throws \"" + thrownElement.getQualifiedName() + "\"");
                }
            }
            if (tx == null && this.classTx != null && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getKind() == ElementKind.METHOD && !element.getModifiers().contains((Object)Modifier.STATIC) && !element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                    throw new MetaException(element, "The public method inherits the class-level @Tx cannot be final");
                }
                tx = this.classTx;
            }
            if (tx == null) continue;
            this.addMethod((ExecutableElement)element, tx);
        }
    }

    private void addMethod(ExecutableElement executableElement, AnnotationMirror tx) {
        String doc;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)executableElement.getSimpleName().toString()).addAnnotation(Override.class);
        if (executableElement.getModifiers().contains((Object)Modifier.PROTECTED)) {
            builder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
        if (executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        if ((doc = this.ctx.getElements().getDocComment(executableElement)) != null) {
            builder.addJavadoc(doc.replace("$", "$$"), new Object[0]);
        }
        for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
            TypeElement typeElement = (TypeElement)this.ctx.getTypes().asElement(annotationMirror.getAnnotationType());
            String qualifiedName = typeElement.getQualifiedName().toString();
            if ("java.lang.Override".equals(qualifiedName) || "org.babyfish.jimmer.sql.transaction.Tx".equals(qualifiedName)) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        builder.returns(TypeName.get((TypeMirror)executableElement.getReturnType()));
        StringBuilder sb = new StringBuilder();
        for (VariableElement variableElement : executableElement.getParameters()) {
            builder.addParameter(ParameterSpec.get((VariableElement)variableElement));
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(variableElement.getSimpleName().toString());
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            builder.addException(TypeName.get((TypeMirror)typeMirror));
        }
        Element element = Annotations.annotationValue(tx, "value", null);
        String string = element != null ? element.getSimpleName().toString() : "REQUIRED";
        boolean isVoid = executableElement.getReturnType().getKind() == TypeKind.VOID;
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.add("$L$L.transaction($T.$L, () -> $> {\n", new Object[]{isVoid ? "" : "return ", this.sqlClientName, Constants.PROPAGATION_CLASS_NAME, string});
        cb.add("$Lsuper.$L($L);\n", new Object[]{isVoid ? "" : "return ", executableElement.getSimpleName().toString(), sb.toString()});
        if (isVoid) {
            cb.add("return null;\n", new Object[0]);
        }
        cb.add("$<});", new Object[0]);
        builder.addCode(cb.build());
        this.typeBuilder.addMethod(builder.build());
    }
}

