/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.UnloadedException;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.immutable.generator.CaseAppender;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.FormulaDependency;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.NonSharedList;
import org.babyfish.jimmer.sql.Id;
import org.jetbrains.annotations.Nullable;

public class ImplGenerator {
    private final Context ctx;
    private final ImmutableType type;
    private final ClassName unloadedExceptionClassName;
    private TypeSpec.Builder typeBuilder;

    public ImplGenerator(Context ctx, ImmutableType type) {
        this.ctx = ctx;
        this.type = type;
        this.unloadedExceptionClassName = ClassName.get(UnloadedException.class);
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Impl").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type)).superclass((TypeName)this.type.getImplementorClassName()).addSuperinterface((TypeName)Constants.CLONEABLE_CLASS_NAME).addSuperinterface((TypeName)Constants.SERIALIZABLE_CLASS_NAME);
        this.addFields();
        this.addConstructor();
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addGetter(prop);
        }
        this.addClone();
        this.addIsLoaded(PropId.class);
        this.addIsLoaded(String.class);
        this.addIsVisible(PropId.class);
        this.addIsVisible(String.class);
        this.addHashCode(false);
        this.addHashCode(true);
        this.addParameterizedHashCode();
        this.addEquals(false);
        this.addEquals(true);
        this.addParameterizedEquals();
        this.addToString();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addFields() {
        this.typeBuilder.addField(FieldSpec.builder((TypeName)Constants.VISIBILITY_CLASS_NAME, (String)"__visibility", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isValueRequired()) {
                FieldSpec.Builder valueBuilder = FieldSpec.builder((TypeName)(prop.isList() ? ParameterizedTypeName.get((ClassName)ClassName.get(NonSharedList.class), (TypeName[])new TypeName[]{prop.getElementTypeName()}) : TypeName.get((TypeMirror)prop.getReturnType())), (String)prop.getValueName(), (Modifier[])new Modifier[0]);
                this.typeBuilder.addField(valueBuilder.build());
            }
            if (!prop.isLoadedStateRequired()) continue;
            FieldSpec.Builder stateBuilder = FieldSpec.builder(Boolean.TYPE, (String)prop.getLoadedStateName(), (Modifier[])new Modifier[0]).initializer("false", new Object[0]);
            this.typeBuilder.addField(stateBuilder.build());
        }
    }

    private void addConstructor() {
        if (this.type.getProps().values().stream().allMatch(ImmutableProp::isValueRequired)) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.constructorBuilder();
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isValueRequired()) continue;
            builder.addStatement("__visibility = $T.of($L)", new Object[]{Constants.VISIBILITY_CLASS_NAME, this.type.getProps().size()});
            break;
        }
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (prop.isValueRequired()) continue;
            builder.addStatement("__visibility.show($L, false)", new Object[]{prop.getSlotName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addGetter(ImmutableProp prop) {
        ImmutableProp idViewBaseProp;
        Doc doc;
        String comment;
        if (prop.isJavaFormula() || prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)prop.getReturnType()));
        if (!prop.isBeanStyle()) {
            builder.addAnnotation(Constants.JSON_IGNORE_CLASS_NAME);
        }
        if (prop.isNullable()) {
            builder.addAnnotation(Nullable.class);
        }
        if ((comment = this.ctx.getElements().getDocComment(prop.toElement())) != null && !comment.isEmpty() && (doc = Doc.parse((String)comment)) != null && (comment = doc.getValue()) != null && !comment.isEmpty()) {
            builder.addAnnotation(AnnotationSpec.builder((ClassName)Constants.DESCRIPTION_CLASS_NAME).addMember("value", "$S", new Object[]{comment}).build());
        }
        if ((idViewBaseProp = prop.getIdViewBaseProp()) != null) {
            if (idViewBaseProp.isList()) {
                builder.addStatement("return new $T<>($T.TYPE, $L())", new Object[]{Constants.ID_VIEW_LIST_CLASS_NAME, idViewBaseProp.getTargetType().getProducerClassName(), idViewBaseProp.getGetterName()});
            } else {
                builder.addStatement("$T __target = $L()", new Object[]{idViewBaseProp.getElementTypeName(), idViewBaseProp.getGetterName()});
                builder.addStatement(prop.isNullable() ? "return __target != null ? __target.$L() : null" : "return __target.$L()", new Object[]{idViewBaseProp.getTargetType().getIdProp().getGetterName()});
            }
        } else {
            if (prop.isLoadedStateRequired()) {
                builder.beginControlFlow("if (!$L)", new Object[]{prop.getLoadedStateName()});
            } else {
                builder.beginControlFlow("if ($L == null)", new Object[]{prop.getValueName()});
            }
            builder.addStatement("throw new $T($T.class, $S)", new Object[]{this.unloadedExceptionClassName, this.type.getClassName(), prop.getName()}).endControlFlow();
            builder.addStatement("return $L", new Object[]{prop.getValueName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addClone() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"clone").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.type.getImplClassName());
        builder.beginControlFlow("try", new Object[0]).addStatement("return ($T)super.clone()", new Object[]{this.type.getImplClassName()}).nextControlFlow("catch($T ex)", new Object[]{Constants.CLONE_NOT_SUPPORTED_EXCEPTION_CLASS_NAME}).addStatement("throw new AssertionError(ex)", new Object[0]).endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addIsLoaded(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__isLoaded").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).returns(Boolean.TYPE);
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        if (argType == PropId.class) {
            builder.addStatement("int __propIndex = prop.asIndex()", new Object[0]);
            builder.beginControlFlow("switch (__propIndex)", new Object[0]);
            appender.addIllegalCase();
            builder.addStatement("return __isLoaded(prop.asName())", new Object[0]);
        } else {
            builder.beginControlFlow("switch (prop)", new Object[0]);
        }
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            appender.addCase(prop);
            ImmutableProp idViewBaseProp = prop.getIdViewBaseProp();
            ImmutableProp manyToManyViewBaseProp = prop.getManyToManyViewBaseProp();
            if (idViewBaseProp != null) {
                if (idViewBaseProp.isList()) {
                    builder.addStatement("return __isLoaded($T.byIndex($L)) && $L().stream().allMatch(__each -> \n$>(($T)__each).__isLoaded($T.byIndex($T.$L))\n$<)", new Object[]{Constants.PROP_ID_CLASS_NAME, idViewBaseProp.getSlotName(), idViewBaseProp.getGetterName(), ImmutableSpi.class, Constants.PROP_ID_CLASS_NAME, idViewBaseProp.getTargetType().getProducerClassName(), idViewBaseProp.getTargetType().getIdProp().getSlotName()});
                    continue;
                }
                builder.addStatement("return __isLoaded($T.byIndex($L)) && ($L() == null || \n\t(($T)$L()).__isLoaded($T.byIndex($T.$L)))", new Object[]{Constants.PROP_ID_CLASS_NAME, idViewBaseProp.getSlotName(), idViewBaseProp.getGetterName(), ImmutableSpi.class, idViewBaseProp.getGetterName(), Constants.PROP_ID_CLASS_NAME, idViewBaseProp.getTargetType().getProducerClassName(), idViewBaseProp.getTargetType().getIdProp().getSlotName()});
                continue;
            }
            if (manyToManyViewBaseProp != null) {
                builder.addStatement("return __isLoaded($T.byIndex($L)) && $L().stream().allMatch(__each -> \n$>(($T)__each).__isLoaded($L)$<\n)", new Object[]{Constants.PROP_ID_CLASS_NAME, manyToManyViewBaseProp.getSlotName(), manyToManyViewBaseProp.getGetterName(), ImmutableSpi.class, prop.getDeeperPropIdName()});
                continue;
            }
            if (prop.isJavaFormula()) {
                boolean first = true;
                builder.addCode("return $>", new Object[0]);
                for (FormulaDependency dependency : prop.getDependencies()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.addCode(" && \n", new Object[0]);
                    }
                    if (dependency.getProps().size() == 1) {
                        builder.addCode("__isLoaded($T.byIndex($L))", new Object[]{Constants.PROP_ID_CLASS_NAME, dependency.getProps().get(0).getSlotName()});
                        continue;
                    }
                    builder.addCode("$T.isLoadedChain(this", new Object[]{Constants.IMMUTABLE_OBJECTS_CLASS_NAME});
                    for (ImmutableProp depProp : dependency.getProps()) {
                        builder.addCode(", ", new Object[0]);
                        builder.addCode("$T.byIndex($T.$L)", new Object[]{Constants.PROP_ID_CLASS_NAME, depProp.getDeclaringType().getProducerClassName(), depProp.getSlotName()});
                    }
                    builder.addCode(")", new Object[0]);
                }
                builder.addStatement("$<", new Object[0]);
                continue;
            }
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("return $L", new Object[]{prop.getLoadedStateName()});
                continue;
            }
            builder.addStatement("return $L != null", new Object[]{prop.getValueName()});
        }
        builder.addStatement("default: throw new IllegalArgumentException($S + prop + $S)", new Object[]{"Illegal property " + (argType == Integer.TYPE ? "id" : "name") + " for \"" + this.type + "\": \"", "\""});
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addIsVisible(Class<?> argType) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__isVisible").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(argType, "prop", new Modifier[0]).returns(Boolean.TYPE);
        builder.beginControlFlow("if (__visibility == null)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow();
        CaseAppender appender = new CaseAppender(builder, this.type, argType);
        if (argType == PropId.class) {
            builder.addStatement("int __propIndex = prop.asIndex()", new Object[0]);
            builder.beginControlFlow("switch (__propIndex)", new Object[0]);
            appender.addIllegalCase();
            builder.addStatement("return __isVisible(prop.asName())", new Object[0]);
        } else {
            builder.beginControlFlow("switch (prop)", new Object[0]);
        }
        for (ImmutableProp prop : this.type.getPropsOrderById()) {
            appender.addCase(prop);
            builder.addStatement("return __visibility.visible($L)", new Object[]{prop.getSlotName()});
        }
        builder.addStatement("default: return true", new Object[0]);
        builder.endControlFlow();
        this.typeBuilder.addMethod(builder.build());
    }

    private void addHashCode(boolean shallow) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(shallow ? "__shallowHashCode" : "hashCode")).addModifiers(new Modifier[]{shallow ? Modifier.PRIVATE : Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("int hash = __visibility != null ? __visibility.hashCode() : 0", new Object[0]);
        if (!shallow) {
            builder.addAnnotation(Override.class);
        }
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (!prop.isValueRequired()) continue;
            Class<?> boxType = prop.getBoxType();
            if (boxType != null) {
                builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
                builder.addStatement("hash = 31 * hash + $T.hashCode($L)", new Object[]{boxType, prop.getValueName()});
                if (!shallow && prop.getAnnotation(Id.class) != null) {
                    builder.addComment("If entity-id is loaded, return directly", new Object[0]);
                    builder.addStatement("return hash", new Object[0]);
                }
                builder.endControlFlow();
                continue;
            }
            if (shallow) {
                if (prop.isLoadedStateRequired()) {
                    builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName()});
                } else {
                    builder.beginControlFlow("if ($L != null)", new Object[]{prop.getValueName()});
                }
                builder.addStatement("hash = 31 * hash + $T.identityHashCode($L)", new Object[]{System.class, prop.getValueName()});
                builder.endControlFlow();
                continue;
            }
            if (prop.isLoadedStateRequired()) {
                builder.beginControlFlow("if ($L && $L != null)", new Object[]{prop.getLoadedStateName(), prop.getValueName()});
            } else {
                builder.beginControlFlow("if ($L != null)", new Object[]{prop.getValueName()});
            }
            builder.addStatement("hash = 31 * hash + $L.hashCode()", new Object[]{prop.getValueName()});
            if (prop.getAnnotation(Id.class) != null) {
                builder.addComment("If entity-id is loaded, return directly", new Object[0]);
                builder.addStatement("return hash", new Object[0]);
            }
            builder.endControlFlow();
        }
        builder.addStatement("return hash", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addEquals(boolean shallow) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(shallow ? "__shallowEquals" : "equals")).addModifiers(new Modifier[]{shallow ? Modifier.PRIVATE : Modifier.PUBLIC}).addParameter(Object.class, "obj", new Modifier[0]).returns(Boolean.TYPE);
        if (!shallow) {
            builder.addAnnotation(Override.class);
        }
        builder.beginControlFlow("if (obj == null || !(obj instanceof $T))", new Object[]{this.type.getImplementorClassName()}).addStatement("return false", new Object[0]).endControlFlow().addStatement("$T __other = ($T)obj", new Object[]{this.type.getImplementorClassName(), this.type.getImplementorClassName()});
        for (ImmutableProp prop : this.type.getProps().values()) {
            builder.beginControlFlow("if (__isVisible($T.byIndex($L)) != __other.__isVisible($T.byIndex($L)))", new Object[]{Constants.PROP_ID_CLASS_NAME, prop.getSlotName(), Constants.PROP_ID_CLASS_NAME, prop.getSlotName()}).addStatement("return false", new Object[0]).endControlFlow();
            if (!prop.isValueRequired()) continue;
            if (prop.isLoadedStateRequired()) {
                builder.addStatement("boolean $L = this.$L", new Object[]{prop.getLoadedStateName(), prop.getLoadedStateName()});
            } else {
                builder.addStatement("boolean $L = $L != null", new Object[]{prop.getLoadedStateName(true), prop.getValueName()});
            }
            builder.beginControlFlow("if ($L != __other.__isLoaded($T.byIndex($L)))", new Object[]{prop.getLoadedStateName(true), Constants.PROP_ID_CLASS_NAME, prop.getSlotName()}).addStatement("return false", new Object[0]).endControlFlow();
            if (shallow || prop.getReturnType().getKind().isPrimitive()) {
                if (!shallow && prop.getAnnotation(Id.class) != null) {
                    builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName(true)}).addComment("If entity-id is loaded, return directly", new Object[0]).addStatement("return $L == __other.$L()", new Object[]{prop.getValueName(), prop.getGetterName()}).endControlFlow();
                    continue;
                }
                builder.beginControlFlow("if ($L && $L != __other.$L())", new Object[]{prop.getLoadedStateName(true), prop.getValueName(), prop.getGetterName()}).addStatement("return false", new Object[0]).endControlFlow();
                continue;
            }
            if (prop.getAnnotation(Id.class) != null) {
                builder.beginControlFlow("if ($L)", new Object[]{prop.getLoadedStateName(true)}).addComment("If entity-id is loaded, return directly", new Object[0]).addStatement("return $T.equals($L, __other.$L())", new Object[]{Objects.class, prop.getValueName(), prop.getGetterName()}).endControlFlow();
                continue;
            }
            builder.beginControlFlow("if ($L && !$T.equals($L, __other.$L()))", new Object[]{prop.getLoadedStateName(true), Objects.class, prop.getValueName(), prop.getGetterName()}).addStatement("return false", new Object[0]).endControlFlow();
        }
        builder.addStatement("return true", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addParameterizedHashCode() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Integer.TYPE).addCode("return shallow ? __shallowHashCode() : hashCode();", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addParameterizedEquals() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Object.class, "obj", new Modifier[0]).addParameter(Boolean.TYPE, "shallow", new Modifier[0]).returns(Boolean.TYPE).addCode("return shallow ? __shallowEquals(obj) : equals(obj);", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addToString() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $T.toString(this)", new Object[]{ImmutableObjects.class});
        this.typeBuilder.addMethod(builder.build());
    }
}

