/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.immutable.generator.AssociatedIdGenerator;
import org.babyfish.jimmer.apt.immutable.generator.BuilderGenerator;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.generator.ProducerGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.babyfish.jimmer.lang.OldChain;
import org.jetbrains.annotations.Nullable;

public class DraftGenerator {
    private final Context ctx;
    private final ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    public DraftGenerator(Context ctx, ImmutableType type) {
        this.ctx = ctx;
        this.type = type;
    }

    public void generate() {
        this.typeBuilder = TypeSpec.interfaceBuilder((String)(this.type.getName() + "Draft")).addSuperinterface((TypeName)this.type.getClassName()).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type));
        if (this.type.getSuperTypes().isEmpty()) {
            this.typeBuilder.addSuperinterface(Draft.class);
        } else {
            for (ImmutableType superType : this.type.getSuperTypes()) {
                this.typeBuilder.addSuperinterface((TypeName)superType.getDraftClassName());
            }
        }
        this.addMembers(this.type);
        try {
            JavaFile.builder((String)this.type.getPackageName(), (TypeSpec)this.typeBuilder.build()).indent("    ").build().writeTo(this.ctx.getFiler());
        }
        catch (IOException ex) {
            throw new GeneratorException(String.format("Cannot generate draft interface for '%s'", this.type.getName()), ex);
        }
    }

    private void addMembers(ImmutableType type) {
        if (type.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.typeBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        this.add$();
        for (ImmutableProp prop : type.getProps().values()) {
            this.addGetter(prop, false);
            this.addGetter(prop, true);
            this.addSetter(prop);
            this.addAssociatedIdGetter(prop);
            this.addAssociatedIdSetter(prop);
            this.addUtilMethod(prop, false);
            this.addUtilMethod(prop, true);
        }
        new ProducerGenerator(this.ctx, type).generate(this.typeBuilder);
        if (!type.isMappedSuperClass()) {
            new BuilderGenerator(type).generate(this.typeBuilder);
        }
    }

    private void add$() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ClassName.get((String)this.type.getPackageName(), (String)(this.type.getName() + "Draft.Producer"), (String[])new String[0]), (String)"$", (Modifier[])new Modifier[0]);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addModifiers(new Modifier[]{Modifier.STATIC});
        builder.addModifiers(new Modifier[]{Modifier.FINAL});
        builder.initializer("Producer.INSTANCE", new Object[0]);
        this.typeBuilder.addField(builder.build());
    }

    private void addGetter(ImmutableProp prop, boolean autoCreate) {
        if (prop.getManyToManyViewBaseProp() != null || prop.isFormula()) {
            return;
        }
        if (!(autoCreate || prop.isAssociation(false) && !prop.isList())) {
            return;
        }
        if (autoCreate && !prop.isAssociation(false) && !prop.isList()) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getGetterName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        if (autoCreate) {
            builder.addParameter(Boolean.TYPE, "autoCreate", new Modifier[0]);
        } else if (prop.isNullable()) {
            builder.addAnnotation(Nullable.class);
        }
        builder.returns(prop.getDraftTypeName(autoCreate));
        this.typeBuilder.addMethod(builder.build());
    }

    private void addAssociatedIdGetter(ImmutableProp prop) {
        new AssociatedIdGenerator(this.typeBuilder, false).getter(prop);
    }

    private void addAssociatedIdSetter(ImmutableProp prop) {
        new AssociatedIdGenerator(this.typeBuilder, false).setter(prop);
    }

    private void addSetter(ImmutableProp prop) {
        if (prop.isJavaFormula() || prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getSetterName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(OldChain.class).addParameter(TypeName.get((TypeMirror)prop.getReturnType()), prop.getName(), new Modifier[0]).returns((TypeName)this.type.getDraftClassName());
        this.typeBuilder.addMethod(builder.build());
    }

    private void addUtilMethod(ImmutableProp prop, boolean withBase) {
        if (prop.getManyToManyViewBaseProp() != null || !prop.isAssociation(false) || prop.isJavaFormula()) {
            return;
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(prop.isList() ? prop.getAdderByName() : prop.getApplierName())).addAnnotation(OldChain.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.type.getDraftClassName());
        if (withBase) {
            builder.addParameter(prop.getElementTypeName(), "base", new Modifier[0]);
        }
        ParameterizedTypeName consumerTypeName = ParameterizedTypeName.get((ClassName)Constants.DRAFT_CONSUMER_CLASS_NAME, (TypeName[])new TypeName[]{prop.getDraftElementTypeName()});
        builder.addParameter((TypeName)consumerTypeName, "block", new Modifier[0]);
        this.typeBuilder.addMethod(builder.build());
    }
}

