/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable.generator;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.immutable.generator.Annotations;
import org.babyfish.jimmer.apt.immutable.generator.Constants;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableProp;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.apt.util.GeneratedAnnotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderGenerator {
    private final ImmutableType type;
    private TypeSpec.Builder typeBuilder;

    public BuilderGenerator(ImmutableType type) {
        this.type = type;
    }

    public void generate(TypeSpec.Builder parentBuilder) {
        this.typeBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(GeneratedAnnotation.generatedAnnotation(this.type));
        this.addMembers();
        parentBuilder.addType(this.typeBuilder.build());
    }

    private void addMembers() {
        this.addField();
        this.addDefaultConstructor();
        this.addConstructor();
        for (ImmutableProp prop : this.type.getProps().values()) {
            this.addSetter(prop);
        }
        this.addBuild();
    }

    private void addField() {
        this.typeBuilder.addField(FieldSpec.builder((TypeName)this.type.getDraftImplClassName(), (String)"__draft", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
    }

    private void addDefaultConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addStatement("this(null)", new Object[]{this.type.getDraftImplClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private void addConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addParameter(ParameterSpec.builder((TypeName)this.type.getClassName(), (String)"base", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build());
        builder.addStatement("__draft = new $T(null, base)", new Object[]{this.type.getDraftImplClassName()});
        for (ImmutableProp prop : this.type.getProps().values()) {
            if (!BuilderGenerator.isVisibilityControllable(prop)) continue;
            builder.addStatement("__draft.__show($T.byIndex($T.$L), false)", new Object[]{Constants.PROP_ID_CLASS_NAME, this.type.getProducerClassName(), prop.getSlotName()});
        }
        this.typeBuilder.addMethod(builder.build());
    }

    private void addSetter(ImmutableProp prop) {
        if (prop.isJavaFormula() || prop.getManyToManyViewBaseProp() != null) {
            return;
        }
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)prop.getTypeName().box(), (String)prop.getName(), (Modifier[])new Modifier[0]);
        if (prop.isNullable()) {
            parameterBuilder.addAnnotation(Nullable.class);
        } else {
            parameterBuilder.addAnnotation(NotNull.class);
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)prop.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterBuilder.build()).returns((TypeName)this.type.getBuilderClassName());
        ArrayList<AnnotationMirror> annotations = new ArrayList<AnnotationMirror>(prop.getAnnotations().size());
        for (AnnotationMirror annotationMirror : prop.getAnnotations()) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (typeElement.getSimpleName().toString().equals("Nullable") || typeElement.getSimpleName().toString().equals("Null") || typeElement.getQualifiedName().toString().equals(Constants.T_NULLABLE_QUALIFIED_NAME)) continue;
            annotations.add(annotationMirror);
        }
        Annotations.copyNonJimmerAnnotations(builder, annotations);
        if (prop.isNullable()) {
            builder.addStatement("__draft.$L($L)", new Object[]{prop.getSetterName(), prop.getName()});
            if (BuilderGenerator.isVisibilityControllable(prop)) {
                builder.addStatement("__draft.__show($T.byIndex($T.$L), true)", new Object[]{Constants.PROP_ID_CLASS_NAME, this.type.getProducerClassName(), prop.getSlotName()});
            }
        } else {
            builder.beginControlFlow("if ($L != null)", new Object[]{prop.getName()});
            builder.addStatement("__draft.$L($L)", new Object[]{prop.getSetterName(), prop.getName()});
            if (BuilderGenerator.isVisibilityControllable(prop)) {
                builder.addStatement("__draft.__show($T.byIndex($T.$L), true)", new Object[]{Constants.PROP_ID_CLASS_NAME, this.type.getProducerClassName(), prop.getSlotName()});
            }
            builder.endControlFlow();
        }
        builder.addStatement("return this", new Object[0]);
        this.typeBuilder.addMethod(builder.build());
    }

    private void addBuild() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.type.getClassName());
        builder.addStatement("return ($T)__draft.__modified()", new Object[]{this.type.getClassName()});
        this.typeBuilder.addMethod(builder.build());
    }

    private static boolean isVisibilityControllable(ImmutableProp prop) {
        return prop.isBaseProp() || !prop.getDependencies().isEmpty() || prop.getIdViewBaseProp() != null || prop.getManyToManyViewBaseProp() != null;
    }
}

