/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.immutable;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.babyfish.jimmer.Immutable;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.immutable.generator.DraftGenerator;
import org.babyfish.jimmer.apt.immutable.generator.FetcherGenerator;
import org.babyfish.jimmer.apt.immutable.generator.PropExpressionGenerator;
import org.babyfish.jimmer.apt.immutable.generator.PropsGenerator;
import org.babyfish.jimmer.apt.immutable.generator.TableGenerator;
import org.babyfish.jimmer.apt.immutable.meta.ImmutableType;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;

public class ImmutableProcessor {
    private final Context context;
    private final Messager messager;

    public ImmutableProcessor(Context context, Messager messager) {
        this.context = context;
        this.messager = messager;
    }

    public Map<TypeElement, ImmutableType> process(RoundEnvironment roundEnv) {
        this.validateTopLevel(roundEnv, Immutable.class);
        this.validateTopLevel(roundEnv, Entity.class);
        this.validateTopLevel(roundEnv, Embeddable.class);
        this.validateTopLevel(roundEnv, MappedSuperclass.class);
        Map<TypeElement, ImmutableType> immutableTypeMap = this.parseImmutableTypes(roundEnv);
        this.generateJimmerTypes(immutableTypeMap);
        return immutableTypeMap;
    }

    private void validateTopLevel(RoundEnvironment roundEnv, Class<? extends Annotation> annotationType) {
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.getEnclosingElement() instanceof PackageElement) continue;
            throw new MetaException(typeElement, "The type decorated by \"@" + annotationType.getName() + "\" must be top level type");
        }
    }

    private Map<TypeElement, ImmutableType> parseImmutableTypes(RoundEnvironment roundEnv) {
        HashMap<TypeElement, ImmutableType> map = new HashMap<TypeElement, ImmutableType>();
        for (Element element : roundEnv.getRootElements()) {
            TypeElement typeElement;
            if (!(element instanceof TypeElement) || !this.context.isImmutable(typeElement = (TypeElement)element) || !this.context.include(typeElement)) continue;
            ImmutableType immutableType = this.context.getImmutableType(typeElement);
            map.put(typeElement, immutableType);
        }
        return map;
    }

    private void generateJimmerTypes(Map<TypeElement, ImmutableType> immutableTypeMap) {
        for (ImmutableType immutableType : immutableTypeMap.values()) {
            new DraftGenerator(this.context, immutableType).generate();
            new PropsGenerator(this.context, immutableType).generate();
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Immutable: " + immutableType.getQualifiedName());
            if (immutableType.isEntity()) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Entity: " + immutableType.getQualifiedName());
                new TableGenerator(this.context, immutableType, false).generate();
                new TableGenerator(this.context, immutableType, true).generate();
                new FetcherGenerator(this.context, immutableType).generate();
                continue;
            }
            if (!immutableType.isEmbeddable()) continue;
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Embeddable: " + immutableType.getQualifiedName());
            new PropExpressionGenerator(this.context, immutableType).generate();
            new FetcherGenerator(this.context, immutableType).generate();
        }
    }
}

