/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.error;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.error.ErrorGenerator;
import org.babyfish.jimmer.error.ErrorFamily;

public class ErrorProcessor {
    private final Context context;
    private final boolean checkedException;

    public ErrorProcessor(Context context, boolean checkedException) {
        this.context = context;
        this.checkedException = checkedException;
    }

    public boolean process(RoundEnvironment roundEnv) {
        List<TypeElement> errorElements = this.getErrorFamilies(roundEnv);
        this.generateErrorType(errorElements);
        return !errorElements.isEmpty();
    }

    private List<TypeElement> getErrorFamilies(RoundEnvironment roundEnv) {
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        for (Element element : roundEnv.getRootElements()) {
            if (!(element instanceof TypeElement) || !this.context.include((TypeElement)element) || element.getAnnotation(ErrorFamily.class) == null) continue;
            if (element.getKind() != ElementKind.ENUM) {
                throw new MetaException(element, "only enum can be decorated by @" + ErrorFamily.class.getName());
            }
            typeElements.add((TypeElement)element);
        }
        return typeElements;
    }

    private void generateErrorType(List<TypeElement> typeElements) {
        for (TypeElement typeElement : typeElements) {
            new ErrorGenerator(this.context, typeElement, this.checkedException).generate();
        }
    }
}

