/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit;

import java.io.Serializable;
import java.util.Date;

public class AuditActionContext
implements Serializable {
    private static final long serialVersionUID = -3530737409883959089L;
    private final String principal;
    private final String resourceOperatedUpon;
    private final String actionPerformed;
    private final String applicationCode;
    private final Date whenActionWasPerformed;
    private final String clientIpAddress;
    private final String serverIpAddress;

    public AuditActionContext(String principal, String resourceOperatedUpon, String actionPerformed, String applicationCode, Date whenActionWasPerformed, String clientIpAddress, String serverIpAddress) {
        this.principal = principal;
        this.resourceOperatedUpon = resourceOperatedUpon;
        this.actionPerformed = actionPerformed;
        this.applicationCode = applicationCode;
        this.whenActionWasPerformed = new Date(whenActionWasPerformed.getTime());
        this.clientIpAddress = clientIpAddress;
        this.serverIpAddress = serverIpAddress;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getResourceOperatedUpon() {
        return this.resourceOperatedUpon;
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public Date getWhenActionWasPerformed() {
        return new Date(this.whenActionWasPerformed.getTime());
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }
}

