/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.ByteBufferInputStream;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.processor.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentInfo {
    private static final Logger log = LoggerFactory.getLogger(AssignmentInfo.class);
    public final int version;
    public final List<TaskId> activeTasks;
    public final Map<TaskId, Set<TopicPartition>> standbyTasks;

    public AssignmentInfo(List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks) {
        this(1, activeTasks, standbyTasks);
    }

    protected AssignmentInfo(int version, List<TaskId> activeTasks, Map<TaskId, Set<TopicPartition>> standbyTasks) {
        this.version = version;
        this.activeTasks = activeTasks;
        this.standbyTasks = standbyTasks;
    }

    public ByteBuffer encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            if (this.version == 1) {
                out.writeInt(1);
                out.writeInt(this.activeTasks.size());
                for (TaskId taskId : this.activeTasks) {
                    taskId.writeTo(out);
                }
                out.writeInt(this.standbyTasks.size());
                for (Map.Entry entry : this.standbyTasks.entrySet()) {
                    TaskId id = (TaskId)entry.getKey();
                    id.writeTo(out);
                    Set partitions = (Set)entry.getValue();
                    out.writeInt(partitions.size());
                    for (TopicPartition partition : partitions) {
                        out.writeUTF(partition.topic());
                        out.writeInt(partition.partition());
                    }
                }
                out.flush();
                out.close();
                return ByteBuffer.wrap(baos.toByteArray());
            }
            TaskAssignmentException ex = new TaskAssignmentException("Unable to encode assignment data: version=" + this.version);
            log.error(ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to encode AssignmentInfo", ex);
        }
    }

    public static AssignmentInfo decode(ByteBuffer data) {
        data.rewind();
        DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(data));
        try {
            int version = in.readInt();
            if (version == 1) {
                int count = in.readInt();
                ArrayList<TaskId> activeTasks = new ArrayList<TaskId>(count);
                for (int i = 0; i < count; ++i) {
                    activeTasks.add(TaskId.readFrom(in));
                }
                count = in.readInt();
                HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>(count);
                for (int i = 0; i < count; ++i) {
                    TaskId id = TaskId.readFrom(in);
                    int numPartitions = in.readInt();
                    HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(numPartitions);
                    for (int j = 0; j < numPartitions; ++j) {
                        partitions.add(new TopicPartition(in.readUTF(), in.readInt()));
                    }
                    standbyTasks.put(id, partitions);
                }
                return new AssignmentInfo(activeTasks, standbyTasks);
            }
            TaskAssignmentException ex = new TaskAssignmentException("Unknown assignment data version: " + version);
            log.error(ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        catch (IOException ex) {
            throw new TaskAssignmentException("Failed to decode AssignmentInfo", ex);
        }
    }

    public int hashCode() {
        return this.version ^ this.activeTasks.hashCode() ^ this.standbyTasks.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AssignmentInfo) {
            AssignmentInfo other = (AssignmentInfo)o;
            return this.version == other.version && this.activeTasks.equals(other.activeTasks) && this.standbyTasks.equals(other.standbyTasks);
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.version + ", active tasks=" + this.activeTasks.size() + ", standby tasks=" + this.standbyTasks.size() + "]";
    }
}

