/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;

public class SourceNode<K, V>
extends ProcessorNode<K, V> {
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valDeserializer;
    private ProcessorContext context;

    public SourceNode(String name, Deserializer<K> keyDeserializer, Deserializer<V> valDeserializer) {
        super(name);
        this.keyDeserializer = keyDeserializer;
        this.valDeserializer = valDeserializer;
    }

    public K deserializeKey(String topic, byte[] data) {
        return (K)this.keyDeserializer.deserialize(topic, data);
    }

    public V deserializeValue(String topic, byte[] data) {
        return (V)this.valDeserializer.deserialize(topic, data);
    }

    @Override
    public void init(ProcessorContext context) {
        this.context = context;
        if (this.keyDeserializer == null) {
            this.keyDeserializer = context.keySerde().deserializer();
        }
        if (this.valDeserializer == null) {
            this.valDeserializer = context.valueSerde().deserializer();
        }
        if (this.valDeserializer instanceof ChangedDeserializer && ((ChangedDeserializer)this.valDeserializer).inner() == null) {
            ((ChangedDeserializer)this.valDeserializer).setInner(context.valueSerde().deserializer());
        }
    }

    @Override
    public void process(K key, V value) {
        this.context.forward(key, value);
    }

    @Override
    public void close() {
    }

    public Deserializer<V> valueDeserializer() {
        return this.valDeserializer;
    }
}

