/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

public class ProcessorNode<K, V> {
    private final List<ProcessorNode<?, ?>> children;
    private final String name;
    private final Processor<K, V> processor;
    public final Set<String> stateStores;

    public ProcessorNode(String name) {
        this(name, null, null);
    }

    public ProcessorNode(String name, Processor<K, V> processor, Set<String> stateStores) {
        this.name = name;
        this.processor = processor;
        this.children = new ArrayList();
        this.stateStores = stateStores;
    }

    public final String name() {
        return this.name;
    }

    public final Processor<K, V> processor() {
        return this.processor;
    }

    public final List<ProcessorNode<?, ?>> children() {
        return this.children;
    }

    public void addChild(ProcessorNode<?, ?> child) {
        this.children.add(child);
    }

    public void init(ProcessorContext context) {
        this.processor.init(context);
    }

    public void process(K key, V value) {
        this.processor.process(key, value);
    }

    public void close() {
        this.processor.close();
    }
}

