/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StreamThread;

public abstract class AbstractTask {
    protected final TaskId id;
    protected final String applicationId;
    protected final ProcessorTopology topology;
    protected final Consumer consumer;
    protected final ProcessorStateManager stateMgr;
    protected final Set<TopicPartition> partitions;
    protected ProcessorContext processorContext;

    protected AbstractTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, Consumer<byte[], byte[]> restoreConsumer, StreamsConfig config, boolean isStandby) {
        this.id = id;
        this.applicationId = applicationId;
        this.partitions = new HashSet<TopicPartition>(partitions);
        this.topology = topology;
        this.consumer = consumer;
        try {
            File applicationStateDir = StreamThread.makeStateDir(applicationId, config.getString("state.dir"));
            File stateFile = new File(applicationStateDir.getCanonicalPath(), id.toString());
            this.stateMgr = new ProcessorStateManager(applicationId, id.partition, partitions, stateFile, restoreConsumer, isStandby);
        }
        catch (IOException e) {
            throw new ProcessorStateException("Error while creating the state manager", e);
        }
    }

    protected void initializeStateStores() {
        this.initializeOffsetLimits();
        for (StateStoreSupplier stateStoreSupplier : this.topology.stateStoreSuppliers()) {
            StateStore store = stateStoreSupplier.get();
            store.init(this.processorContext, store);
        }
    }

    public final TaskId id() {
        return this.id;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public final ProcessorTopology topology() {
        return this.topology;
    }

    public final ProcessorContext context() {
        return this.processorContext;
    }

    public abstract void commit();

    public void close() {
        try {
            this.stateMgr.close(this.recordCollectorOffsets());
        }
        catch (IOException e) {
            throw new ProcessorStateException("Error while closing the state manager", e);
        }
    }

    protected Map<TopicPartition, Long> recordCollectorOffsets() {
        return Collections.emptyMap();
    }

    protected void initializeOffsetLimits() {
        Iterator<TopicPartition> i$ = this.partitions.iterator();
        while (i$.hasNext()) {
            TopicPartition partition;
            OffsetAndMetadata metadata = this.consumer.committed(partition = i$.next());
            this.stateMgr.putOffsetLimit(partition, metadata != null ? metadata.offset() : 0L);
        }
    }
}

