/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRendererWrapper;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jmeter.visualizers.StatGraphVisualizer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.ObjectTableSorter;
import org.apache.jorphan.gui.RendererUtils;

public class StatVisualizer
extends AbstractVisualizer
implements Clearable,
ActionListener {
    private static final long serialVersionUID = 241L;
    private static final String USE_GROUP_NAME = "useGroupName";
    private static final String SAVE_HEADERS = "saveHeaders";
    private final String TOTAL_ROW_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
    private JTable myJTable;
    private JScrollPane myScrollPane;
    private final JButton saveTable = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save_table"));
    private final JCheckBox saveHeaders = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_save_table_header"), true);
    private final JCheckBox useGroupName = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_use_group_name"));
    private final int REFRESH_PERIOD = JMeterUtils.getPropDefault((String)"jmeter.gui.refresh_period", (int)500);
    private transient ObjectTableModel model;
    private final transient Object lock = new Object();
    private final Map<String, SamplingStatCalculator> tableRows = new ConcurrentHashMap<String, SamplingStatCalculator>();
    private Deque<SamplingStatCalculator> newRows = new ConcurrentLinkedDeque<SamplingStatCalculator>();

    public StatVisualizer() {
        this.model = StatGraphVisualizer.createObjectTableModel();
        this.clearData();
        this.init();
    }

    @Deprecated
    public static boolean testFunctors() {
        StatVisualizer instance = new StatVisualizer();
        return instance.model.checkFunctors(null, instance.getClass());
    }

    public String getLabelResource() {
        return "aggregate_report";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SampleResult res) {
        SamplingStatCalculator row;
        SamplingStatCalculator samplingStatCalculator = row = this.tableRows.computeIfAbsent(res.getSampleLabel(this.useGroupName.isSelected()), label -> {
            SamplingStatCalculator newRow = new SamplingStatCalculator(label);
            this.newRows.add(newRow);
            return newRow;
        });
        synchronized (samplingStatCalculator) {
            row.addSample(res);
        }
        SamplingStatCalculator tot = this.tableRows.get(this.TOTAL_ROW_LABEL);
        Object object = this.lock;
        synchronized (object) {
            tot.addSample(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.model.clearData();
            this.tableRows.clear();
            this.newRows.clear();
            this.tableRows.put(this.TOTAL_ROW_LABEL, new SamplingStatCalculator(this.TOTAL_ROW_LABEL));
            this.model.addRow((Object)this.tableRows.get(this.TOTAL_ROW_LABEL));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        this.myJTable = new JTable((TableModel)this.model);
        this.myJTable.setRowSorter((RowSorter<? extends TableModel>)new ObjectTableSorter(this.model).fixLastRow());
        JMeterUtils.applyHiDPI((JTable)this.myJTable);
        HeaderAsPropertyRendererWrapper.setupDefaultRenderer((JTable)this.myJTable, (Object[][])StatGraphVisualizer.getColumnsMsgParameters());
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        RendererUtils.applyRenderers((JTable)this.myJTable, (TableCellRenderer[])StatGraphVisualizer.getRenderers());
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.add(mainPanel, "North");
        this.add(this.myScrollPane, "Center");
        this.saveTable.addActionListener(this);
        JPanel opts = new JPanel();
        opts.add((Component)this.useGroupName, "West");
        opts.add((Component)this.saveTable, "Center");
        opts.add((Component)this.saveHeaders, "East");
        this.add(opts, "South");
        new Timer(this.REFRESH_PERIOD, e -> {
            Object object = this.lock;
            synchronized (object) {
                while (!this.newRows.isEmpty()) {
                    this.model.insertRow((Object)this.newRows.pop(), this.model.getRowCount() - 1);
                }
            }
            this.model.fireTableDataChanged();
        }).start();
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty(USE_GROUP_NAME, this.useGroupName.isSelected(), false);
        c.setProperty(SAVE_HEADERS, this.saveHeaders.isSelected(), true);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.useGroupName.setSelected(el.getPropertyAsBoolean(USE_GROUP_NAME, false));
        this.saveHeaders.setSelected(el.getPropertyAsBoolean(SAVE_HEADERS, true));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.saveTable) {
            JFileChooser chooser = FileDialoger.promptToSaveFile((String)"aggregate.csv");
            if (chooser == null) {
                return;
            }
            try (FileOutputStream fo = new FileOutputStream(chooser.getSelectedFile());
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fo, Charset.forName("UTF-8"));){
                CSVSaveService.saveCSVStats(StatGraphVisualizer.getAllTableData(this.model, StatGraphVisualizer.getFormatters()), (Writer)writer, (String[])(this.saveHeaders.isSelected() ? StatGraphVisualizer.getLabels(StatGraphVisualizer.getColumns()) : null));
            }
            catch (IOException e) {
                JMeterUtils.reportErrorToUser((String)e.getMessage(), (String)"Error saving data");
            }
        }
    }
}

