/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThroughputController
extends GenericController
implements Serializable,
LoopIterationListener,
TestStateListener {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggerFactory.getLogger(ThroughputController.class);
    public static final int BYNUMBER = 0;
    public static final int BYPERCENT = 1;
    private static final String STYLE = "ThroughputController.style";
    private static final String PERTHREAD = "ThroughputController.perThread";
    private static final String MAXTHROUGHPUT = "ThroughputController.maxThroughput";
    private static final String PERCENTTHROUGHPUT = "ThroughputController.percentThroughput";
    private transient MutableInteger globalNumExecutions;
    private transient MutableInteger globalIteration;
    private transient Object counterLock = new Object();
    private int numExecutions = 0;
    private int iteration = -1;
    private boolean runThisTime;

    public ThroughputController() {
        this.setStyle(0);
        this.setPerThread(true);
        this.setMaxThroughput(1);
        this.setPercentThroughput(100.0f);
        this.runThisTime = false;
    }

    public void setStyle(int style) {
        this.setProperty((JMeterProperty)new IntegerProperty(STYLE, style));
    }

    public int getStyle() {
        return this.getPropertyAsInt(STYLE);
    }

    public void setPerThread(boolean perThread) {
        this.setProperty((JMeterProperty)new BooleanProperty(PERTHREAD, perThread));
    }

    public boolean isPerThread() {
        return this.getPropertyAsBoolean(PERTHREAD);
    }

    public void setMaxThroughput(int maxThroughput) {
        this.setProperty((JMeterProperty)new IntegerProperty(MAXTHROUGHPUT, maxThroughput));
    }

    public void setMaxThroughput(String maxThroughput) {
        this.setProperty((JMeterProperty)new StringProperty(MAXTHROUGHPUT, maxThroughput));
    }

    public String getMaxThroughput() {
        return this.getPropertyAsString(MAXTHROUGHPUT);
    }

    protected int getMaxThroughputAsInt() {
        JMeterProperty prop = this.getProperty(MAXTHROUGHPUT);
        int retVal = 1;
        if (prop instanceof IntegerProperty) {
            retVal = ((IntegerProperty)prop).getIntValue();
        } else {
            String valueString = prop.getStringValue();
            try {
                retVal = Integer.parseInt(valueString);
            }
            catch (NumberFormatException e) {
                log.warn("Error parsing '{}'", (Object)valueString, (Object)e);
            }
        }
        return retVal;
    }

    public void setPercentThroughput(float percentThroughput) {
        this.setProperty((JMeterProperty)new FloatProperty(PERCENTTHROUGHPUT, percentThroughput));
    }

    public void setPercentThroughput(String percentThroughput) {
        this.setProperty((JMeterProperty)new StringProperty(PERCENTTHROUGHPUT, percentThroughput));
    }

    public String getPercentThroughput() {
        return this.getPropertyAsString(PERCENTTHROUGHPUT);
    }

    protected float getPercentThroughputAsFloat() {
        JMeterProperty prop = this.getProperty(PERCENTTHROUGHPUT);
        float retVal = 100.0f;
        if (prop instanceof FloatProperty) {
            retVal = ((FloatProperty)prop).getFloatValue();
        } else {
            String valueString = prop.getStringValue();
            try {
                retVal = Float.parseFloat(valueString);
            }
            catch (NumberFormatException e) {
                log.warn("Error parsing '{}'", (Object)valueString, (Object)e);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getExecutions() {
        if (!this.isPerThread()) {
            Object object = this.counterLock;
            synchronized (object) {
                return this.globalNumExecutions.intValue();
            }
        }
        return this.numExecutions;
    }

    public Sampler next() {
        if (this.runThisTime) {
            return super.next();
        }
        return null;
    }

    private boolean decide(int executions, int iterations) {
        if (this.getStyle() == 0) {
            return executions < this.getMaxThroughputAsInt();
        }
        return (100.0 * (double)executions + 50.0) / (double)(iterations + 1) < (double)this.getPercentThroughputAsFloat();
    }

    public boolean isDone() {
        if (this.subControllersAndSamplers.isEmpty()) {
            return true;
        }
        return this.getStyle() == 0 && this.getExecutions() >= this.getMaxThroughputAsInt() && this.current >= this.getSubControllers().size();
    }

    public Object clone() {
        ThroughputController clone = (ThroughputController)super.clone();
        clone.numExecutions = this.numExecutions;
        clone.iteration = this.iteration;
        clone.runThisTime = false;
        clone.globalIteration = this.globalIteration;
        clone.globalNumExecutions = this.globalNumExecutions;
        clone.counterLock = this.counterLock;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterationStart(LoopIterationEvent iterEvent) {
        if (!this.isPerThread()) {
            Object object = this.counterLock;
            synchronized (object) {
                this.globalIteration.incr();
                this.runThisTime = this.decide(this.globalNumExecutions.intValue(), this.globalIteration.intValue());
                if (this.runThisTime) {
                    this.globalNumExecutions.incr();
                }
            }
        } else {
            ++this.iteration;
            this.runThisTime = this.decide(this.numExecutions, this.iteration);
            if (this.runThisTime) {
                ++this.numExecutions;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted() {
        Object object = this.counterLock;
        synchronized (object) {
            this.globalNumExecutions = new MutableInteger(0);
            this.globalIteration = new MutableInteger(-1);
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String host) {
    }

    protected Object readResolve() {
        super.readResolve();
        this.counterLock = new Object();
        return this;
    }

    private static class MutableInteger {
        private int integer;

        MutableInteger(int value) {
            this.integer = value;
        }

        int incr() {
            return ++this.integer;
        }

        public int intValue() {
            return this.integer;
        }
    }
}

