/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseTimeToLiveResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.LeaseOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchResponse;
import io.netty.util.CharsetUtil;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdRegistryServiceImpl
implements RegistryService<Watch.Listener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdRegistryServiceImpl.class);
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "etcd3";
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String REGISTRY_CLUSTER = "cluster";
    private static final String DEFAULT_CLUSTER_NAME = "default";
    private static final String REGISTRY_KEY_PREFIX = "registry-seata-";
    private static final String FILE_CONFIG_KEY_PREFIX = "registry.etcd3.";
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final int THREAD_POOL_SIZE = 2;
    private ExecutorService executorService;
    private static final long TTL = 10L;
    private static final long LIFE_KEEP_INTERVAL = 5L;
    private static final long LIFE_KEEP_CRITICAL = 6L;
    private static volatile EtcdRegistryServiceImpl instance;
    private static volatile Client client;
    private ConcurrentMap<String, Pair<Long, List<InetSocketAddress>>> clusterAddressMap = new ConcurrentHashMap<String, Pair<Long, List<InetSocketAddress>>>(8);
    private ConcurrentMap<String, Set<Watch.Listener>> listenerMap = new ConcurrentHashMap<String, Set<Watch.Listener>>(8);
    private ConcurrentMap<String, EtcdWatcher> watcherMap = new ConcurrentHashMap<String, EtcdWatcher>(8);
    private static long leaseId;
    private EtcdLifeKeeper lifeKeeper = null;
    private Future<Boolean> lifeKeeperFuture = null;
    public static final String TEST_ENDPONT = "etcd-test-lancher-endpoint";

    private EtcdRegistryServiceImpl() {
        this.executorService = new ThreadPoolExecutor(2, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("registry-etcd3", 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static EtcdRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<EtcdRegistryServiceImpl> clazz = EtcdRegistryServiceImpl.class;
        synchronized (EtcdRegistryServiceImpl.class) {
            if (null != instance) return instance;
            instance = new EtcdRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        this.doRegister(address);
    }

    private void doRegister(InetSocketAddress address) throws Exception {
        PutOption putOption = PutOption.newBuilder().withLeaseId(this.getLeaseId()).build();
        this.getClient().getKVClient().put(this.buildRegistryKey(address), this.buildRegistryValue(address), putOption).get();
    }

    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        this.doUnregister(address);
    }

    private void doUnregister(InetSocketAddress address) throws Exception {
        this.getClient().getKVClient().delete(this.buildRegistryKey(address)).get();
    }

    public void subscribe(String cluster, Watch.Listener listener) throws Exception {
        this.listenerMap.putIfAbsent(cluster, new HashSet());
        ((Set)this.listenerMap.get(cluster)).add(listener);
        EtcdWatcher watcher = this.watcherMap.computeIfAbsent(cluster, w -> new EtcdWatcher(cluster, listener));
        this.executorService.submit(watcher);
    }

    public void unsubscribe(String cluster, Watch.Listener listener) throws Exception {
        Set subscribeSet = (Set)this.listenerMap.get(cluster);
        if (null != subscribeSet) {
            HashSet<Watch.Listener> newSubscribeSet = new HashSet<Watch.Listener>();
            for (Watch.Listener eventListener : subscribeSet) {
                if (eventListener.equals(listener)) continue;
                newSubscribeSet.add(eventListener);
            }
            this.listenerMap.put(cluster, newSubscribeSet);
        }
        ((EtcdWatcher)this.watcherMap.remove(cluster)).stop();
    }

    public List<InetSocketAddress> lookup(String key) throws Exception {
        final String cluster = this.getServiceGroup(key);
        if (null == cluster) {
            return null;
        }
        if (!this.listenerMap.containsKey(cluster)) {
            this.refreshCluster(cluster);
            this.subscribe(cluster, new Watch.Listener(){

                public void onNext(WatchResponse response) {
                    try {
                        EtcdRegistryServiceImpl.this.refreshCluster(cluster);
                    }
                    catch (Exception e) {
                        LOGGER.error("etcd watch listener", (Throwable)e);
                        throw new RuntimeException(e.getMessage());
                    }
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
        }
        return (List)((Pair)this.clusterAddressMap.get(cluster)).getValue();
    }

    public void close() throws Exception {
        if (null != this.lifeKeeper) {
            this.lifeKeeper.stop();
            if (null != this.lifeKeeperFuture) {
                this.lifeKeeperFuture.get(3L, TimeUnit.SECONDS);
            }
        }
    }

    private void refreshCluster(String cluster) throws Exception {
        if (null == cluster) {
            return;
        }
        GetOption getOption = GetOption.newBuilder().withPrefix(this.buildRegistryKeyPrefix()).build();
        GetResponse getResponse = (GetResponse)this.getClient().getKVClient().get(this.buildRegistryKeyPrefix(), getOption).get();
        List instanceList = getResponse.getKvs().stream().map(keyValue -> {
            String[] instanceInfo = keyValue.getValue().toString(CharsetUtil.UTF_8).split(":");
            return new InetSocketAddress(instanceInfo[0], Integer.parseInt(instanceInfo[1]));
        }).collect(Collectors.toList());
        this.clusterAddressMap.put(cluster, new Pair(getResponse.getHeader().getRevision(), instanceList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Client getClient() {
        if (null != client) return client;
        Class<EtcdRegistryServiceImpl> clazz = EtcdRegistryServiceImpl.class;
        synchronized (EtcdRegistryServiceImpl.class) {
            if (null != client) return client;
            String testEndpoint = System.getProperty(TEST_ENDPONT);
            client = StringUtils.isNotBlank((String)testEndpoint) ? Client.builder().endpoints(new String[]{testEndpoint}).build() : Client.builder().endpoints(new String[]{FILE_CONFIG.getConfig("registry.etcd3.serverAddr")}).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return client;
        }
    }

    private String getServiceGroup(String key) {
        String clusterNameKey = "service.vgroup_mapping." + key;
        return ConfigurationFactory.getInstance().getConfig(clusterNameKey);
    }

    private String getClusterName() {
        String clusterConfigName = "registry.etcd3.cluster";
        return FILE_CONFIG.getConfig(clusterConfigName, DEFAULT_CLUSTER_NAME);
    }

    private long getLeaseId() throws Exception {
        if (0L == leaseId) {
            leaseId = ((LeaseGrantResponse)this.getClient().getLeaseClient().grant(10L).get()).getID();
            this.lifeKeeper = new EtcdLifeKeeper(leaseId);
            this.lifeKeeperFuture = this.executorService.submit(this.lifeKeeper);
        }
        return leaseId;
    }

    private ByteSequence buildRegistryKey(InetSocketAddress address) {
        return ByteSequence.from((String)(REGISTRY_KEY_PREFIX + this.getClusterName() + "-" + NetUtil.toStringAddress((InetSocketAddress)address)), (Charset)CharsetUtil.UTF_8);
    }

    private ByteSequence buildRegistryKeyPrefix() {
        return ByteSequence.from((String)(REGISTRY_KEY_PREFIX + this.getClusterName()), (Charset)CharsetUtil.UTF_8);
    }

    private ByteSequence buildRegistryValue(InetSocketAddress address) {
        return ByteSequence.from((String)NetUtil.toStringAddress((InetSocketAddress)address), (Charset)CharsetUtil.UTF_8);
    }

    static {
        leaseId = 0L;
    }

    private static class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    private class EtcdWatcher
    implements Runnable {
        private final Watch.Listener listener;
        private Watch.Watcher watcher;
        private String cluster;

        public EtcdWatcher(String cluster, Watch.Listener listener) {
            this.cluster = cluster;
            this.listener = listener;
        }

        @Override
        public void run() {
            Watch watchClient = EtcdRegistryServiceImpl.this.getClient().getWatchClient();
            WatchOption.Builder watchOptionBuilder = WatchOption.newBuilder().withPrefix(EtcdRegistryServiceImpl.this.buildRegistryKeyPrefix());
            Pair addressPair = (Pair)EtcdRegistryServiceImpl.this.clusterAddressMap.get(this.cluster);
            if (Objects.nonNull(addressPair)) {
                watchOptionBuilder.withRevision(((Long)addressPair.getKey()).longValue());
            }
            this.watcher = watchClient.watch(EtcdRegistryServiceImpl.this.buildRegistryKeyPrefix(), watchOptionBuilder.build(), this.listener);
        }

        public void stop() {
            this.watcher.close();
        }
    }

    private class EtcdLifeKeeper
    implements Callable<Boolean> {
        private final long leaseId;
        private final Lease leaseClient;
        private boolean running;

        public EtcdLifeKeeper(long leaseId) {
            this.leaseClient = EtcdRegistryServiceImpl.this.getClient().getLeaseClient();
            this.leaseId = leaseId;
            this.running = true;
        }

        private void process() {
            try {
                while (true) {
                    LeaseTimeToLiveResponse leaseTimeToLiveResponse;
                    long tTl;
                    if ((tTl = (leaseTimeToLiveResponse = (LeaseTimeToLiveResponse)this.leaseClient.timeToLive(this.leaseId, LeaseOption.DEFAULT).get()).getTTl()) <= 6L) {
                        this.leaseClient.keepAliveOnce(this.leaseId).get();
                    }
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
            catch (Exception e) {
                LOGGER.error("EtcdLifeKeeper", (Throwable)e);
                throw new ShouldNeverHappenException("failed to renewal the lease.");
            }
        }

        public void stop() {
            this.running = false;
        }

        @Override
        public Boolean call() {
            if (this.running) {
                this.process();
            }
            return this.running;
        }
    }
}

