package com.viontech.keliu.storage;

import com.viontech.keliu.oss.S3ClientHelper;
import com.viontech.keliu.storage.pathgenerator.PathStorage;

/**
 * .
 *
 * @author 谢明辉
 * @date 2020/12/23
 */

public class S3Storage<T> extends PathStorage<T> {

    private final S3ClientHelper s3ClientHelper;

    public S3Storage(S3ClientHelper s3ClientHelper) {
        this.s3ClientHelper = s3ClientHelper;
    }

    @Override
    public void setItem(String key, T item) {
        s3ClientHelper.storeFile(storagePathGenerator.generator(key), getConvert().object2bytes(item));
    }

    @Override
    public T getItem(String key) {
        try {
            return getConvert().bytes2Object(getByteArrayItem(key));
        } catch (Exception ignore) {
        }
        return null;
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return s3ClientHelper.getByteArrayImage(storagePathGenerator.generator(key));
        } catch (Exception e) {
        }
        return null;
    }

    @Override
    public boolean isItemExist(String key) {
        return s3ClientHelper.isExist(storagePathGenerator.generator(key));
    }

    @Override
    public boolean deleteItem(String key) {
        return s3ClientHelper.deleteItem(storagePathGenerator.generator(key));
    }
}
