package com.viontech.keliu.configuration;

import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.OssStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.convert.BufferedImageConvert;
import com.viontech.keliu.storage.convert.ByteArrayConvert;
import com.viontech.keliu.storage.convert.StringConvert;
import com.viontech.keliu.storage.pathgenerator.StoragePathGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * imageStorage
 * featureStorage
 * simpleStringStorage
 * simpleImageStorage
 * byteArrayStorage
 * simpleByteArrayStorage
 *
 * @author 谢明辉
 * @date 2020/12/29
 */
@Configuration
@ConditionalOnBean(OssClientHelper.class)
public class OssStorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OssStorageConfiguration.class);

    @Bean("imageStorage")
    public Storage ossImageStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS imageStorage==================");
        OssStorage ossImageStorage = new OssStorage();
        ossImageStorage.setConvert(new BufferedImageConvert());
        ossImageStorage.setOssClientHelper(ossClientHelper);
        ossImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ossImageStorage;
    }

    /**
     * 特征存储器
     */
    @Bean("featureStorage")
    public Storage ossFeatureStorage(StoragePathGenerator featurePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS featureStorage==================");
        OssStorage ossFeatureStorage = new OssStorage();
        ossFeatureStorage.setConvert(new StringConvert());
        ossFeatureStorage.setOssClientHelper(ossClientHelper);
        ossFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ossFeatureStorage;
    }

    /**
     * 配置一个oss轨迹文件存储器
     */
    @Bean("simpleStringStorage")
    public Storage simpleStringStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS simpleStringStorage==================");
        OssStorage simpleStorage = new OssStorage();
        simpleStorage.setConvert(new StringConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    /**
     * 配置一个 oss 无路径优化的图像存储
     */
    @Bean("simpleImageStorage")
    public Storage simpleImageStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS simpleImageStorage==================");
        OssStorage simpleStorage = new OssStorage();
        simpleStorage.setConvert(new BufferedImageConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

    /**
     * 字节数组存储器
     */
    @Bean("byteArrayStorage")
    public Storage byteArrayStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS byteArrayStorage==================");
        OssStorage<byte[]> byteArrayStorage = new OssStorage();
        byteArrayStorage.setConvert(new ByteArrayConvert());
        byteArrayStorage.setOssClientHelper(ossClientHelper);
        byteArrayStorage.setStoragePathGenerator(imagePathGenerator);
        return byteArrayStorage;
    }

    @Bean("simpleByteArrayStorage")
    public Storage simpleByteArrayStorage(StoragePathGenerator simplePathGenerator, OssClientHelper ossClientHelper) {
        logger.info("=============OSS simpleByteArrayStorage==================");
        OssStorage simpleStorage = new OssStorage();
        simpleStorage.setConvert(new ByteArrayConvert());
        simpleStorage.setOssClientHelper(ossClientHelper);
        simpleStorage.setStoragePathGenerator(simplePathGenerator);
        return simpleStorage;
    }

}
