package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FTPClientFactory;
import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.ftp.FTPClientPool;
import com.viontech.keliu.ftp.FtpPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FtpConfiguration {
	
	@Value("${ftp.host:127.0.0.1}")
    private  String host;//主机名
	@Value("${ftp.port:21}")
    private  int port;//端口
	@Value("${ftp.username:}")
    private  String username;//用户名
	@Value("${ftp.password:}")
    private  String password;//密码
	@Value("${ftp.tempPath:}")
	private String tempPath;

	public FtpConfiguration() {

	}

	@Bean("ftpPoolConfig")
	@ConditionalOnProperty(name = "ftp.host")
	public FtpPoolConfig ftpPoolConfig(){
		FtpPoolConfig ftpPoolConfig = new FtpPoolConfig();
		ftpPoolConfig.setHost(host);
		ftpPoolConfig.setPort(port);
		ftpPoolConfig.setUsername(username);
		ftpPoolConfig.setPassword(password);
		//ftpPoolConfig.setMaxWaitMillis(1000);
		//ftpPoolConfig.setMaxIdle(2);
		return ftpPoolConfig;
	}

	@Bean("ftpClientFactory")
	@ConditionalOnBean(FtpPoolConfig.class)
	public FTPClientFactory ftpClientFactory(FtpPoolConfig ftpPoolConfig){
		FTPClientFactory ftpClientFactory = new FTPClientFactory();
		ftpClientFactory.setFtpPoolConfig(ftpPoolConfig);
		return ftpClientFactory;
	}
	@Bean("ftpClientPool")
	@ConditionalOnBean(FTPClientFactory.class)
	public FTPClientPool ftpClientPool(FTPClientFactory ftpClientFactory){
		FTPClientPool ftpClientPool = new FTPClientPool(ftpClientFactory);
		return ftpClientPool;
	}

	@Bean("ftpClientHelper")
	@ConditionalOnBean(FTPClientPool.class)
	public FTPClientHelper ftpClientHelper(FTPClientPool ftpClientPool){
		FTPClientHelper ftpClientHelper = new FTPClientHelper();
		ftpClientHelper.setFtpClientPool(ftpClientPool);
		if(!tempPath.trim().isEmpty())
			ftpClientHelper.setTempPath(tempPath);
		return ftpClientHelper;
	}
	
}
