/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.ftp.FTPClientFactory;
import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.ftp.FTPClientPool;
import com.viontech.keliu.ftp.FtpPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FtpConfiguration {
    @Value(value="${ftp.host:127.0.0.1}")
    private String host;
    @Value(value="${ftp.port:21}")
    private int port;
    @Value(value="${ftp.username:}")
    private String username;
    @Value(value="${ftp.password:}")
    private String password;
    @Value(value="${ftp.tempPath:}")
    private String tempPath;

    @Bean(value={"ftpPoolConfig"})
    @ConditionalOnProperty(name={"ftp.host"})
    public FtpPoolConfig ftpPoolConfig() {
        FtpPoolConfig ftpPoolConfig = new FtpPoolConfig();
        ftpPoolConfig.setHost(this.host);
        ftpPoolConfig.setPort(this.port);
        ftpPoolConfig.setUsername(this.username);
        ftpPoolConfig.setPassword(this.password);
        return ftpPoolConfig;
    }

    @Bean(value={"ftpClientFactory"})
    @ConditionalOnBean(value={FtpPoolConfig.class})
    public FTPClientFactory ftpClientFactory(FtpPoolConfig ftpPoolConfig) {
        FTPClientFactory ftpClientFactory = new FTPClientFactory();
        ftpClientFactory.setFtpPoolConfig(ftpPoolConfig);
        return ftpClientFactory;
    }

    @Bean(value={"ftpClientPool"})
    @ConditionalOnBean(value={FTPClientFactory.class})
    public FTPClientPool ftpClientPool(FTPClientFactory ftpClientFactory) {
        FTPClientPool ftpClientPool = new FTPClientPool(ftpClientFactory);
        return ftpClientPool;
    }

    @Bean(value={"ftpClientHelper"})
    @ConditionalOnBean(value={FTPClientPool.class})
    public FTPClientHelper ftpClientHelper(FTPClientPool ftpClientPool) {
        FTPClientHelper ftpClientHelper = new FTPClientHelper();
        ftpClientHelper.setFtpClientPool(ftpClientPool);
        if (!this.tempPath.trim().isEmpty()) {
            ftpClientHelper.setTempPath(this.tempPath);
        }
        return ftpClientHelper;
    }
}

