package com.viontech.keliu.storage.pathgenerator;

/**
 * Created by vion on 2018/8/7.
 */
public class StorageDatePathGenerator implements StoragePathGenerator {
    private String pathPrefix = null;
    private String pathPostfix = null;
    private boolean subDate = true;
    private String basePath="";
    @Override
    public String generator(String name) {
        StringBuilder result = new StringBuilder();
        if (pathPrefix != null) {
            result.append(pathPrefix);
        }
        if (pathPostfix != null) {
            if (name.endsWith(pathPostfix)) {
                name = name.substring(0, name.lastIndexOf(pathPostfix));
            }
        }
        if (name.contains("face")) {
            result.append("face").append("/");
        } else if (name.contains("body")) {
            result.append("body").append("/");
        }
        if (name.length() > 25&&subDate) {
            String dateStr = name.substring(name.length() - 25, name.length() - 17);
            result.append(dateStr).append("/");
        }
        result.append(name);
        if (pathPostfix != null) {
            result.append(pathPostfix);
        }

        return result.toString();
    }

    public String getPathPrefix() {
        return pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPostfix() {
        return pathPostfix;
    }

    public void setPathPostfix(String pathPostfix) {
        this.pathPostfix = pathPostfix;
    }

    public boolean isSubDate() {
        return subDate;
    }

    public void setSubDate(boolean subDate) {
        this.subDate = subDate;
    }

    public String getBasePath() {
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}
