/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.mybatis3.controller;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.messages.Messages;

public class ControllerBaseGenerator
extends AbstractJavaGenerator {
    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.8", table.toString()));
        Plugin plugins = this.context.getPlugins();
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType().replace(".model", ".controller.base") + "BaseController");
        TopLevelClass topLevelClass = new TopLevelClass(type);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        topLevelClass.setAbstract(true);
        commentGenerator.addJavaFileComment(topLevelClass);
        FullyQualifiedJavaType superClass = this.getSuperClass();
        FullyQualifiedJavaType serviceType = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType().replaceAll("Mapper", "Service").replaceAll(".mapper", ".service.adapter"));
        if (superClass != null) {
            topLevelClass.setSuperClass(superClass);
            topLevelClass.addImportedType(superClass);
        }
        FullyQualifiedJavaType mapper = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType());
        topLevelClass.addImportedType(serviceType);
        topLevelClass.addImportedType(new FullyQualifiedJavaType("javax.annotation.Resource"));
        topLevelClass.addImportedType(new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType()));
        topLevelClass.addImportedType(mapper);
        Field field = new Field();
        field.addAnnotation("@Resource");
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(serviceType);
        field.setName(JavaBeansUtil.getValidPropertyName(serviceType.getShortName()));
        topLevelClass.addField(field);
        this.createGetExampleMethod(topLevelClass);
        FullyQualifiedJavaType baseServiceType = new FullyQualifiedJavaType(this.context.getBasePackage() + ".BaseService<" + this.introspectedTable.getBaseRecordType() + ">");
        topLevelClass.addImportedType(baseServiceType);
        Method method = new Method();
        method.addAnnotation("@Override");
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setConstructor(false);
        method.setName("getService");
        method.setReturnType(baseServiceType);
        method.addBodyLine("return " + JavaBeansUtil.getValidPropertyName(serviceType.getShortName()) + ";");
        topLevelClass.addMethod(method);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.context.getPlugins().modelBaseRecordClassGenerated(topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
        }
        return answer;
    }

    private void createGetExampleMethod(TopLevelClass topLevelClass) {
        Method method = new Method();
        method.addAnnotation("@Override");
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setConstructor(false);
        method.setName("getExample");
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordVoType());
        FullyQualifiedJavaType exampleType = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        Parameter parameter = new Parameter(modelType, JavaBeansUtil.getValidPropertyName(modelType.getShortName()));
        method.addParameter(parameter);
        parameter = new Parameter(FullyQualifiedJavaType.getIntInstance(), "type");
        method.addParameter(parameter);
        FullyQualifiedJavaType baseMapperType = new FullyQualifiedJavaType(this.context.getBasePackage() + ".BaseMapper<" + this.introspectedTable.getBaseRecordType() + ">");
        topLevelClass.addImportedType(baseMapperType);
        topLevelClass.addImportedType(exampleType);
        FullyQualifiedJavaType baseExample = new FullyQualifiedJavaType(this.context.getBasePackage() + ".BaseExample");
        topLevelClass.addImportedType(baseExample);
        method.setReturnType(baseExample);
        StringBuilder sb = new StringBuilder();
        sb.append(exampleType.getShortName()).append(" ").append(JavaBeansUtil.getValidPropertyName(exampleType.getShortName())).append(" = new ").append(exampleType.getShortName()).append("();");
        method.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(exampleType.getShortName()).append(".Criteria criteria = ").append(JavaBeansUtil.getValidPropertyName(exampleType.getShortName())).append(".createCriteria();");
        method.addBodyLine(sb.toString());
        List<IntrospectedColumn> introspectedColumns = this.getColumnsInThisClass();
        for (IntrospectedColumn introspectedColumn : introspectedColumns) {
            FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
            String property = introspectedColumn.getJavaProperty();
            sb.setLength(0);
            sb.append(property);
            if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            property = sb.toString();
            String getMethod = JavaBeansUtil.getGetterMethodName(property, fqjt);
            sb.setLength(0);
            sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("criteria.and").append(property).append("EqualTo(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("}");
            method.addBodyLine(sb.toString());
            if (introspectedColumn.isNullable()) {
                getMethod = JavaBeansUtil.getGetterMethodName(property + "_null", fqjt);
                sb.setLength(0);
                sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("().booleanValue()) {");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("criteria.and").append(property).append("IsNull();");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("} else {");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("criteria.and").append(property).append("IsNotNull();");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("}");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("}");
                method.addBodyLine(sb.toString());
            }
            getMethod = JavaBeansUtil.getGetterMethodName(property + "_arr", fqjt);
            sb.setLength(0);
            sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("criteria.and").append(property).append("In(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("}");
            method.addBodyLine(sb.toString());
            if (introspectedColumn.isJdbcCharacterColumn()) {
                getMethod = JavaBeansUtil.getGetterMethodName(property + "_like", fqjt);
                sb.setLength(0);
                sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("criteria.and").append(property).append("Like(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
                method.addBodyLine(sb.toString());
                sb.setLength(0);
                sb.append("}");
                method.addBodyLine(sb.toString());
                continue;
            }
            getMethod = JavaBeansUtil.getGetterMethodName(property + "_gt", fqjt);
            sb.setLength(0);
            sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("criteria.and").append(property).append("GreaterThan(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("}");
            method.addBodyLine(sb.toString());
            getMethod = JavaBeansUtil.getGetterMethodName(property + "_lt", fqjt);
            sb.setLength(0);
            sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("criteria.and").append(property).append("LessThan(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("}");
            method.addBodyLine(sb.toString());
            getMethod = JavaBeansUtil.getGetterMethodName(property + "_gte", fqjt);
            sb.setLength(0);
            sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("criteria.and").append(property).append("GreaterThanOrEqualTo(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("}");
            method.addBodyLine(sb.toString());
            getMethod = JavaBeansUtil.getGetterMethodName(property + "_lte", fqjt);
            sb.setLength(0);
            sb.append("if(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("() != null) {");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("criteria.and").append(property).append("LessThanOrEqualTo(").append(JavaBeansUtil.getValidPropertyName(modelType.getShortName())).append(".").append(getMethod).append("());");
            method.addBodyLine(sb.toString());
            sb.setLength(0);
            sb.append("}");
            method.addBodyLine(sb.toString());
        }
        method.addBodyLine("return " + JavaBeansUtil.getValidPropertyName(exampleType.getShortName()) + ";");
        topLevelClass.addMethod(method);
    }

    private FullyQualifiedJavaType getSuperClass() {
        String rootClass = this.context.getBasePackage() + ".BaseController<" + this.introspectedTable.getBaseRecordType() + "," + this.introspectedTable.getBaseRecordVoType() + ">";
        FullyQualifiedJavaType superClass = rootClass != null ? new FullyQualifiedJavaType(rootClass) : null;
        return superClass;
    }

    private List<IntrospectedColumn> getColumnsInThisClass() {
        List<IntrospectedColumn> introspectedColumns = this.includePrimaryKeyColumns() ? (this.includeBLOBColumns() ? this.introspectedTable.getAllColumns() : this.introspectedTable.getNonBLOBColumns()) : (this.includeBLOBColumns() ? this.introspectedTable.getNonPrimaryKeyColumns() : this.introspectedTable.getBaseColumns());
        return introspectedColumns;
    }

    private boolean includePrimaryKeyColumns() {
        return !this.introspectedTable.getRules().generatePrimaryKeyClass() && this.introspectedTable.hasPrimaryKeyColumns();
    }

    private boolean includeBLOBColumns() {
        return !this.introspectedTable.getRules().generateRecordWithBLOBsClass() && this.introspectedTable.hasBLOBColumns();
    }
}

